/*
 * Decompiled with CFR 0.152.
 */
package com.semmle.util.files;

import com.semmle.util.data.StringUtil;
import java.util.regex.Pattern;

public class PathMatcher {
    private final Mode mode;
    private final Pattern pattern;
    private final String originalPattern;

    public PathMatcher(String string) {
        this(Mode.Ant, string);
    }

    public PathMatcher(Mode mode, String string) {
        this.mode = mode;
        this.originalPattern = string;
        StringBuilder stringBuilder = new StringBuilder();
        this.toRegex(stringBuilder, string);
        this.pattern = Pattern.compile(stringBuilder.toString());
    }

    public PathMatcher(Iterable<String> iterable) {
        this(Mode.Ant, iterable);
    }

    public PathMatcher(Mode mode, Iterable<String> iterable) {
        this.mode = mode;
        this.originalPattern = iterable.toString();
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : iterable) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append('|');
            }
            this.toRegex(stringBuilder, string);
        }
        this.pattern = Pattern.compile(stringBuilder.toString());
    }

    private void toRegex(StringBuilder stringBuilder, String string) {
        if (string.length() == 0) {
            return;
        }
        string = string.replace('\\', '/');
        string = string.replaceAll("//+", "/");
        string = StringUtil.escapeStringLiteralForRegexp(string, "*?");
        if (this.mode == Mode.Ant && string.endsWith("/")) {
            string = string + "**";
        }
        int n = 0;
        if (this.mode == Mode.Rsync) {
            if (string.charAt(0) == '/') {
                stringBuilder.append("/?");
                ++n;
            } else {
                stringBuilder.append("(.*/)?");
            }
        }
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c == '*' && n < string.length() - 2 && string.charAt(n + 1) == '*' && string.charAt(n + 2) == '/') {
                stringBuilder.append("(?:^|.*/)");
                n += 3;
                continue;
            }
            if (c == '*' && n < string.length() - 1 && string.charAt(n + 1) == '*') {
                stringBuilder.append(".*");
                n += 2;
                continue;
            }
            if (c == '*') {
                stringBuilder.append("[^/]*");
                ++n;
                continue;
            }
            if (c == '?') {
                stringBuilder.append("[^/]");
                ++n;
                continue;
            }
            stringBuilder.append(c);
            ++n;
        }
    }

    public boolean matches(String string) {
        if ((string = string.replace('\\', '/')).endsWith("/")) {
            string = string.substring(0, string.length() - 1);
        }
        return this.pattern.matcher(string).matches();
    }

    public String toString() {
        return "Matches " + this.originalPattern + " [" + this.pattern + "]";
    }

    public static enum Mode {
        Ant,
        Rsync;

    }
}

