/*
 * Decompiled with CFR 0.152.
 */
package com.semmle.util.projectstructure;

import com.semmle.util.data.StringUtil;
import com.semmle.util.exception.CatastrophicError;
import com.semmle.util.exception.UserError;
import com.semmle.util.io.WholeIO;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ProjectLayout {
    public static final char PROJECT_NAME_PREFIX = '@';
    private String project;
    private final LinkedHashMap<String, Section> sections = new LinkedHashMap();
    private String source;

    public ProjectLayout(File file) {
        this(StringUtil.lines(new WholeIO().strictread(file)), file.toString());
    }

    public ProjectLayout(String ... stringArray) {
        this(stringArray, (String)null);
    }

    private ProjectLayout(String[] stringArray, String string) {
        this.source = string;
        String string2 = "";
        Section section = new Section("");
        this.sections.put("", section);
        int n = 0;
        block5: for (String string3 : stringArray) {
            ++n;
            if ((string3 = string3.trim()).isEmpty()) continue;
            switch (string3.charAt(0)) {
                case '@': {
                    if (this.project != null) {
                        throw ProjectLayout.error("Only one project name is allowed", string, n);
                    }
                    this.project = ProjectLayout.tail(string3);
                    continue block5;
                }
                case '#': {
                    string2 = ProjectLayout.tail(string3);
                    if (this.sections.containsKey(string2)) {
                        throw ProjectLayout.error("Duplicate virtual path prefix " + string2, string, n);
                    }
                    section = new Section(string2);
                    this.sections.put(string2, section);
                    continue block5;
                }
                case '-': {
                    section.add(new Rewrite(ProjectLayout.tail(string3), string, n));
                    continue block5;
                }
                default: {
                    section.add(new Rewrite(string3, string2, string, n));
                }
            }
        }
    }

    private static String tail(String string) {
        return string.substring(1).trim();
    }

    public String projectName() {
        if (this.project == null) {
            throw ProjectLayout.error("No project name is defined", this.source);
        }
        return this.project;
    }

    public String projectName(String string) {
        return this.project == null ? string : this.project;
    }

    public List<String> sections() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(this.sections.keySet());
        return arrayList;
    }

    public boolean sectionIsEmpty(String string) {
        if (!this.sections.containsKey(string)) {
            throw new CatastrophicError("Section does not exist: " + string);
        }
        return this.sections.get(string).isEmpty();
    }

    public void renameSection(String string, String string2) {
        if (!this.sections.containsKey(string)) {
            throw new CatastrophicError("Section does not exist: " + string);
        }
        Section section = (Section)this.sections.remove(string);
        section.rename(string2);
        this.sections.put(string2, section);
    }

    public String subLayout(String string) {
        Section section = this.sections.get(string);
        if (section == null) {
            throw new CatastrophicError("Section does not exist: " + section);
        }
        return section.toLayout();
    }

    public String artificialPath(String string) {
        if (string.length() > 0 && string.charAt(0) != '/') {
            return null;
        }
        List list = Section.prefixes(string);
        for (Section section : this.sections.values()) {
            Rewrite rewrite = section.match(list);
            String string2 = null;
            if (rewrite != null) {
                string2 = rewrite.rewrite(string);
            }
            if (string2 == null) continue;
            return string2;
        }
        return null;
    }

    public boolean includeFile(String string) {
        return this.artificialPath(string) != null;
    }

    public void writeTo(Writer writer) throws IOException {
        if (this.project != null) {
            writer.write(64);
            writer.write(this.project);
            writer.write("\n");
        }
        for (Section section : this.sections.values()) {
            if (!section.virtual.isEmpty()) {
                writer.write("#");
                writer.write(section.virtual);
                writer.write("\n");
            }
            section.outputRules(writer);
        }
    }

    public void addPattern(String string, String string2) {
        if (string2 == null || string2.isEmpty()) {
            throw new IllegalArgumentException("ProjectLayout.addPattern: pattern must be a non-empty string");
        }
        boolean bl = string2.charAt(0) == '-';
        Rewrite rewrite = bl ? new Rewrite(string2.substring(1), null, 0) : new Rewrite(string2, string, null, 0);
        Section section = this.sections.get(string);
        if (section == null) {
            section = new Section(string);
            this.sections.put(string, section);
        }
        section.add(rewrite);
    }

    private static UserError error(String string, String string2) {
        return ProjectLayout.error(string, string2, 0);
    }

    private static UserError error(String string, String string2, int n) {
        if (string2 == null) {
            return new UserError(string);
        }
        StringBuilder stringBuilder = new StringBuilder(string);
        stringBuilder.append(" (");
        if (n > 0) {
            stringBuilder.append("line ").append(n).append(" of ");
        }
        stringBuilder.append(string2).append(")");
        return new UserError(stringBuilder.toString());
    }

    private static class Section {
        private String virtual;
        private final Map<String, Rewrite> simpleRewrites;
        private final List<Rewrite> complexRewrites;

        public Section(String string) {
            this.virtual = string;
            this.simpleRewrites = new LinkedHashMap<String, Rewrite>();
            this.complexRewrites = new ArrayList<Rewrite>();
        }

        public String toLayout() {
            StringWriter stringWriter = new StringWriter();
            stringWriter.append('@').append(this.virtual).append('\n');
            try {
                this.outputRules(stringWriter);
            }
            catch (IOException iOException) {
                throw new CatastrophicError("StringWriter.append threw an IOException", iOException);
            }
            return stringWriter.toString();
        }

        private void outputRules(Writer writer) throws IOException {
            ArrayList<Rewrite> arrayList = new ArrayList<Rewrite>();
            arrayList.addAll(this.simpleRewrites.values());
            arrayList.addAll(this.complexRewrites);
            Collections.sort(arrayList, Rewrite.COMPARATOR);
            for (Rewrite rewrite : arrayList) {
                writer.append(rewrite.toString()).append('\n');
            }
        }

        public void rename(String string) {
            this.virtual = string;
            for (Rewrite rewrite : this.simpleRewrites.values()) {
                rewrite.virtual = string;
            }
            for (Rewrite rewrite : this.complexRewrites) {
                rewrite.virtual = string;
            }
        }

        public void add(Rewrite rewrite) {
            int n = this.simpleRewrites.size() + this.complexRewrites.size();
            rewrite.setIndex(n);
            if (rewrite.isSimple()) {
                this.simpleRewrites.put(rewrite.simplePrefix(), rewrite);
            } else {
                this.complexRewrites.add(rewrite);
            }
        }

        public boolean isEmpty() {
            return this.simpleRewrites.isEmpty() && this.complexRewrites.isEmpty();
        }

        private static List<String> prefixes(String string) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(string);
            int n = string.length();
            while (n > 1) {
                n = string.lastIndexOf(47, n - 1);
                arrayList.add(string.substring(0, n));
            }
            arrayList.add("/");
            return arrayList;
        }

        public Rewrite match(List<String> list) {
            Rewrite object = null;
            for (String object2 : list) {
                Rewrite rewrite = this.simpleRewrites.get(object2);
                if (rewrite == null || object != null && object.index >= rewrite.index) continue;
                object = rewrite;
            }
            for (int i = this.complexRewrites.size() - 1; i >= 0; --i) {
                Rewrite rewrite = this.complexRewrites.get(i);
                if (!rewrite.matches(list.get(0))) continue;
                if (object != null && object.index >= rewrite.index) break;
                object = rewrite;
                break;
            }
            return object;
        }
    }

    private static class Rewrite {
        private static final Comparator<Rewrite> COMPARATOR = new Comparator<Rewrite>(){

            @Override
            public int compare(Rewrite rewrite, Rewrite rewrite2) {
                if (rewrite.index < rewrite2.index) {
                    return -1;
                }
                if (rewrite.index == rewrite2.index) {
                    return 0;
                }
                return 1;
            }
        };
        private int index;
        private final String original;
        private final Pattern pattern;
        private String virtual;
        private final String simple;
        private static final Pattern verifyStars = Pattern.compile(".*(?:\\*\\*[^/].*|\\*\\*$|[^/]\\*\\*.*)");

        public Rewrite(String string, String string2, int n) {
            this.original = '-' + string;
            if (!string.startsWith("/")) {
                string = '/' + string;
            }
            if (string.indexOf("//") != -1) {
                throw ProjectLayout.error("Illegal '//' in exclude path", string2, n);
            }
            if (verifyStars.matcher(string).matches()) {
                throw ProjectLayout.error("Illegal use of '**' in exclude path", string2, n);
            }
            if (string.endsWith("/")) {
                string = string.substring(0, string.length() - 1);
            }
            this.pattern = Rewrite.compilePrefix(string);
            if ((string = string.replace("//", "/")).length() > 1 && string.endsWith("/")) {
                string = string.substring(0, string.length() - 1);
            }
            this.simple = string.contains("*") ? null : string;
        }

        public void setIndex(int n) {
            this.index = n;
        }

        public Rewrite(String string, String string2, String string3, int n) {
            int n2;
            this.original = string;
            if (!string.startsWith("/")) {
                string = '/' + string;
            }
            if ((n2 = string.indexOf("//")) != string.lastIndexOf("//")) {
                throw ProjectLayout.error("More than one '//' in include path", string3, n);
            }
            if (verifyStars.matcher(string).matches()) {
                throw ProjectLayout.error("Illegal use of '**' in include path", string3, n);
            }
            if (!string2.startsWith("/")) {
                string2 = "/" + string2;
            }
            if (string2.endsWith("/")) {
                string2 = string2.substring(0, string2.length() - 1);
            }
            this.virtual = string2;
            this.pattern = Rewrite.compilePrefix(string);
            if ((string = string.replace("//", "/")).length() > 1 && string.endsWith("/")) {
                string = string.substring(0, string.length() - 1);
            }
            this.simple = string.contains("*") ? null : string;
        }

        private static Pattern compilePrefix(String string) {
            if ((string = (string = StringUtil.escapeStringLiteralForRegexp(string, "*")).contains("//") ? string.replace("//", "(/") : "(" + string).endsWith("/")) {
                string = string.substring(0, string.length() - 1);
            }
            string = string.replace("/**", "-///-").replace("*", "[^/]*").replace("-///-", "(?:|/.*)");
            return Pattern.compile(string + "(?:/.*|$))");
        }

        public boolean isSimple() {
            return this.simple != null;
        }

        public String simplePrefix() {
            return this.simple;
        }

        public boolean matches(String string) {
            return this.pattern.matcher(string).matches();
        }

        public String rewrite(String string) {
            if (this.virtual == null) {
                return null;
            }
            Matcher matcher = this.pattern.matcher(string);
            if (!matcher.matches()) {
                return null;
            }
            return this.virtual + matcher.group(1);
        }

        public String toString() {
            return this.original;
        }
    }
}

