/*
 * Decompiled with CFR 0.152.
 */
package com.semmle.cli;

import com.semmle.cli.HtmlExtractorOptions;
import com.semmle.cli.SimpleExtractor;
import com.semmle.cli.SimpleExtractorOptions;
import com.semmle.extractor.html.HtmlPopulator;
import com.semmle.util.trap.TrapWriter;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import org.slf4j.MarkerFactory;

public class HtmlExtractor
extends SimpleExtractor {
    HtmlPopulator.Config config = HtmlPopulator.Config.ALL;

    public static void main(String[] args) {
        HtmlExtractor.create(args).run();
    }

    public static HtmlExtractor create(String[] args) {
        HtmlExtractorOptions htmlOptions = HtmlExtractor.getExtractorOptions(args, HtmlExtractorOptions.class);
        LinkedHashSet<String> extensions = new LinkedHashSet<String>();
        Collections.addAll(extensions, "htm", "html", "xhtm", "xhtml", "vue");
        HtmlExtractor ret = new HtmlExtractor(htmlOptions, extensions);
        if (htmlOptions.isExtractMode()) {
            try {
                ret.config = HtmlPopulator.Config.fromString(htmlOptions.getExtractMode());
            }
            catch (IllegalArgumentException e) {
                System.err.printf("Invalid --extractMode: %s.\n", e.getMessage());
                System.exit(1);
            }
        }
        return ret;
    }

    public HtmlExtractor(SimpleExtractorOptions opts, Set<String> defaultExtensions) {
        super(opts, defaultExtensions, MarkerFactory.getMarker("HTMLExtractor"));
    }

    @Override
    protected void extractFile(File f, TrapWriter writer) {
        try {
            new HtmlPopulator(this.config, f, writer).doit(Optional.empty());
        }
        catch (IOException e) {
            System.err.printf("Error reading file: %s", e.toString());
            System.exit(1);
        }
    }
}

