/*
 * Decompiled with CFR 0.152.
 */
package com.semmle.extractor.html;

import com.semmle.extractor.xml.XmlTrapWriter;
import com.semmle.util.data.StringUtil;
import com.semmle.util.locations.Position;
import com.semmle.util.locations.SourceMap;
import com.semmle.util.trap.TrapWriter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Stack;
import net.htmlparser.jericho.Attribute;
import net.htmlparser.jericho.Attributes;
import net.htmlparser.jericho.CharacterReference;
import net.htmlparser.jericho.Element;
import net.htmlparser.jericho.Segment;
import net.htmlparser.jericho.Source;
import net.htmlparser.jericho.StartTagType;

public class HtmlPopulator {
    private final XmlTrapWriter populator;
    private final TrapWriter trapWriter;
    private final TrapWriter.Label fileId;
    private final Source src;
    private final Config cfg;
    private SourceMap sourceMap;
    private final Map<Segment, TrapWriter.Label> lazyLabelMap = new LinkedHashMap<Segment, TrapWriter.Label>();

    public HtmlPopulator(Config cfg, File f, TrapWriter trapWriter) throws IOException {
        this.cfg = cfg;
        this.trapWriter = trapWriter;
        this.populator = new XmlTrapWriter(trapWriter);
        this.fileId = this.populator.insertXMLFile(f);
        this.src = new Source(f);
        this.src.setLogger(null);
    }

    public HtmlPopulator(Config cfg, String source, TrapWriter trapWriter, TrapWriter.Label fileId) {
        this.cfg = cfg;
        this.trapWriter = trapWriter;
        this.populator = new XmlTrapWriter(trapWriter);
        this.src = new Source(source);
        this.src.setLogger(null);
        this.fileId = fileId;
    }

    public void setSourceMap(SourceMap sourceMap) {
        this.sourceMap = sourceMap;
    }

    public final List<TrapWriter.Label> doit(ElementHandler additionalElementHandler) {
        return this.doit(Optional.ofNullable(additionalElementHandler));
    }

    public final List<TrapWriter.Label> doit(Optional<ElementHandler> additionalElementHandler) {
        if (additionalElementHandler.isPresent()) {
            ContextImpl context = new ContextImpl();
            for (Element elt : this.src.getAllElements()) {
                additionalElementHandler.get().handleElement(elt, context);
            }
        }
        Stack<ElementAndParent> toExtract = new Stack<ElementAndParent>();
        int childIndex = 0;
        int contentStart = this.src.getBegin();
        int contentEnd = this.src.getEnd();
        int prevChildEnd = contentStart;
        for (Element child : this.src.getChildElements()) {
            childIndex += this.emitXmlChars(this.src, prevChildEnd, child.getBegin(), this.fileId, childIndex, false, additionalElementHandler);
            prevChildEnd = child.getEnd();
            toExtract.push(new ElementAndParent(this.fileId, child, childIndex));
            if (!HtmlPopulator.isCDataElement(child) && !HtmlPopulator.isPlainElement(child)) continue;
            ++childIndex;
        }
        this.emitXmlChars(this.src, prevChildEnd, contentEnd, this.fileId, childIndex, false, additionalElementHandler);
        ArrayList<TrapWriter.Label> rootNodeLabels = new ArrayList<TrapWriter.Label>();
        while (!toExtract.empty()) {
            ElementAndParent node = (ElementAndParent)toExtract.pop();
            Element elt = node.element;
            Optional<TrapWriter.Label> maybeEltLabel = this.extractElement(elt, node.parent, node.index, additionalElementHandler);
            if (!HtmlPopulator.isPlainElement(elt)) continue;
            TrapWriter.Label eltLabel = maybeEltLabel.get();
            if (node.parent == this.fileId) {
                rootNodeLabels.add(eltLabel);
            }
            int childIndex2 = 0;
            Source source = elt.getSource();
            int contentStart2 = elt.getStartTag().getEnd();
            int contentEnd2 = elt.getEndTag() != null ? elt.getEndTag().getBegin() : elt.getEnd();
            int prevChildEnd2 = contentStart2;
            for (Element child : elt.getChildElements()) {
                childIndex2 += this.emitXmlChars(source, prevChildEnd2, child.getBegin(), eltLabel, childIndex2, false, additionalElementHandler);
                prevChildEnd2 = child.getEnd();
                toExtract.push(new ElementAndParent(eltLabel, child, childIndex2));
                if (!HtmlPopulator.isCDataElement(child) && !HtmlPopulator.isPlainElement(child)) continue;
                ++childIndex2;
            }
            this.emitXmlChars(source, prevChildEnd2, contentEnd2, eltLabel, childIndex2, false, additionalElementHandler);
        }
        Collections.reverse(rootNodeLabels);
        return rootNodeLabels;
    }

    private static boolean isPlainElement(Element elt) {
        return elt.getStartTag().getTagType() == StartTagType.NORMAL;
    }

    private static boolean isCDataElement(Element elt) {
        return elt.getStartTag().getTagType() == StartTagType.CDATA_SECTION;
    }

    private static boolean isComment(Element elt) {
        return elt.getStartTag().getTagType() == StartTagType.COMMENT;
    }

    private TrapWriter.Label getLabel(Segment segment) {
        TrapWriter.Label result = this.lazyLabelMap.get(segment);
        return result != null ? result : this.trapWriter.freshLabel();
    }

    private Optional<TrapWriter.Label> extractElement(Element elt, TrapWriter.Label parentLabel, int index, Optional<ElementHandler> handler) {
        Source source = elt.getSource();
        if (HtmlPopulator.isCDataElement(elt)) {
            this.emitXmlChars(source, elt.getBegin() + "<![CDATA[".length(), elt.getEnd() - "]]>".length(), parentLabel, index, true, handler);
        }
        if (HtmlPopulator.isPlainElement(elt)) {
            String childName = elt.getName();
            TrapWriter.Label childLabel = this.getLabel(elt);
            this.populator.insertElement(childName, parentLabel, index, this.fileId, childLabel);
            this.emitLocation(elt, childLabel);
            this.extractAttributes(elt, childLabel, handler);
            return Optional.of(childLabel);
        }
        if (this.cfg.extractComments() && HtmlPopulator.isComment(elt)) {
            TrapWriter.Label childLabel = this.populator.insertComment(elt.toString(), parentLabel, this.fileId);
            this.emitLocation(elt, childLabel);
            return Optional.of(childLabel);
        }
        return Optional.empty();
    }

    private void extractAttributes(Element elt, TrapWriter.Label eltLabel, Optional<ElementHandler> handler) {
        Attributes attributes = elt.getAttributes();
        if (attributes == null) {
            return;
        }
        if (handler.isPresent() && !handler.get().shouldExtractAttributes(elt)) {
            return;
        }
        int i = 0;
        for (Attribute attr : attributes) {
            String attrName = attr.getName();
            String attrValue = attr.getValue() == null ? "" : attr.getValue();
            TrapWriter.Label attrLabel = this.getLabel(attr);
            this.populator.insertAttribute(eltLabel, attrName, attrValue, i++, this.fileId, attrLabel);
            this.emitLocation(attr, attrLabel);
        }
    }

    private void insertLocation(TrapWriter.Label xmlNodeId, TrapWriter.Label fileId, int startOffset, int endOffsetIncl) {
        if (this.sourceMap != null) {
            Position start = this.sourceMap.getStart(startOffset);
            Position end = this.sourceMap.getEnd(endOffsetIncl);
            this.populator.insertLocation(xmlNodeId, fileId, start.getLine(), start.getColumn(), end.getLine(), end.getColumn() - 1);
        } else {
            this.populator.insertLocation(xmlNodeId, fileId, this.src.getRow(startOffset), this.src.getColumn(startOffset), this.src.getRow(endOffsetIncl), this.src.getColumn(endOffsetIncl));
        }
    }

    private void emitLocation(Segment s, TrapWriter.Label label) {
        this.insertLocation(label, this.fileId, s.getBegin(), s.getEnd() - 1);
    }

    private int emitXmlChars(Source src, int textBegin, int textEnd, TrapWriter.Label parentLabel, int id, boolean isCData, Optional<ElementHandler> handler) {
        if (handler.isPresent()) {
            handler.get().handleText(src, textBegin, textEnd, parentLabel, isCData);
        }
        if (!this.cfg.extractText()) {
            return 0;
        }
        if (textBegin > textEnd || textBegin == textEnd && !isCData) {
            return 0;
        }
        Segment s = new Segment(src, textBegin, textEnd);
        String rawText = s.toString();
        if (!isCData) {
            rawText = CharacterReference.decode(rawText, false);
        }
        TrapWriter.Label label = this.populator.insertCharacters(rawText, parentLabel, id, isCData, this.fileId);
        this.emitLocation(s, label);
        return 1;
    }

    public Source getSourceNode() {
        return this.src;
    }

    public static enum Config {
        NONE(false, false),
        ELEMENTS(true, false),
        ALL(true, true);

        private final boolean extractElements;
        private final boolean extractText;

        private Config(boolean extractElements, boolean extractText) {
            this.extractElements = extractElements;
            this.extractText = extractText;
        }

        public boolean extractElements() {
            return this.extractElements;
        }

        public boolean extractText() {
            return this.extractText;
        }

        public boolean extractComments() {
            return this.extractElements;
        }

        public String toString() {
            return StringUtil.lc(this.name());
        }

        public static Config fromString(String str) {
            String upper = str.toUpperCase();
            if (upper.equals("ALL")) {
                return ALL;
            }
            if (upper.equals("ELEMENTS")) {
                return ELEMENTS;
            }
            if (upper.equals("NONE")) {
                return NONE;
            }
            throw new IllegalArgumentException("value must be ALL, ELEMENTS, or NONE");
        }
    }

    private class ContextImpl
    implements Context {
        private ContextImpl() {
        }

        @Override
        public TrapWriter.Label getNodeLabel(Segment node) {
            return HtmlPopulator.this.lazyLabelMap.computeIfAbsent(node, _segment -> HtmlPopulator.this.trapWriter.freshLabel());
        }
    }

    public static interface ElementHandler {
        default public void handleElement(Element e, Context context) {
            this.handleElement(e);
        }

        default public void handleElement(Element e) {
        }

        default public boolean shouldExtractAttributes(Element element) {
            return true;
        }

        default public void handleText(Source src, int textBegin, int textEnd, TrapWriter.Label parentLabel, boolean isCData) {
        }
    }

    public static interface Context {
        public TrapWriter.Label getNodeLabel(Segment var1);
    }

    private static class ElementAndParent {
        public TrapWriter.Label parent;
        public Element element;
        public int index;

        public ElementAndParent(TrapWriter.Label parent, Element element, int index) {
            this.parent = parent;
            this.element = element;
            this.index = index;
        }
    }
}

