/*
 * Decompiled with CFR 0.152.
 */
package com.semmle.extractor.xml;

import com.semmle.util.trap.TrapWriter;
import java.io.File;
import javax.xml.stream.Location;

public class XmlTrapWriter {
    private final TrapWriter writer;

    public XmlTrapWriter(TrapWriter writer) {
        this.writer = writer;
    }

    void addNamespace(TrapWriter.Label nameSpaceId, String nameSpacePrefix, String nameSpaceURI, TrapWriter.Label fileId) {
        this.writer.addTuple("xmlNs", nameSpaceId, nameSpacePrefix, nameSpaceURI, fileId);
    }

    public TrapWriter.Label getNamespaceID(String nameSpaceURI) {
        return this.writer.globalID(TrapWriter.escapeKey(nameSpaceURI) + ";xmlnamespace");
    }

    public TrapWriter.Label insertAttribute(TrapWriter.Label elementId, String qName, String value, int i, TrapWriter.Label fileId) {
        return this.insertAttribute(elementId, qName, value, i, fileId, this.freshLabel());
    }

    public TrapWriter.Label insertAttribute(TrapWriter.Label elementId, String qName, String value, int i, TrapWriter.Label fileId, TrapWriter.Label newAttributeId) {
        this.writer.addTuple("xmlAttrs", newAttributeId, elementId, qName, value, i, fileId);
        return newAttributeId;
    }

    private TrapWriter.Label freshLabel() {
        return this.writer.freshLabel();
    }

    public TrapWriter.Label insertCharacters(String characters, TrapWriter.Label elementId, int i, boolean isCDATA, TrapWriter.Label fileId) {
        TrapWriter.Label result = this.freshLabel();
        this.writer.addTuple("xmlChars", result, characters, elementId, i, isCDATA ? 1 : 0, fileId);
        return result;
    }

    public TrapWriter.Label insertComment(String text, TrapWriter.Label elementId, TrapWriter.Label fileId) {
        TrapWriter.Label result = this.freshLabel();
        this.writer.addTuple("xmlComments", result, text, elementId, fileId);
        return result;
    }

    public TrapWriter.Label insertDTD(String dtdRoot, String dtdPublicId, String dtdSystemId, TrapWriter.Label fileId) {
        TrapWriter.Label result = this.freshLabel();
        this.writer.addTuple("xmlDTDs", result, dtdRoot, dtdPublicId, dtdSystemId, fileId);
        return result;
    }

    public TrapWriter.Label insertElement(String name, TrapWriter.Label parentId, int elementIndex, TrapWriter.Label fileId) {
        return this.insertElement(name, parentId, elementIndex, fileId, this.freshLabel());
    }

    public TrapWriter.Label insertElement(String name, TrapWriter.Label parentId, int elementIndex, TrapWriter.Label fileId, TrapWriter.Label newElementId) {
        this.writer.addTuple("xmlElements", newElementId, name, parentId, elementIndex, fileId);
        return newElementId;
    }

    public void insertHasNamespace(TrapWriter.Label elementId, TrapWriter.Label namespaceId, TrapWriter.Label fileId) {
        this.writer.addTuple("xmlHasNs", elementId, namespaceId, fileId);
    }

    public void insertLocation(TrapWriter.Label xmlNodeId, TrapWriter.Label fileId, Location start, Location end) {
        this.insertLocation(xmlNodeId, fileId, start.getLineNumber(), start.getColumnNumber(), end.getLineNumber(), end.getColumnNumber());
    }

    public void insertLocation(TrapWriter.Label xmlNodeId, TrapWriter.Label fileId, int sl, int sc, int el, int ec) {
        TrapWriter.Label location = this.writer.location(fileId, sl, sc, el, ec);
        this.writer.addTuple("locations_default", location, fileId, sl, sc, el, ec);
        this.writer.addTuple("xmllocations", xmlNodeId, location);
    }

    public void insertXMLEncoding(TrapWriter.Label fileLabel, String encoding) {
        this.writer.addTuple("xmlEncoding", fileLabel, encoding);
    }

    public void insertNumlines(TrapWriter.Label xmlNodeId, int numLines, int numCode, int numComment) {
        this.writer.addTuple("numlines", xmlNodeId, numLines, numCode, numComment);
    }

    public TrapWriter.Label insertXMLFile(File file) {
        TrapWriter.Label fileId = this.writer.populateFile(file.getAbsoluteFile());
        TrapWriter.Label fileLocation = this.writer.globalID("loc,{" + fileId + "}," + 0 + "," + 0);
        this.writer.addTuple("locations_default", fileLocation, fileId, 0, 0, 0, 0);
        this.writer.addTuple("xmllocations", fileId, fileLocation);
        return fileId;
    }
}

