/*
 * Decompiled with CFR 0.152.
 */
package com.semmle.util.data;

import com.semmle.util.exception.CatastrophicError;

public class ByteUtil {
    public static byte[] toByteArray(int ... byteValues) {
        return ByteUtil.toByteArray(new byte[byteValues.length], byteValues);
    }

    public static byte[] toByteArray(byte[] bytes, int ... byteValues) {
        if (bytes.length < byteValues.length) {
            throw new CatastrophicError("bytes.length == " + bytes.length + ", but byteValues.length==" + byteValues.length);
        }
        for (int i = 0; i < byteValues.length; ++i) {
            bytes[i] = (byte)byteValues[i];
        }
        return bytes;
    }

    public static long bytesToLong(byte[] bytes, int offset) {
        return ((long)bytes[offset] & 0xFFL) << 56 | ((long)bytes[++offset] & 0xFFL) << 48 | ((long)bytes[++offset] & 0xFFL) << 40 | ((long)bytes[++offset] & 0xFFL) << 32 | ((long)bytes[++offset] & 0xFFL) << 24 | ((long)bytes[++offset] & 0xFFL) << 16 | ((long)bytes[++offset] & 0xFFL) << 8 | (long)bytes[++offset] & 0xFFL;
    }

    public static short bytesToShort(byte[] bytes, int offset) {
        return (short)((bytes[offset] & 0xFF) << 8 | bytes[++offset] & 0xFF);
    }

    public static byte[] longToBytes(long value, byte[] bytes, int offset) {
        bytes = bytes == null ? new byte[8] : bytes;
        bytes[offset] = (byte)(value >> 56);
        bytes[++offset] = (byte)(value >> 48);
        bytes[++offset] = (byte)(value >> 40);
        bytes[++offset] = (byte)(value >> 32);
        bytes[++offset] = (byte)(value >> 24);
        bytes[++offset] = (byte)(value >> 16);
        bytes[++offset] = (byte)(value >> 8);
        bytes[++offset] = (byte)value;
        return bytes;
    }

    public static byte[] intToBytes(int value, byte[] bytes, int offset) {
        bytes = bytes == null ? new byte[4] : bytes;
        bytes[offset] = (byte)(value >> 24);
        bytes[++offset] = (byte)(value >> 16);
        bytes[++offset] = (byte)(value >> 8);
        bytes[++offset] = (byte)value;
        return bytes;
    }

    public static byte[] shortToBytes(short value, byte[] bytes, int offset) {
        bytes = bytes == null ? new byte[2] : bytes;
        bytes[offset] = (byte)(value >> 8);
        bytes[++offset] = (byte)value;
        return bytes;
    }

    public static class ByteQuantities {
        public static final int B = 1;
        public static final int KiB = 1024;
        public static final int MiB = 0x100000;
        public static final int GiB = 0x40000000;
        public static final long TiB = 0x10000000000L;
        public static final long PiB = 0x4000000000000L;
        public static final long EiB = 0x1000000000000000L;
        public static final int KB = 1000;
        public static final int MB = 1000000;
        public static final int GB = 1000000000;
        public static final long TB = 1000000000000L;
        public static final long PB = 1000000000000000L;
        public static final long EB = 1000000000000000000L;
    }
}

