/*
 * Decompiled with CFR 0.152.
 */
package com.semmle.util.data;

import com.semmle.util.data.StringUtil;
import com.semmle.util.exception.CatastrophicError;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Locale;
import java.util.regex.Pattern;

public class Date
implements Serializable,
Comparable<Date> {
    private static final int MAX_YEAR = 0xFFFFFF;
    private static final int MIN_YEAR = -16777216;
    public static final Date MIN_VALUE = new Date(1, 1, -16777216);
    public static final Date MAX_VALUE = new Date(31, 11, 0xFFFFFF, 23, 59, 59);
    public static final int JAN = 0;
    public static final int FEB = 1;
    public static final int MAR = 2;
    public static final int APR = 3;
    public static final int MAY = 4;
    public static final int JUN = 5;
    public static final int JUL = 6;
    public static final int AUG = 7;
    public static final int SEP = 8;
    public static final int OCT = 9;
    public static final int NOV = 10;
    public static final int DEC = 11;
    private static final long serialVersionUID = 596050658649312255L;
    private static final String[] SHORT_MONTHS = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    private static final String[] MONTHS = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
    private static final String[] DAY_OF_WEEK = new String[]{"Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday", "Sunday"};
    private static final String[] DAY_OF_WEEK_SHORT = new String[]{"Mon", "Tue", "Wed", "Thu", "Fri", "Sat", "Sun"};
    private static final int[] DAYS = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private static final int[] LEAP_DAYS = new int[]{31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private int day;
    private int month;
    private int year;
    private final int hours;
    private final int minutes;
    private final int seconds;
    private static final long MILLIS_MASK = 1023L;
    private static final long SECOND_MASK = 64512L;
    private static final long MINUTE_MASK = 0x3F0000L;
    private static final long HOUR_MASK = 0x7C00000L;
    private static final long DAY_MASK = 0xF8000000L;
    private static final long MONTH_MASK = 0xF00000000L;
    private static final long YEAR_MASK = 0x1FFFFFF000000000L;
    private static final int MILLIS_SHIFT = 0;
    private static final int SECOND_SHIFT = 10;
    private static final int MINUTE_SHIFT = 16;
    private static final int HOUR_SHIFT = 22;
    private static final int DAY_SHIFT = 27;
    private static final int MONTH_SHIFT = 32;
    private static final int YEAR_SHIFT = 36;
    private static final Pattern colonSeparator = Pattern.compile(":");

    public Date(int day, int month, int year) {
        this(day, month, year, 0, 0, 0);
    }

    private Date(Date day, int hours, int minutes, int seconds) {
        this.day = day.getDay();
        this.month = day.getMonth();
        this.year = day.getYear();
        this.hours = hours;
        this.minutes = minutes;
        this.seconds = seconds;
    }

    public Date(int day, int month, int year, int hours, int minutes, int seconds) {
        this.day = day;
        this.month = month;
        this.year = year;
        this.hours = hours;
        this.minutes = minutes;
        this.seconds = seconds;
    }

    public boolean isLeapYear() {
        return Date.isLeapYear(this.year);
    }

    private static boolean isLeapYear(int year) {
        return year % 4 == 0 && (year % 100 != 0 || year % 400 == 0);
    }

    public boolean isValid() {
        if (this.month < 0 || this.month >= 12) {
            return false;
        }
        if (this.day <= 0) {
            return false;
        }
        if (this.isLeapYear() ? this.day > LEAP_DAYS[this.month] : this.day > DAYS[this.month]) {
            return false;
        }
        return this.year >= -16777216 && this.year <= 0xFFFFFF;
    }

    public int getDay() {
        return this.day;
    }

    public int getMonth() {
        return this.month;
    }

    public String getMonthString() {
        return MONTHS[this.getMonth()];
    }

    public int getLengthOfMonth() {
        if (this.isLeapYear()) {
            return LEAP_DAYS[this.month];
        }
        return DAYS[this.month];
    }

    public int getYear() {
        return this.year;
    }

    public int getHours() {
        return this.hours;
    }

    public int getMinutes() {
        return this.minutes;
    }

    public int getSeconds() {
        return this.seconds;
    }

    private void nextDayImpl() {
        int newDay = this.day + 1;
        int newMonth = this.month;
        int newYear = this.year;
        int monthLength = this.getLengthOfMonth();
        if (newDay > monthLength) {
            newDay = 1;
            if (++newMonth >= 12) {
                newMonth = 0;
                ++newYear;
            }
        }
        this.day = newDay;
        this.month = newMonth;
        this.year = newYear;
    }

    private void previousDayImpl() {
        int newDay = this.day - 1;
        int newMonth = this.month;
        int newYear = this.year;
        if (newDay == 0) {
            if (--newMonth < 0) {
                newMonth = 11;
                --newYear;
            }
            newDay = Date.isLeapYear(newYear) ? LEAP_DAYS[newMonth] : DAYS[newMonth];
        }
        this.day = newDay;
        this.month = newMonth;
        this.year = newYear;
    }

    private int dayCount() {
        int day = this.day;
        int effectiveYear = this.month < 2 ? this.year - 1 : this.year;
        int effectiveMonth = this.month < 2 ? this.month + 13 : this.month + 1;
        return 365 * effectiveYear + effectiveYear / 4 - effectiveYear / 100 + effectiveYear / 400 + day + (153 * effectiveMonth + 8) / 5;
    }

    private Date addDaysNaive(int daysToAdd) {
        Date result = new Date(this.day, this.month, this.year, this.hours, this.minutes, this.seconds);
        while (daysToAdd > 0) {
            result.nextDayImpl();
            --daysToAdd;
        }
        while (daysToAdd < 0) {
            result.previousDayImpl();
            ++daysToAdd;
        }
        return result;
    }

    public Date addDays(int daysToAdd) {
        return this.addDaysNaive(daysToAdd);
    }

    public int daysTo(Date to) {
        return to.dayCount() - this.dayCount();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.day;
        result = 31 * result + this.month;
        result = 31 * result + this.year;
        result = 31 * result + this.hours;
        result = 31 * result + this.minutes;
        result = 31 * result + this.seconds;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Date other = (Date)obj;
        if (this.day != other.day) {
            return false;
        }
        if (this.month != other.month) {
            return false;
        }
        if (this.year != other.year) {
            return false;
        }
        if (this.hours != other.hours) {
            return false;
        }
        if (this.minutes != other.minutes) {
            return false;
        }
        return this.seconds == other.seconds;
    }

    public String toString() {
        String datePart = this.month < 0 || this.month >= 12 ? this.day + "/" + (this.month + 1) + "/" + this.year : this.day + " " + MONTHS[this.month] + " " + this.year;
        return this.addTime(datePart);
    }

    public String toIsoDate() {
        String datePart = String.format(Locale.ENGLISH, "%04d-%02d-%02d", this.year, this.month + 1, this.day);
        return this.addTime(datePart);
    }

    private String addTime(String datePart) {
        if (this.hours == 0 && this.minutes == 0 && this.seconds == 0) {
            return datePart;
        }
        return datePart + " " + Date.pad(this.hours) + ":" + Date.pad(this.minutes) + (this.seconds != 0 ? ":" + Date.pad(this.seconds) : "");
    }

    public String format(DateFormat format) {
        return format.format(this.toJavaDate());
    }

    public static Date fromImbId(long id) {
        int day = (int)((id & 0xF8000000L) >> 27);
        int month = (int)((id & 0xF00000000L) >> 32);
        int year = (int)((id & 0x1FFFFFF000000000L) << 3 >> 39);
        int hours = (int)((id & 0x7C00000L) >>> 22);
        int minutes = (int)((id & 0x3F0000L) >>> 16);
        int seconds = (int)((id & 0xFC00L) >>> 10);
        Date result = new Date(day, month, year, hours, minutes, seconds);
        if (!result.isValid()) {
            throw new CatastrophicError("Invalid date " + result + " from internal ID " + Long.toHexString(id));
        }
        return result;
    }

    public long toImbId() {
        return (long)this.seconds << 10 | (long)this.minutes << 16 | (long)this.hours << 22 | (long)this.day << 27 | (long)this.month << 32 | (long)this.year << 36;
    }

    public java.util.Date toJavaDate() {
        return new java.util.Date(this.year - 1900, this.month, this.day, this.hours, this.minutes, this.seconds);
    }

    public static Date now() {
        Calendar cal = Calendar.getInstance();
        int year = cal.get(1);
        int month = cal.get(2);
        int day = cal.get(5);
        int hours = cal.get(11);
        int minutes = cal.get(12);
        int seconds = cal.get(13);
        return new Date(day, month, year, hours, minutes, seconds);
    }

    public static Integer dayOfWeekFromString(String dayOfWeek) {
        dayOfWeek = dayOfWeek.toLowerCase(Locale.ENGLISH);
        for (int i = 0; i < 7; ++i) {
            if (!DAY_OF_WEEK[i].toLowerCase(Locale.ENGLISH).equals(dayOfWeek) && !DAY_OF_WEEK_SHORT[i].toLowerCase(Locale.ENGLISH).equals(dayOfWeek)) continue;
            return i;
        }
        return null;
    }

    public static Integer monthFromString(String monthString) {
        monthString = monthString.toLowerCase(Locale.ENGLISH);
        for (int i = 0; i < 12; ++i) {
            if (!MONTHS[i].toLowerCase(Locale.ENGLISH).equals(monthString)) continue;
            return i;
        }
        return null;
    }

    @Override
    public int compareTo(Date o) {
        int cmp = this.year - o.year;
        if (cmp != 0) {
            return cmp;
        }
        cmp = this.month - o.month;
        if (cmp != 0) {
            return cmp;
        }
        cmp = this.day - o.day;
        if (cmp != 0) {
            return cmp;
        }
        cmp = this.hours - o.hours;
        if (cmp != 0) {
            return cmp;
        }
        cmp = this.minutes - o.minutes;
        if (cmp != 0) {
            return cmp;
        }
        return this.seconds - o.seconds;
    }

    public static Date fromIso(String s) {
        int seconds;
        int minutes;
        int hours;
        String[] strings = StringUtil.words(s);
        if (strings.length == 1) {
            hours = 0;
            minutes = 0;
            seconds = 0;
        } else if (strings.length == 2 || strings.length == 3) {
            String[] parts = colonSeparator.split(strings[1]);
            try {
                if (parts.length == 3) {
                    hours = Integer.valueOf(parts[0]);
                    minutes = Integer.valueOf(parts[1]);
                    seconds = Integer.valueOf(parts[2]);
                }
                if (parts.length == 2) {
                    hours = Integer.valueOf(parts[0]);
                    minutes = Integer.valueOf(parts[1]);
                    seconds = 0;
                }
                if (parts.length == 1) {
                    String raw = parts[0];
                    if (raw.length() == 6) {
                        hours = Integer.valueOf(raw.substring(0, 2));
                        minutes = Integer.valueOf(raw.substring(2, 4));
                        seconds = Integer.valueOf(raw.substring(4, 6));
                    }
                    if (raw.length() == 4) {
                        hours = Integer.valueOf(raw.substring(0, 2));
                        minutes = Integer.valueOf(raw.substring(2, 4));
                        seconds = 0;
                    }
                    if (raw.length() == 2) {
                        hours = Integer.valueOf(raw.substring(0, 2));
                        minutes = 0;
                        seconds = 0;
                    }
                    return null;
                }
                return null;
            }
            catch (NumberFormatException e) {
                return null;
            }
        } else {
            return null;
        }
        Date date = new DateParser(strings[0]).parse();
        if (date == null) {
            return null;
        }
        return new Date(date, hours, minutes, seconds);
    }

    public static Date fromString(String dateString) {
        Date result = Date.fromIso(dateString);
        if (result == null) {
            result = new DateParser(dateString).parse();
        }
        return result;
    }

    private static String pad(int n) {
        if (n < 10) {
            return "0" + n;
        }
        return Integer.toString(n);
    }

    private static class DateParser {
        private final String s;
        private int pos;
        private String lastToken;

        DateParser(String s) {
            this.s = s;
            this.pos = 0;
        }

        Date parse() {
            try {
                Date d = this.date();
                if (!d.isValid()) {
                    return null;
                }
                return d;
            }
            catch (NumberFormatException e) {
                return null;
            }
        }

        private Date date() {
            Date date;
            this.skip();
            int firstSign = this.readSign();
            int firstInt = this.readInt() * firstSign;
            this.skip();
            if (this.lastToken.length() == 8 && !this.lookahead('-')) {
                date = DateParser.parseIsoDate(this.lastToken, firstSign);
            } else if (this.lastToken.length() >= 4) {
                int year = firstInt;
                this.read('-');
                this.skip();
                int month = this.readInt() - 1;
                this.skip();
                this.read('-');
                this.skip();
                int day = this.readInt();
                date = new Date(day, month, year);
            } else {
                int month;
                int day = firstInt;
                if (this.lookahead('/')) {
                    this.read('/');
                    this.skip();
                    month = this.readInt() - 1;
                    this.skip();
                    this.read('/');
                } else {
                    month = this.readMonth();
                    this.skip();
                    if (this.lookahead(',')) {
                        this.read(',');
                    }
                }
                this.skip();
                int yearSign = this.readSign();
                int year = this.readInt() * yearSign;
                date = new Date(day, month, year);
            }
            date = this.readTimeOpt(date);
            this.checkAtEnd();
            return date;
        }

        private Date readTimeOpt(Date date) {
            this.skip();
            if (this.pos == this.s.length()) {
                return date;
            }
            int hours = this.readInt();
            this.skip();
            this.read(':');
            this.skip();
            int minutes = this.readInt();
            this.skip();
            int seconds = 0;
            if (this.pos != this.s.length()) {
                this.read(':');
                this.skip();
                seconds = this.readInt();
            }
            this.skip();
            return new Date(date, hours, minutes, seconds);
        }

        private static Date parseIsoDate(String date, int yearSign) {
            int year = Integer.valueOf(date.substring(0, 4)) * yearSign;
            int month = Integer.valueOf(date.substring(4, 6)) - 1;
            int day = Integer.valueOf(date.substring(6, 8));
            return new Date(day, month, year);
        }

        private int readMonth() {
            String month = this.readId().toUpperCase();
            for (int i = 0; i < 12; ++i) {
                if (MONTHS[i].toUpperCase().equals(month)) {
                    return i;
                }
                if (!SHORT_MONTHS[i].toUpperCase().equals(month)) continue;
                return i;
            }
            throw new NumberFormatException();
        }

        private char ch() {
            return this.s.charAt(this.pos);
        }

        private int readSign() {
            if (this.lookahead('-')) {
                ++this.pos;
                return -1;
            }
            return 1;
        }

        private int readInt() {
            int start = this.pos;
            while (this.pos < this.s.length() && Character.isDigit(this.ch())) {
                ++this.pos;
            }
            int end = this.pos;
            if (start == end) {
                throw new NumberFormatException();
            }
            this.lastToken = this.s.substring(start, end);
            return Integer.valueOf(this.lastToken);
        }

        private String readId() {
            int start = this.pos;
            while (this.pos < this.s.length() && Character.isJavaIdentifierStart(this.ch())) {
                ++this.pos;
            }
            int end = this.pos;
            this.lastToken = this.s.substring(start, end);
            return this.lastToken;
        }

        private void skip() {
            while (this.pos < this.s.length() && Character.isWhitespace(this.ch())) {
                ++this.pos;
            }
        }

        private void checkAtEnd() {
            if (this.pos < this.s.length()) {
                throw new NumberFormatException();
            }
        }

        private void read(char c) {
            if (this.pos >= this.s.length() || this.ch() != c) {
                throw new NumberFormatException();
            }
            this.lastToken = this.s.substring(this.pos, this.pos + 1);
            ++this.pos;
        }

        private boolean lookahead(char c) {
            return this.pos < this.s.length() && this.ch() == c;
        }
    }
}

