/*
 * Decompiled with CFR 0.152.
 */
package com.semmle.util.data;

import com.semmle.util.data.HashUtil;
import com.semmle.util.exception.CatastrophicError;
import java.util.Arrays;

public class IntHashSet {
    private int[] data;
    private boolean containsZero = false;
    private int size = 0;

    public IntHashSet() {
        this(1024);
    }

    public IntHashSet(int capacity) {
        if ((capacity & capacity - 1) != 0) {
            throw new CatastrophicError("HashSet initial capacity must be power of 2");
        }
        if (capacity < 8) {
            capacity = 8;
        }
        this.data = new int[capacity];
    }

    public void clear() {
        Arrays.fill(this.data, 0);
        this.containsZero = false;
        this.size = 0;
    }

    private int find(int value) {
        int mask = this.data.length - 1;
        int iter = 0;
        int i = HashUtil.hashFinal(value) & mask;
        while (this.data[i] != value && this.data[i] != 0) {
            i = i + ++iter & mask;
        }
        return i;
    }

    public boolean insert(int value) {
        int i;
        if (value == 0) {
            boolean didContainZero = this.containsZero;
            this.containsZero = true;
            if (!didContainZero) {
                ++this.size;
                return true;
            }
            return false;
        }
        if (this.size * 4 > this.data.length * 3) {
            this.reHash();
        }
        if (this.data[i = this.find(value)] == value) {
            return false;
        }
        this.data[i] = value;
        ++this.size;
        return true;
    }

    public void insertAll(IntHashSet other) {
        if (other.containsZero) {
            this.insert(0);
        }
        for (int e : other.data) {
            if (e == 0) continue;
            this.insert(e);
        }
    }

    public void forEach(IntConsumer c) {
        if (this.containsZero) {
            c.accept(0);
        }
        for (int e : this.data) {
            if (e == 0) continue;
            c.accept(e);
        }
    }

    public boolean contains(int value) {
        if (value == 0) {
            return this.containsZero;
        }
        return this.data[this.find(value)] == value;
    }

    public int[] toArray() {
        int[] res = new int[this.size];
        int pos = 0;
        if (this.containsZero) {
            ++pos;
        }
        for (int e : this.data) {
            if (e == 0) continue;
            res[pos++] = e;
        }
        return res;
    }

    public long getMemoryUsage() {
        return (long)this.data.length * 4L + 8L;
    }

    public int size() {
        return this.size;
    }

    private void reHash() {
        this.size = this.containsZero ? 1 : 0;
        int[] oldData = this.data;
        this.data = new int[this.data.length * 2];
        for (int i = 0; i < oldData.length; ++i) {
            if (oldData[i] == 0) continue;
            this.insert(oldData[i]);
        }
    }

    public static interface IntConsumer {
        public void accept(int var1);
    }
}

