/*
 * Decompiled with CFR 0.152.
 */
package com.semmle.util.data;

import com.semmle.util.data.IntHashSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class IntList
implements Iterable<Integer>,
Comparable<IntList> {
    protected int[] data;
    private int size;

    public static IntList create() {
        return IntList.create(10);
    }

    public static IntList create(int capacity) {
        return IntList.create(capacity, 0);
    }

    public static IntList create(int capacity, int initialSize) {
        return new IntList(capacity, initialSize);
    }

    protected IntList(int capacity, int initialSize) {
        if (capacity < 0) {
            throw new IllegalArgumentException("Invalid capacity for IntList: " + capacity);
        }
        if (initialSize < 0 || initialSize > capacity) {
            throw new IllegalArgumentException("Invalid initial size for IntList: " + initialSize + " > " + capacity);
        }
        this.data = new int[capacity];
        this.size = initialSize;
    }

    public static IntList create(Collection<? extends Integer> values) {
        IntList created = IntList.create(values.size(), values.size());
        int pos = 0;
        for (Integer n : values) {
            if (n == null) {
                throw new NullPointerException("Null element in a collection passed to IntList at position " + pos);
            }
            created.set(pos, n);
            ++pos;
        }
        return created;
    }

    protected IntList(int[] values) {
        this.data = values;
        this.size = values.length;
    }

    public static IntList wrapArray(int[] values) {
        return new IntList(values);
    }

    public IntList(IntList list) {
        this.data = Arrays.copyOf(list.data, list.data.length);
        this.size = list.size;
    }

    public IntList sortedCopy() {
        IntList copy = new IntList(this);
        copy.sort();
        return copy;
    }

    public int get(int pos) {
        if (pos < 0 || pos >= this.size) {
            throw new IllegalArgumentException("Invalid position " + pos + " into an IntList of size " + this.size);
        }
        return this.data[pos];
    }

    public void set(int pos, int val) {
        if (pos < 0 || pos >= this.size) {
            throw new IllegalArgumentException("Invalid position " + pos + " into an IntList of size " + this.size);
        }
        this.data[pos] = val;
    }

    protected int capacity() {
        return this.data.length;
    }

    public void add(int value) {
        if (this.size >= this.capacity()) {
            this.expand();
        }
        this.set(this.size++, value);
    }

    public void addAll(IntList other) {
        this.addAll(other.data, 0, other.size);
    }

    public void addAll(int[] vals, int pos, int len) {
        if (this.size + len >= this.capacity()) {
            this.expand(Math.max(2 * this.capacity(), this.size + len));
        }
        System.arraycopy(vals, pos, this.data, this.size, len);
        this.size += len;
    }

    public int remove() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        int value = this.get(this.size - 1);
        --this.size;
        return value;
    }

    public void removeMany(int toRemove) {
        if (this.size < toRemove) {
            throw new NoSuchElementException();
        }
        this.size -= toRemove;
    }

    public void filter(IntHashSet vals) {
        int p = 0;
        for (int i = 0; i < this.size; ++i) {
            int x = this.get(i);
            if (!vals.contains(x) || p++ >= i) continue;
            this.set(p - 1, x);
        }
        this.size = p;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean contains(int value) {
        for (int i = 0; i < this.size; ++i) {
            if (this.get(i) != value) continue;
            return true;
        }
        return false;
    }

    public void reverse() {
        this.reverse(0, this.size);
    }

    public void reverse(int l, int r) {
        if (0 > l || l > r || r > this.size) {
            throw new IllegalArgumentException("Invalid range (" + l + "," + r + ") in an IntList of size " + this.size);
        }
        --r;
        while (l < r) {
            int tmp = this.data[l];
            this.data[l] = this.data[r];
            this.data[r] = tmp;
            ++l;
            --r;
        }
    }

    public void sort() {
        this.sortSublist(0, this.size);
    }

    public void sortSublist(int l, int r) {
        if (r > this.size) {
            throw new IllegalArgumentException("Invalid range (" + l + "," + r + ") in an IntList of size " + this.size);
        }
        Arrays.sort(this.data, l, r);
    }

    public int binarySearch(int value) {
        return Arrays.binarySearch(this.data, 0, this.size, value);
    }

    private void expand() {
        if (this.capacity() == 0) {
            this.expand(10);
        } else {
            this.expand(2 * this.capacity());
        }
    }

    protected void expand(int newSize) {
        this.data = this.capacity() == 0 ? new int[newSize] : Arrays.copyOf(this.data, newSize);
    }

    public void compact() {
        if (this.size < this.capacity()) {
            this.expand(this.size);
        }
    }

    public void clear() {
        this.size = 0;
    }

    public int[] toArray() {
        return Arrays.copyOf(this.data, this.size);
    }

    public int hashCode() {
        int result = this.size;
        for (int i = 0; i < this.size; ++i) {
            result *= 31;
            result += this.get(i);
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IntList other = (IntList)obj;
        return this.compareTo(other) == 0;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(3 * this.size);
        sb.append("[");
        for (int i = 0; i < this.size; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(this.get(i));
        }
        sb.append("]");
        return sb.toString();
    }

    public long getMemoryUsage() {
        return (long)this.data.length * 4L + 16L;
    }

    @Override
    public int compareTo(IntList o) {
        if (this.size < o.size) {
            return -1;
        }
        if (this.size > o.size) {
            return 1;
        }
        for (int i = 0; i < this.size; ++i) {
            int other;
            int val = this.get(i);
            if (val < (other = o.get(i))) {
                return -1;
            }
            if (val <= other) continue;
            return 1;
        }
        return 0;
    }

    @Override
    public Iterator<Integer> iterator() {
        return new Iterator<Integer>(){
            private int pos = 0;

            @Override
            public boolean hasNext() {
                return this.pos < IntList.this.size;
            }

            @Override
            public Integer next() {
                if (this.pos >= IntList.this.size) {
                    throw new NoSuchElementException("IntList iterator next() called, but reached the end of the " + IntList.this.size + " elements");
                }
                int value = IntList.this.get(this.pos++);
                return value;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("IntList.iterator() does not support remove()");
            }
        };
    }

    public int intersects(IntList otherList) {
        int i = 0;
        int j = 0;
        int listASize = this.size();
        int listBSize = otherList.size();
        while (i < listASize && j < listBSize) {
            int bVal;
            int aVal = this.get(i);
            if (aVal == (bVal = otherList.get(j))) {
                return aVal;
            }
            if (aVal < bVal) {
                ++i;
                continue;
            }
            ++j;
        }
        return 0;
    }
}

