/*
 * Decompiled with CFR 0.152.
 */
package com.semmle.util.data;

import com.semmle.util.exception.CatastrophicError;
import com.semmle.util.exception.Exceptions;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.regex.Pattern;

public class StringUtil {
    private static final Random RANDOM = new Random();
    private static final DecimalFormat DOUBLE_FORMATTER = new DecimalFormat("#.######", new DecimalFormatSymbols(Locale.ROOT));
    private static final List<Character> specialMarkdownChars;
    private static final Charset UTF8_CHARSET;
    private static final Pattern lineEnding;
    private static final Pattern lineEndingIncludingSeparators;
    private static final Pattern whitespace;
    private static final char[] HEX_CHARS;
    private static final Pattern DIGITS_PATTERN;
    private static final Pattern EMAIL_PATTERN;
    public static final Pattern NEWLINE_PATTERN;

    public static String box(List<String> strings) {
        ArrayList<String> lines = new ArrayList<String>();
        for (String string : strings) {
            for (String line : StringUtil.lines(string)) {
                lines.add(line);
            }
        }
        int length = 0;
        for (String s : lines) {
            length = Math.max(length, s.length());
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < length + 6; ++i) {
            stringBuilder.append('*');
        }
        for (String s : lines) {
            stringBuilder.append("\n*  ");
            stringBuilder.append(s);
            for (int i = 0; i < length - s.length(); ++i) {
                stringBuilder.append(' ');
            }
            stringBuilder.append("  *");
        }
        stringBuilder.append('\n');
        for (int i = 0; i < length + 6; ++i) {
            stringBuilder.append('*');
        }
        return stringBuilder.toString();
    }

    public static String escapeStringLiteralForRegexp(String literal, String charsToPreserve) {
        String charsToEscape = "(){}[].^$+\\*?";
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < literal.length(); ++i) {
            char c = literal.charAt(i);
            if ("(){}[].^$+\\*?".indexOf(c) != -1 && charsToPreserve.indexOf(c) == -1) {
                buf.append("\\").append(c);
                continue;
            }
            buf.append(c);
        }
        return buf.toString();
    }

    public static String pad(int minWidth, Padding pad, String s) {
        int length = s.length();
        int toPad = minWidth - length;
        if (toPad > 0) {
            int i;
            int right;
            int left;
            switch (pad) {
                case LEFT: {
                    left = 0;
                    right = toPad;
                    break;
                }
                case RIGHT: {
                    left = toPad;
                    right = 0;
                    break;
                }
                case CENTRE: {
                    left = toPad / 2;
                    right = toPad - left;
                    break;
                }
                default: {
                    throw new CatastrophicError("Unknown padding kind: " + (Object)((Object)pad));
                }
            }
            StringBuilder sb = new StringBuilder();
            for (i = 0; i < left; ++i) {
                sb.append(' ');
            }
            sb.append(s);
            for (i = 0; i < right; ++i) {
                sb.append(' ');
            }
            return sb.toString();
        }
        return s;
    }

    public static List<String> pad(Padding pad, Collection<String> strings) {
        ArrayList<String> result = new ArrayList<String>(strings.size());
        int maxWidth = 0;
        for (String s : strings) {
            maxWidth = Math.max(maxWidth, s.length());
        }
        for (String s : strings) {
            result.add(StringUtil.pad(maxWidth, pad, s));
        }
        return result;
    }

    public static List<String> pad(Padding pad, String ... strings) {
        ArrayList<String> result = new ArrayList<String>(strings.length);
        int maxWidth = 0;
        for (String s : strings) {
            maxWidth = Math.max(maxWidth, s.length());
        }
        for (String s : strings) {
            result.add(StringUtil.pad(maxWidth, pad, s));
        }
        return result;
    }

    public static void padTable(List<String[]> rows, Padding ... pad) {
        int i;
        int width = pad.length;
        int[] maxLengths = new int[width];
        for (Object[] objectArray : rows) {
            if (objectArray.length != width) {
                throw new CatastrophicError("padTable can only be used with a rectangular table. Expected " + width + " columns but found row: " + Arrays.toString(objectArray));
            }
            for (i = 0; i < width; ++i) {
                maxLengths[i] = Math.max(maxLengths[i], ((String)objectArray[i]).length());
            }
        }
        for (String[] stringArray : rows) {
            for (i = 0; i < width; ++i) {
                stringArray[i] = StringUtil.pad(maxLengths[i], pad[i], stringArray[i]);
            }
        }
    }

    public static String glue(String separator, Iterable<?> values) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Object o : values) {
            if (first) {
                first = false;
            } else {
                sb.append(separator);
            }
            sb.append(o == null ? "<null>" : o.toString());
        }
        return sb.toString();
    }

    public static String glue(String separator, Object[] values) {
        return StringUtil.glue(separator, Arrays.asList(values));
    }

    public static String glue(String separator, String ... values) {
        return StringUtil.glue(separator, (Object[])values);
    }

    public static String escapePropertiesValue(String string) {
        return string.replace("!", "\\!").replace(":", "\\:").replace("#", "\\#").replace("=", "\\=").replace("\n", "\\n");
    }

    public static String escapePropertiesKey(String string) {
        return StringUtil.escapePropertiesValue(string).replace(" ", "\\ ");
    }

    public static String printFloat(double value) {
        if (Math.abs(value) > 9.99999999999999E14 && !Double.isInfinite(value)) {
            return DOUBLE_FORMATTER.format(new BigDecimal(value));
        }
        return DOUBLE_FORMATTER.format(value);
    }

    public static String escapeHTML(String s) {
        if (s == null) {
            return null;
        }
        int length = s.length();
        StringBuilder sb = new StringBuilder(length * 2 > 0 ? length * 2 : length);
        block7: for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '<': {
                    sb.append("&lt;");
                    continue block7;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block7;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block7;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block7;
                }
                case '\'': {
                    sb.append("&#39;");
                    continue block7;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static String escapeJSON(String str) {
        if (str == null) {
            return null;
        }
        StringBuilder res = new StringBuilder();
        int n = str.length();
        block9: for (int i = 0; i < n; ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '\"': {
                    res.append("\\\"");
                    continue block9;
                }
                case '\\': {
                    res.append("\\\\");
                    continue block9;
                }
                case '\b': {
                    res.append("\\b");
                    continue block9;
                }
                case '\f': {
                    res.append("\\f");
                    continue block9;
                }
                case '\n': {
                    res.append("\\n");
                    continue block9;
                }
                case '\r': {
                    res.append("\\r");
                    continue block9;
                }
                case '\t': {
                    res.append("\\t");
                    continue block9;
                }
                default: {
                    if (c < ' ') {
                        res.append(String.format("\\u%04x", c));
                        continue block9;
                    }
                    res.append(c);
                }
            }
        }
        return res.toString();
    }

    public static String escapeMarkdown(String str) {
        return StringUtil.escapeMarkdown(specialMarkdownChars, str);
    }

    public static String escapeMarkdown(List<Character> specialMarkdownChars, String str) {
        if (str == null) {
            return null;
        }
        StringBuilder res = new StringBuilder();
        boolean escapeOctothorp = true;
        int n = str.length();
        for (int i = 0; i < n; ++i) {
            char c = str.charAt(i);
            if (specialMarkdownChars.contains(Character.valueOf(c)) && (c != '#' || escapeOctothorp)) {
                res.append("\\").append(c);
            } else {
                res.append(c);
            }
            escapeOctothorp = c != '&';
        }
        return res.toString();
    }

    public static String makeQLStringLiteral(String value) {
        StringBuilder sb = new StringBuilder();
        sb.append('\"');
        block7: for (char c : value.toCharArray()) {
            switch (c) {
                case '\\': {
                    sb.append("\\\\");
                    continue block7;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block7;
                }
                case '\"': {
                    sb.append("\\\"");
                    continue block7;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block7;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block7;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        sb.append('\"');
        return sb.toString();
    }

    public static String wrap(String text, int cols) {
        if (text == null) {
            return null;
        }
        ArrayList<String> lines = new ArrayList<String>();
        int lineStart = -1;
        int wordStart = -1;
        int col = 0;
        for (int cur = 0; cur < text.length(); ++cur) {
            if (text.charAt(cur) == '\n') {
                if (lineStart < 0) {
                    lines.add("");
                } else {
                    lines.add(text.substring(lineStart, cur).trim());
                }
                lineStart = -1;
                wordStart = -1;
                col = 0;
            } else if (Character.isWhitespace(text.charAt(cur))) {
                if (col > cols) {
                    if (lineStart < 0) continue;
                    if (wordStart < 0) {
                        String line = text.substring(lineStart, cur).trim();
                        if (line.length() > 0) {
                            lines.add(line);
                        }
                        lineStart = -1;
                    } else if (wordStart > lineStart) {
                        lines.add(text.substring(lineStart, wordStart - 1).trim());
                        lineStart = wordStart;
                        col = cur - lineStart + 1;
                        wordStart = -1;
                    } else {
                        lines.add(text.substring(wordStart, cur).trim());
                        lineStart = -1;
                        wordStart = -1;
                    }
                } else {
                    wordStart = -1;
                }
            } else {
                if (lineStart < 0) {
                    lineStart = cur;
                    col = 0;
                }
                if (wordStart < 0) {
                    wordStart = cur;
                }
            }
            if (lineStart < 0) continue;
            ++col;
        }
        if (lineStart > -1) {
            lines.add(text.substring(lineStart).trim());
        }
        return StringUtil.glue("\n", lines);
    }

    public static String firstWord(String s) {
        int i;
        s = s.trim();
        for (i = 0; i < s.length() && !Character.isWhitespace(s.charAt(i)); ++i) {
        }
        return s.substring(0, i);
    }

    public static String stripFirstWord(String s) {
        int i;
        s = s.trim();
        for (i = 0; i < s.length() && !Character.isWhitespace(s.charAt(i)); ++i) {
        }
        return s.substring(i).trim();
    }

    public static String trim(String str, char c) {
        return StringUtil.trim(str, c, true, true);
    }

    public static String trim(String str, char c, boolean trimLeading, boolean trimTrailing) {
        int begin;
        int end = str.length();
        if (trimLeading) {
            for (begin = 0; begin < end && str.charAt(begin) == c; ++begin) {
            }
        }
        if (trimTrailing) {
            while (begin < end && str.charAt(end - 1) == c) {
                --end;
            }
        }
        if (begin > 0 || end < str.length()) {
            str = str.substring(begin, end);
        }
        return str;
    }

    public static String trimTrailingWhitespace(String str) {
        int end;
        int begin = 0;
        for (end = str.length(); begin < end && Character.isWhitespace(str.charAt(end - 1)); --end) {
        }
        if (end < str.length()) {
            str = str.substring(begin, end);
        }
        return str;
    }

    public static String trimForSecondaryLogging(String text) {
        int p = text.indexOf(10);
        if (p >= 0) {
            text = text.substring(0, p);
        }
        if (text.length() > 80) {
            text = text.substring(0, 70) + "...";
        }
        return text;
    }

    public static String bytesToString(byte[] bytes) {
        return new String(bytes, 0, bytes.length, UTF8_CHARSET);
    }

    public static String bytesToString(byte[] bytes, int offset, int length) {
        return new String(bytes, offset, length, UTF8_CHARSET);
    }

    public static byte[] stringToBytes(String str) {
        return str.getBytes(Charset.forName("UTF-8"));
    }

    public static byte[] stringToSHA1(String str) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
            return messageDigest.digest(StringUtil.stringToBytes(str));
        }
        catch (NoSuchAlgorithmException e) {
            throw new CatastrophicError("Failed to obtain MessageDigest for computing SHA-1", e);
        }
    }

    public static String repeat(String repeatee, int times) {
        if (times == 0) {
            return "";
        }
        return new String(new char[times]).replace("\u0000", repeatee);
    }

    public static String lc(String s) {
        return s.toLowerCase(Locale.ENGLISH);
    }

    public static String uc(String s) {
        return s.toUpperCase(Locale.ENGLISH);
    }

    public static String ucfirst(String s) {
        if (s.isEmpty() || !Character.isLowerCase(s.charAt(0))) {
            return s;
        }
        return StringUtil.uc(s.substring(0, 1)) + s.substring(1);
    }

    public static String[] lines(String s) {
        return StringUtil.lines(s, false, true);
    }

    public static String[] linesWithSeparators(String s) {
        return StringUtil.lines(s, true, true);
    }

    public static String[] lines(String s, boolean squishTrailing) {
        return StringUtil.lines(s, false, squishTrailing);
    }

    public static String[] lines(String s, boolean includeSeparators, boolean squishTrailing) {
        if (s.length() == 0) {
            return new String[0];
        }
        Pattern pattern = includeSeparators ? lineEndingIncludingSeparators : lineEnding;
        return pattern.split(s, squishTrailing ? 0 : -1);
    }

    public static String toUnixLineEndings(String s) {
        return lineEnding.matcher(s).replaceAll("\n");
    }

    public static boolean isMultiLine(String s) {
        return lineEnding.matcher(s).find();
    }

    public static String[] words(String s) {
        if ((s = s.trim()).length() == 0) {
            return new String[0];
        }
        return whitespace.split(s);
    }

    public static String[] paragraphs(String s) {
        ArrayList<String> paragraphs = new ArrayList<String>();
        StringBuilder paragraph = new StringBuilder();
        boolean emptyParagraph = true;
        for (String line : StringUtil.lines(s)) {
            if (line.isEmpty()) {
                if (!emptyParagraph) {
                    paragraphs.add(paragraph.toString());
                }
                paragraph = new StringBuilder();
                emptyParagraph = true;
                continue;
            }
            if (paragraph.length() != 0) {
                paragraph.append(' ');
            }
            paragraph.append(line);
            emptyParagraph = false;
        }
        if (!emptyParagraph) {
            paragraphs.add(paragraph.toString());
        }
        return paragraphs.toArray(new String[0]);
    }

    public static String toHex(byte ... bytes) {
        StringBuilder strBldr = new StringBuilder(bytes.length * 2);
        char[] hexchars = HEX_CHARS;
        for (byte b : bytes) {
            strBldr.append(hexchars[b >>> 4 & 0xF]).append(hexchars[b & 0xF]);
        }
        return strBldr.toString();
    }

    public static byte[] fromHex(String string) {
        int len = string.length();
        if (len % 2 != 0) {
            throw new NumberFormatException("Hexadecimal string should have an even number of characters.");
        }
        byte[] data = new byte[len / 2];
        int index = 0;
        for (int i = 0; i < len; i += 2) {
            int a = Character.digit(string.charAt(i), 16);
            if (a == -1) {
                throw new NumberFormatException("Invalid character in hexadecimal string: " + string.charAt(i));
            }
            int b = Character.digit(string.charAt(i + 1), 16);
            if (b == -1) {
                throw new NumberFormatException("Invalid character in hexadecimal string: " + string.charAt(i + 1));
            }
            data[index] = (byte)(a << 4 | b);
            ++index;
        }
        return data;
    }

    public static String getDurationString(long nanoSeconds) {
        char sign = nanoSeconds < 0L ? (char)'-' : '+';
        long l = nanoSeconds = nanoSeconds < 0L ? -nanoSeconds : nanoSeconds;
        if ((double)nanoSeconds < 10000.0) {
            return sign + StringUtil.getDurationString(nanoSeconds, 1.0, "[ns]");
        }
        if ((double)nanoSeconds < 1.0E7) {
            return sign + StringUtil.getDurationString(nanoSeconds, 1000.0, "[us]");
        }
        if ((double)nanoSeconds < 1.0E10) {
            return sign + StringUtil.getDurationString(nanoSeconds, 1000000.0, "[ms]");
        }
        if ((double)nanoSeconds < 1.0E13) {
            return sign + StringUtil.getDurationString(nanoSeconds, 1.0E9, "[s] ");
        }
        if ((double)nanoSeconds < 6.0E14) {
            return sign + StringUtil.getDurationString(nanoSeconds, 6.0E10, "[m] ");
        }
        if ((double)nanoSeconds < 3.6E16) {
            return sign + StringUtil.getDurationString(nanoSeconds, 3.6E12, "[h] ");
        }
        if ((double)nanoSeconds < 8.64E17) {
            return sign + StringUtil.getDurationString(nanoSeconds, 8.64E13, "[d] ");
        }
        return sign + StringUtil.getDurationString(nanoSeconds, 3.1536E16, "[y] ");
    }

    private static String getDurationString(long nanoSeconds, double divisor, String unit) {
        String scaledStr = String.format("%-4f", (double)nanoSeconds / divisor).substring(0, 4);
        return (scaledStr.endsWith(".") ? scaledStr.replace(".", " ") : scaledStr) + unit;
    }

    public static Integer parseInteger(String string) {
        if (string == null) {
            return null;
        }
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException nfe) {
            Exceptions.ignore(nfe, "deliberate test");
            return null;
        }
    }

    public static StringBuilder appendLine(StringBuilder strBldr, Object ... args) {
        for (Object arg : args) {
            strBldr.append(arg);
        }
        return strBldr.append("\n");
    }

    public static String prefixLines(String prefix, String text) {
        return text.replaceAll("(?m)^", prefix);
    }

    public static int count(String str, char ch) {
        int r = 0;
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) != ch) continue;
            ++r;
        }
        return r;
    }

    public static String addLineNumbers(String plainText) {
        String[] lines = StringUtil.lines(plainText, false);
        int lineColumnWidth = Integer.toString(lines.length).length();
        StringBuilder sampleWithLineNumbers = new StringBuilder();
        for (int i = 0; i < lines.length; ++i) {
            boolean last = i == lines.length - 1;
            sampleWithLineNumbers.append(String.format("%" + lineColumnWidth + "s  %s" + (last ? "" : "\n"), i + 1, lines[i]));
        }
        return sampleWithLineNumbers.toString();
    }

    public static boolean isDigits(String s) {
        return DIGITS_PATTERN.matcher(s).matches();
    }

    public static boolean isAsciiLetter(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
    }

    public static boolean secureIsEqual(String a, String b) {
        if (a == null) {
            return b == null;
        }
        byte[] aBytes = StringUtil.stringToBytes(a);
        boolean definitelyDifferent = b == null || b.length() != a.length();
        byte[] bBytes = StringUtil.stringToBytes(definitelyDifferent ? a : b);
        byte[] randomBBytes = new byte[a.length()];
        RANDOM.nextBytes(randomBBytes);
        if (definitelyDifferent) {
            bBytes = randomBBytes;
        }
        int result = 0;
        for (int i = 0; i < aBytes.length; ++i) {
            result |= aBytes[i] ^ bBytes[i];
        }
        return result == 0 && !definitelyDifferent;
    }

    public static String lineSeparator() {
        return System.getProperty("line.separator");
    }

    public static <T> String naturalGlue(String separator, String finalSeparator, Collection<T> values) {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<T> iterator = values.iterator();
        boolean first = true;
        if (iterator.hasNext()) {
            boolean hasNext = true;
            T current = iterator.next();
            while (hasNext) {
                Object next;
                hasNext = iterator.hasNext();
                Object v0 = next = iterator.hasNext() ? iterator.next() : null;
                if (first) {
                    first = false;
                } else if (!hasNext) {
                    stringBuilder.append(finalSeparator);
                } else {
                    stringBuilder.append(separator);
                }
                stringBuilder.append(current != null ? current : "<null>");
                current = next;
            }
        }
        return stringBuilder.toString();
    }

    public static String camelToSpinal(String camelCaseStr) {
        if (camelCaseStr == null) {
            return null;
        }
        String lcStr = camelCaseStr.toLowerCase(Locale.ENGLISH);
        StringBuilder strBldr = new StringBuilder();
        int i = 0;
        while (i < camelCaseStr.length()) {
            if (camelCaseStr.charAt(i) != lcStr.charAt(i)) {
                if (i > 0) {
                    strBldr.append("-");
                }
                int numUc = 0;
                while (i < camelCaseStr.length() && camelCaseStr.charAt(i) != lcStr.charAt(i)) {
                    if (numUc > 0 && i + 1 < camelCaseStr.length() && camelCaseStr.charAt(i + 1) == lcStr.charAt(i + 1) && StringUtil.isAsciiLetter(lcStr.charAt(i + 1))) {
                        strBldr.append("-").append(lcStr.charAt(i++));
                        break;
                    }
                    strBldr.append(lcStr.charAt(i++));
                    ++numUc;
                }
            }
            while (i < camelCaseStr.length() && camelCaseStr.charAt(i) == lcStr.charAt(i)) {
                strBldr.append(lcStr.charAt(i++));
            }
        }
        return strBldr.toString();
    }

    public static String lowerCaseFirstLetter(String s) {
        if (s == null || s.isEmpty()) {
            return s;
        }
        char[] chars = s.toCharArray();
        chars[0] = Character.toLowerCase(chars[0]);
        return new String(chars);
    }

    public static boolean isPlausibleEmail(String email) {
        return email != null && email.length() > 2 && email.contains("@");
    }

    public static String stripQlCommentsAndStrings(String ql, boolean terminateStringsAtLineEnd) {
        StringBuilder returnBuilder = new StringBuilder();
        boolean inString = false;
        boolean inMultiLineComment = false;
        boolean inSingleLineComment = false;
        for (int i = 0; i < ql.length(); ++i) {
            if (!inMultiLineComment && !inSingleLineComment && StringUtil.matchesAt(ql, i, "\"") && !StringUtil.isEscaped(ql, i)) {
                inString = !inString;
                continue;
            }
            if (StringUtil.matchesEolAt(ql, i)) {
                if (terminateStringsAtLineEnd) {
                    inString = false;
                } else if (inString) {
                    throw new IllegalArgumentException("Unterminated string found.");
                }
            }
            if (!inString && !inMultiLineComment && StringUtil.matchesAt(ql, i, "//")) {
                inSingleLineComment = true;
                continue;
            }
            if (inSingleLineComment && StringUtil.matchesEolAt(ql, i)) {
                inSingleLineComment = false;
            }
            if (!inString && !inSingleLineComment && StringUtil.matchesAt(ql, i, "/*")) {
                inMultiLineComment = true;
            } else if (inMultiLineComment && StringUtil.matchesAt(ql, i, "*/")) {
                inMultiLineComment = false;
                ++i;
                continue;
            }
            if (inString || inMultiLineComment || inSingleLineComment) continue;
            returnBuilder.append(ql.charAt(i));
        }
        if (inString && !terminateStringsAtLineEnd) {
            throw new IllegalArgumentException("Unterminated string found.");
        }
        return returnBuilder.toString();
    }

    public static String stripQlCommentsAndStrings(String ql) {
        return StringUtil.stripQlCommentsAndStrings(ql, false);
    }

    private static boolean matchesAt(String sourceString, int currentCharIndex, String subString) {
        if (currentCharIndex + subString.length() > sourceString.length()) {
            return false;
        }
        return sourceString.substring(currentCharIndex, currentCharIndex + subString.length()).equals(subString);
    }

    private static boolean matchesEolAt(String sourceString, int currentCharIndex) {
        return StringUtil.matchesOneOfAt(sourceString, currentCharIndex, "\n", "\r");
    }

    private static boolean matchesOneOfAt(String sourceString, int currentCharIndex, String ... subStrings) {
        for (String subString : subStrings) {
            if (!StringUtil.matchesAt(sourceString, currentCharIndex, subString)) continue;
            return true;
        }
        return false;
    }

    private static boolean isEscaped(String theString, int currentCharIndex) {
        if (currentCharIndex == 0) {
            return false;
        }
        return StringUtil.previousCharacter(theString, currentCharIndex) == '\\' && !StringUtil.isEscaped(theString, currentCharIndex - 1);
    }

    private static char previousCharacter(String theString, int currentCharIndex) {
        if (currentCharIndex == 0) {
            return '\u0000';
        }
        return theString.charAt(currentCharIndex - 1);
    }

    public static boolean isPlainEmail(String str) {
        String[] dnsLabels;
        if (str == null || str.length() < 5 || str.length() > 254) {
            return false;
        }
        if (!EMAIL_PATTERN.matcher(str).matches()) {
            return false;
        }
        int sepIndex = str.lastIndexOf("@");
        if (sepIndex > 64) {
            return false;
        }
        for (String dnsLabel : dnsLabels = str.substring(sepIndex + 1).split("\\.")) {
            if (dnsLabel.length() <= 63) continue;
            return false;
        }
        return !DIGITS_PATTERN.matcher(dnsLabels[dnsLabels.length - 1]).matches();
    }

    public static boolean arrayEqualsIgnoreCase(String[] a, String[] a2) {
        if (a == null) {
            return a2 == null;
        }
        if (a2 == null) {
            return false;
        }
        if (a.length != a2.length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if ((a[i] != null || a2[i] == null) && a[i].equalsIgnoreCase(a2[i])) continue;
            return false;
        }
        return true;
    }

    public static String toCommentString(String content) {
        String[] lines;
        StringBuilder result = new StringBuilder();
        result.append("/**\n");
        for (String line : lines = StringUtil.lines(content)) {
            result.append(" *" + line);
            result.append("\n");
        }
        result.append(" */");
        return result.toString();
    }

    public static boolean isPrintableAscii(String str) {
        if (str == null) {
            return false;
        }
        for (int i = 0; i < str.length(); ++i) {
            if (StringUtil.isPrintableAscii(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isPrintableAscii(char c) {
        return c >= ' ' && c < '\u007f';
    }

    public static boolean isAsciiText(String str) {
        for (int i = 0; i < str.length(); ++i) {
            if (StringUtil.isAsciiText(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isAsciiText(char c) {
        return StringUtil.isPrintableAscii(c) || c == '\t' || c == '\n' || c == '\r';
    }

    public static boolean containsControlCharacters(String str) {
        for (char c : str.toCharArray()) {
            if (!StringUtil.isControlCharacter(c)) continue;
            return true;
        }
        return false;
    }

    public static boolean isControlCharacter(char c) {
        if (c > '\u009f') {
            return false;
        }
        if (c >= ' ' && c < '\u007f') {
            return false;
        }
        return c != '\t' && c != '\n' && c != '\r';
    }

    static {
        DecimalFormatSymbols decimalFormatSymbols = DOUBLE_FORMATTER.getDecimalFormatSymbols();
        decimalFormatSymbols.setNaN("NaN");
        decimalFormatSymbols.setInfinity("Infinity");
        DOUBLE_FORMATTER.setDecimalFormatSymbols(decimalFormatSymbols);
        specialMarkdownChars = Arrays.asList(Character.valueOf('\\'), Character.valueOf('`'), Character.valueOf('_'), Character.valueOf('*'), Character.valueOf('('), Character.valueOf(')'), Character.valueOf('['), Character.valueOf(']'), Character.valueOf('#'), Character.valueOf('+'), Character.valueOf('-'), Character.valueOf('.'), Character.valueOf('!'));
        UTF8_CHARSET = Charset.forName("UTF-8");
        lineEnding = Pattern.compile("\r\n|\r|\n");
        lineEndingIncludingSeparators = Pattern.compile("(?<=(\r\n|\r(?!\n)|\n))");
        whitespace = Pattern.compile("\\s+");
        HEX_CHARS = "0123456789abcdef".toCharArray();
        DIGITS_PATTERN = Pattern.compile("[0-9]+");
        EMAIL_PATTERN = Pattern.compile("(?i)(?:[a-z0-9!#$%&'*+/=?^_`{|}~-]+|\"(?:[ \\x01-\\x08\\x0b\\x0c\\x0e-\\x1f\\x21\\x23-\\x5b\\x5d-\\x7f]|\\\\[\\x01-\\x09\\x0b\\x0c\\x0e-\\x7f])*\")(?:\\.(?:[a-z0-9!#$%&'*+/=?^_`{|}~-]+|\"(?:[ \\x01-\\x08\\x0b\\x0c\\x0e-\\x1f\\x21\\x23-\\x5b\\x5d-\\x7f]|\\\\[\\x01-\\x09\\x0b\\x0c\\x0e-\\x7f])*\"))*@(?:(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?|\\[(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?|[a-z0-9-]*[a-z0-9]:(?:[\\x01-\\x08\\x0b\\x0c\\x0e-\\x1f\\x21-\\x5a\\x53-\\x7f]|\\\\[\\x01-\\x09\\x0b\\x0c\\x0e-\\x7f])+)\\])");
        NEWLINE_PATTERN = Pattern.compile("\n");
    }

    public static enum Padding {
        LEFT,
        RIGHT,
        CENTRE;

    }
}

