/*
 * Decompiled with CFR 0.152.
 */
package com.semmle.util.files;

import com.semmle.util.files.FileUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtomicFileOutputStream
extends OutputStream {
    private static final Logger logger = LoggerFactory.getLogger(AtomicFileOutputStream.class);
    private boolean hasExceptions = false;
    private boolean open;
    private final Path outputFile;
    private final Path outputFileTemp;
    private OutputStream outputStream;

    Path tempFile() {
        return this.outputFileTemp;
    }

    public AtomicFileOutputStream(Path outputFile) throws IOException {
        this.outputFile = outputFile.toAbsolutePath();
        String prefix = this.outputFile.getFileName().toString();
        if (prefix.length() <= 3) {
            prefix = prefix + "_afos";
        }
        this.outputFileTemp = Files.createTempFile(this.outputFile.getParent(), prefix, ".temp", this.getTempFileAttributes());
        this.outputStream = Files.newOutputStream(this.outputFileTemp, new OpenOption[0]);
        this.open = true;
    }

    private FileAttribute<?>[] getTempFileAttributes() {
        FileAttribute[] attrs = this.outputFile.getParent().getFileSystem().supportedFileAttributeViews().contains("posix") ? new FileAttribute[]{PosixFilePermissions.asFileAttribute(PosixFilePermissions.fromString("rw-rw-rw-"))} : new FileAttribute[]{};
        return attrs;
    }

    private <T extends IOException> void fail(T ex) throws T {
        this.hasExceptions = true;
        throw ex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (!this.open) {
            return;
        }
        this.open = false;
        try {
            IOException exc = null;
            try {
                try {
                    this.flush();
                }
                catch (IOException e) {
                    exc = e;
                }
            }
            finally {
                block17: {
                    try {
                        this.outputStream.close();
                    }
                    catch (IOException e) {
                        if (exc != null) break block17;
                        exc = e;
                    }
                }
            }
            if (exc != null) {
                this.fail(exc);
            }
        }
        finally {
            if (this.hasExceptions) {
                Files.delete(this.outputFileTemp);
            }
        }
        if (this.hasExceptions) {
            return;
        }
        this.doRename();
    }

    private void doRename() throws IOException {
        try {
            FileUtil.moveWithRetries(this.outputFileTemp, this.outputFile, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (AtomicMoveNotSupportedException e) {
            logger.debug("Atomic move not supported, trying non-atomic move", e);
            try {
                FileUtil.moveWithRetries(this.outputFileTemp, this.outputFile, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e2) {
                logger.debug("Failed to move temporary output file {} to target {}", this.outputFileTemp, this.outputFile, e2);
                e2.addSuppressed(e);
                throw e2;
            }
        }
    }

    @Override
    public void flush() throws IOException {
        if (!this.open) {
            return;
        }
        this.checkValid();
        try {
            this.outputStream.flush();
        }
        catch (IOException ex) {
            this.fail(ex);
        }
    }

    public String toString() {
        return AtomicFileOutputStream.class.getSimpleName() + "(" + this.outputFile + ")";
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.checkValid();
        try {
            this.outputStream.write(b);
        }
        catch (IOException ex) {
            this.fail(ex);
        }
    }

    @Override
    public void write(byte[] b, int start, int len) throws IOException {
        this.checkValid();
        try {
            this.outputStream.write(b, start, len);
        }
        catch (IOException ex) {
            this.fail(ex);
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.checkValid();
        try {
            this.outputStream.write(b);
        }
        catch (IOException ex) {
            this.fail(ex);
        }
    }

    private void checkValid() throws IOException {
        if (!this.open) {
            throw new IOException("Attempt to use a closed AtomicFileOutputStream.");
        }
        if (this.hasExceptions) {
            throw new IOException("Attempt to use a broken AtomicFileOutputStream.");
        }
    }
}

