/*
 * Decompiled with CFR 0.152.
 */
package com.semmle.util.io;

import com.semmle.util.files.FileUtil;
import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;

public class BufferedLineReader
implements Closeable {
    private final char[] buffer = new char[8192];
    private int nextChar = 0;
    private int nChars = 0;
    private final Reader in;

    public BufferedLineReader(Reader in) {
        this.in = in;
    }

    public String readLineAndTerminator() throws IOException {
        int terminator = this.findNextLineTerminator();
        if (terminator == -1) {
            return null;
        }
        String result = new String(this.buffer, this.nextChar, terminator - this.nextChar + 1);
        this.nextChar = terminator + 1;
        return result;
    }

    private int findNextLineTerminator() throws IOException {
        int newlyRead;
        int alreadyChecked = 0;
        do {
            for (int i = this.nextChar + alreadyChecked; i < this.nChars; ++i) {
                if (this.buffer[i] == '\r' && i + 1 < this.nChars && this.buffer[i + 1] == '\n') {
                    return i + 1;
                }
                if (this.buffer[i] != '\n') continue;
                return i;
            }
            alreadyChecked = this.nChars - this.nextChar;
        } while ((newlyRead = this.fill()) > 0);
        return this.nChars - 1;
    }

    private int fill() throws IOException {
        int read;
        if (this.nextChar >= this.nChars) {
            this.nextChar = 0;
            this.nChars = 0;
        } else if (this.nextChar > 0) {
            System.arraycopy(this.buffer, this.nextChar, this.buffer, 0, this.nChars - this.nextChar);
            this.nChars -= this.nextChar;
            this.nextChar = 0;
        }
        if (this.nChars == this.buffer.length) {
            return 0;
        }
        while ((read = this.in.read(this.buffer, this.nChars, this.buffer.length - this.nChars)) == 0) {
        }
        if (read > 0) {
            this.nChars += read;
        }
        return read;
    }

    @Override
    public void close() {
        FileUtil.close(this.in);
    }
}

