/*
 * Decompiled with CFR 0.152.
 */
package com.semmle.util.io;

import com.semmle.util.io.CircularByteBuffer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class Pipe {
    private static final int DEFAULT_SIZE = 1024;
    private final CircularByteBuffer buf;
    private final IS is;
    private final OS os;
    private volatile boolean closed = false;
    private final Lock lock = new ReentrantLock();
    private final Condition notFull = this.lock.newCondition();
    private final Condition notEmpty = this.lock.newCondition();

    public Pipe(int size) {
        this.buf = new CircularByteBuffer(size);
        this.is = new IS();
        this.os = new OS();
    }

    public Pipe() {
        this(1024);
    }

    public OutputStream in() {
        return this.os;
    }

    public InputStream out() {
        return this.is;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(byte[] data, int offset, int length) throws IOException {
        while (length > 0) {
            this.lock.lock();
            try {
                int written = this.tryWrite(data, offset, length);
                while (written == 0) {
                    try {
                        this.notFull.await();
                    }
                    catch (InterruptedException e) {
                        throw new IOException("Write interrupted", e);
                    }
                    written = this.tryWrite(data, offset, length);
                }
                offset += written;
                length -= written;
                if (written <= 0) continue;
                this.notEmpty.signal();
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    private int tryWrite(byte[] data, int offset, int length) throws IOException {
        if (this.closed) {
            throw new IOException("Stream has been closed");
        }
        return this.buf.write(data, offset, length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int read(byte[] buffer, int offset, int length) throws IOException {
        int read;
        if (length == 0) {
            return 0;
        }
        this.lock.lock();
        try {
            read = this.tryRead(buffer, offset, length);
            while (read == 0) {
                try {
                    this.notEmpty.await();
                }
                catch (InterruptedException e) {
                    throw new IOException("Read interrupted", e);
                }
                read = this.tryRead(buffer, offset, length);
            }
            if (read > 0) {
                this.notFull.signal();
            }
        }
        finally {
            this.lock.unlock();
        }
        return read;
    }

    private int tryRead(byte[] buffer, int offset, int length) {
        if (this.closed && this.buf.usedBytes() == 0) {
            return -1;
        }
        return this.buf.read(buffer, offset, length);
    }

    public void close() {
        this.closed = true;
        this.lock.lock();
        try {
            this.notEmpty.signalAll();
            this.notFull.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    public String toString() {
        return this.buf.toString();
    }

    private class IS
    extends InputStream {
        private final byte[] singleReadBuffer = new byte[1];
        private final byte[] skipBuffer = new byte[Pipe.access$400(Pipe.this).size()];

        private IS() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read() throws IOException {
            byte[] byArray = this.singleReadBuffer;
            synchronized (this.singleReadBuffer) {
                int read = this.read(this.singleReadBuffer);
                if (read == -1) {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return -1;
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return this.singleReadBuffer[0] & 0xFF;
            }
        }

        @Override
        public int read(byte[] buffer) throws IOException {
            return this.read(buffer, 0, buffer.length);
        }

        @Override
        public int read(byte[] buffer, int offset, int length) throws IOException {
            return Pipe.this.read(buffer, offset, length);
        }

        @Override
        public long skip(long n) throws IOException {
            return this.read(this.skipBuffer);
        }

        @Override
        public int available() {
            return Pipe.this.buf.usedBytes();
        }

        @Override
        public boolean markSupported() {
            return false;
        }

        @Override
        public void close() {
            Pipe.this.close();
        }
    }

    private class OS
    extends OutputStream {
        private final byte[] singleWriteBuffer = new byte[1];

        private OS() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(int b) throws IOException {
            byte[] byArray = this.singleWriteBuffer;
            synchronized (this.singleWriteBuffer) {
                this.singleWriteBuffer[0] = (byte)b;
                this.write(this.singleWriteBuffer);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }

        @Override
        public void write(byte[] data) throws IOException {
            this.write(data, 0, data.length);
        }

        @Override
        public void write(byte[] data, int offset, int length) throws IOException {
            Pipe.this.write(data, offset, length);
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() {
            Pipe.this.close();
        }
    }
}

