/*
 * Decompiled with CFR 0.152.
 */
package com.semmle.util.io.csv;

import java.io.Closeable;
import java.io.IOException;
import java.io.Writer;
import java.util.List;

public class CSVWriter
implements Closeable {
    private static final int INITIAL_STRING_SIZE = 128;
    private Writer rawWriter;
    private char separator;
    private char quotechar;
    private char escapechar;
    private String lineEnd;
    public static final char NO_QUOTE_CHARACTER = '\u0000';
    private static final char NO_ESCAPE_CHARACTER = '\u0000';
    private static final String DEFAULT_LINE_END = "\n";
    private boolean[] eagerQuotingFlags = new boolean[0];

    public CSVWriter(Writer writer) {
        this(writer, ',', '\"', '\"');
    }

    public CSVWriter(Writer writer, char separator, char quotechar, char escapechar) {
        this(writer, separator, quotechar, escapechar, DEFAULT_LINE_END);
    }

    private CSVWriter(Writer writer, char separator, char quotechar, char escapechar, String lineEnd) {
        this.rawWriter = writer;
        this.separator = separator;
        this.quotechar = quotechar;
        this.escapechar = escapechar;
        this.lineEnd = lineEnd;
    }

    public void setEagerQuotingColumns(boolean ... flags) {
        this.eagerQuotingFlags = flags;
    }

    public void writeAll(List<String[]> allLines) throws IOException {
        for (String[] line : allLines) {
            this.writeNext(line);
        }
    }

    public void writeNext(String ... nextLine) throws IOException {
        if (nextLine == null) {
            return;
        }
        StringBuilder sb = new StringBuilder(128);
        for (int i = 0; i < nextLine.length; ++i) {
            String nextElement;
            if (i != 0) {
                sb.append(this.separator);
            }
            if ((nextElement = nextLine[i]) == null) continue;
            boolean hasSpecials = this.stringContainsSpecialCharacters(nextElement);
            if (hasSpecials || i >= this.eagerQuotingFlags.length || this.eagerQuotingFlags[i] || this.stringContainsSomewhatSpecialCharacter(nextElement)) {
                if (this.quotechar != '\u0000') {
                    sb.append(this.quotechar);
                }
                sb.append(hasSpecials ? this.processLine(nextElement) : nextElement);
                if (this.quotechar == '\u0000') continue;
                sb.append(this.quotechar);
                continue;
            }
            sb.append(nextElement);
        }
        sb.append(this.lineEnd);
        this.rawWriter.write(sb.toString());
    }

    private boolean stringContainsSpecialCharacters(String line) {
        return line.indexOf(this.quotechar) != -1 || line.indexOf(this.escapechar) != -1;
    }

    private boolean stringContainsSomewhatSpecialCharacter(String s) {
        return s.indexOf(34) != -1 || s.indexOf(39) != -1 || s.indexOf(9) != -1 || s.indexOf(this.separator) != -1;
    }

    protected StringBuilder processLine(String nextElement) {
        StringBuilder sb = new StringBuilder(128);
        for (int j = 0; j < nextElement.length(); ++j) {
            char nextChar = nextElement.charAt(j);
            if (this.escapechar != '\u0000' && nextChar == this.quotechar) {
                sb.append(this.escapechar).append(nextChar);
                continue;
            }
            if (this.escapechar != '\u0000' && nextChar == this.escapechar) {
                sb.append(this.escapechar).append(nextChar);
                continue;
            }
            sb.append(nextChar);
        }
        return sb;
    }

    public void flush() throws IOException {
        this.rawWriter.flush();
    }

    @Override
    public void close() throws IOException {
        this.rawWriter.close();
    }
}

