/*
 * Decompiled with CFR 0.152.
 */
package com.semmle.util.jmx;

import com.semmle.util.exception.CatastrophicError;
import com.semmle.util.exception.Exceptions;
import java.lang.management.ManagementFactory;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class MBeans {
    private static final String TAG = "semmle_classloader=" + System.identityHashCode(MBeans.class.getClassLoader());

    public static JMException register(Object mbean, String ... properties) {
        try {
            ObjectName name = MBeans.computeObjectName(mbean, properties);
            ManagementFactory.getPlatformMBeanServer().registerMBean(mbean, name);
        }
        catch (JMException e) {
            return e;
        }
        return null;
    }

    public static JMException deregister(Object mbean, String ... properties) {
        try {
            ObjectName name = MBeans.computeObjectName(mbean, properties);
            ManagementFactory.getPlatformMBeanServer().unregisterMBean(name);
        }
        catch (JMException e) {
            return e;
        }
        return null;
    }

    private static ObjectName computeObjectName(Object mbean, String ... properties) throws MalformedObjectNameException {
        StringBuilder sb = new StringBuilder();
        sb.append(mbean.getClass().getPackage().getName());
        sb.append(":type=" + mbean.getClass().getSimpleName());
        for (String property : properties) {
            sb.append(",").append(property);
        }
        sb.append(",").append(TAG);
        ObjectName name = new ObjectName(sb.toString());
        return name;
    }

    public static void deregisterAll() {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        try {
            for (ObjectName mbean : mbs.queryNames(new ObjectName("*:" + TAG + ",*"), null)) {
                try {
                    mbs.unregisterMBean(mbean);
                }
                catch (JMException e) {
                    Exceptions.ignore(e, "Not much we can do to recover...");
                }
            }
        }
        catch (MalformedObjectNameException e) {
            throw new CatastrophicError("Unexpected failure for '*:" + TAG + ",*'.", e);
        }
    }
}

