/*
 * Decompiled with CFR 0.152.
 */
package com.semmle.util.locations;

import com.semmle.util.data.IntList;
import com.semmle.util.locations.Position;

public class LineTable {
    private final IntList lineStarts = IntList.create();

    public LineTable(String text) {
        this.lineStarts.add(0);
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            if (ch == '\n') {
                this.lineStarts.add(i + 1);
                continue;
            }
            if (ch != '\r') continue;
            if (i + 1 < text.length() && text.charAt(i + 1) == '\n') {
                ++i;
            }
            this.lineStarts.add(i + 1);
        }
    }

    public int getStartOfLineIndex(int line) {
        return this.lineStarts.get(line);
    }

    public int getLineIndexFromOffset(int offset) {
        int index = this.lineStarts.binarySearch(offset);
        if (index < 0 && (index = -index - 2) < 0) {
            index = 0;
        }
        return index;
    }

    public int getOffsetFromPoint(int line, int column) {
        if (line < 0) {
            return 0;
        }
        if (line >= this.lineStarts.size()) {
            return this.lineStarts.get(this.lineStarts.size() - 1);
        }
        return this.lineStarts.get(line) + column;
    }

    private int getColumnFromLineAndOffset(int line, int offset) {
        int start = this.lineStarts.get(line);
        return offset - start;
    }

    public Position getPositionFromOffset(int offset) {
        int line = this.getLineIndexFromOffset(offset);
        int column = this.getColumnFromLineAndOffset(line, offset);
        return new Position(line + 1, column + 1, offset);
    }

    public Position getEndPositionFromOffset(int offset) {
        int line = this.getLineIndexFromOffset(offset);
        int column = this.getColumnFromLineAndOffset(line, offset);
        return new Position(line + 1, column + 2, offset);
    }
}

