/*
 * Decompiled with CFR 0.152.
 */
package com.semmle.util.locations;

import com.semmle.util.data.IntList;

public class OffsetTranslation {
    private final IntList anchors;
    private final IntList deltas;

    public OffsetTranslation() {
        this.anchors = IntList.create();
        this.deltas = IntList.create();
    }

    private OffsetTranslation(IntList anchors, IntList deltas) {
        this.anchors = anchors;
        this.deltas = deltas;
    }

    public int get(int x) {
        int index = this.anchors.binarySearch(x);
        if (index < 0 && (index = -index - 2) < 0) {
            index = 0;
        }
        return x + this.deltas.get(index);
    }

    public void set(int from, int to) {
        this.anchors.add(from);
        this.deltas.add(to - from);
    }

    public OffsetTranslation clone() {
        return new OffsetTranslation(new IntList(this.anchors), new IntList(this.deltas));
    }

    public OffsetTranslation append(OffsetTranslation other, int offset, int delta) {
        OffsetTranslation result = this;
        for (int i = 0; i < other.anchors.size(); ++i) {
            result.set(other.anchors.get(i) + offset, other.deltas.get(i) + delta);
        }
        return result;
    }
}

