/*
 * Decompiled with CFR 0.152.
 */
package com.semmle.util.locations;

public final class Position {
    private final int line;
    private final int column;
    private final int offset;

    public Position(int line, int column, int offset) {
        this.line = line;
        this.column = column;
        this.offset = offset;
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    public int getOffset() {
        return this.offset;
    }

    public String toString() {
        return "(" + this.line + "," + this.column + "," + this.offset + ")";
    }

    public String getPrettyString() {
        return this.line + ":" + this.column;
    }

    public Position append(Position relativePos) {
        int columnOffset = relativePos.line == 1 ? this.column - 1 : 0;
        return new Position(this.line + relativePos.line - 1, columnOffset + relativePos.column, this.offset + relativePos.offset);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.column;
        result = 31 * result + this.line;
        result = 31 * result + this.offset;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Position other = (Position)obj;
        if (this.column != other.column) {
            return false;
        }
        if (this.line != other.line) {
            return false;
        }
        return this.offset == other.offset;
    }
}

