/*
 * Decompiled with CFR 0.152.
 */
package com.semmle.util.locations;

import com.semmle.util.locations.LineTable;
import com.semmle.util.locations.OffsetTranslation;
import com.semmle.util.locations.Position;

public interface SourceMap {
    public Position getStart(int var1);

    default public Position getEnd(int offset) {
        return this.getStart(offset + 1);
    }

    public static SourceMap fromString(String str) {
        return SourceMap.fromLineTable(new LineTable(str));
    }

    public static SourceMap fromLineTable(LineTable lineTable) {
        return offset -> lineTable.getPositionFromOffset(offset);
    }

    default public SourceMap offsetBy(final int startOffset, final OffsetTranslation offsets) {
        return new SourceMap(){

            @Override
            public Position getStart(int offset) {
                return SourceMap.this.getStart(startOffset + offsets.get(offset));
            }

            @Override
            public Position getEnd(int offset) {
                return SourceMap.this.getEnd(startOffset + offsets.get(offset + 1) - 1);
            }
        };
    }

    default public SourceMap offsetBy(final int startOffset) {
        return new SourceMap(){

            @Override
            public Position getStart(int offset) {
                return SourceMap.this.getStart(startOffset + offset);
            }

            @Override
            public Position getEnd(int offset) {
                return SourceMap.this.getEnd(startOffset + offset);
            }
        };
    }

    public static SourceMap legacyWithStartPos(final SourceMap map, final Position startPos) {
        return new SourceMap(){

            @Override
            public Position getStart(int offset) {
                return startPos.append(map.getStart(offset));
            }

            @Override
            public Position getEnd(int offset) {
                return startPos.append(map.getEnd(offset));
            }
        };
    }
}

