/*
 * Decompiled with CFR 0.152.
 */
package com.semmle.util.logging;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.PatternLayout;
import ch.qos.logback.classic.filter.ThresholdFilter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.ConsoleAppender;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.Layout;
import ch.qos.logback.core.UnsynchronizedAppenderBase;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.encoder.LayoutWrappingEncoder;
import ch.qos.logback.core.filter.Filter;
import ch.qos.logback.core.spi.ContextAware;
import ch.qos.logback.core.spi.FilterReply;
import ch.qos.logback.core.spi.LifeCycle;
import com.semmle.util.constants.SystemConstants;
import com.semmle.util.exception.UserError;
import com.semmle.util.logging.AsyncAppender;
import com.semmle.util.logging.LogOutputStream;
import com.semmle.util.logging.RecordingAppender;
import com.semmle.util.logging.SemmleLayout;
import com.semmle.util.logging.StreamAppender;
import com.semmle.util.logging.Streams;
import com.semmle.util.process.Env;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class LogbackUtils {
    private static final ch.qos.logback.classic.Logger root;
    private static final ch.qos.logback.classic.Logger semmleRoot;
    public static final Marker RAW;
    private static int appenderCount;
    private static PrintStream stderrLogging;

    public static ch.qos.logback.classic.Logger getLogger(String name) {
        return (ch.qos.logback.classic.Logger)LoggerFactory.getLogger(name);
    }

    public static ch.qos.logback.classic.Logger getLogger(Class<?> clazz) {
        return (ch.qos.logback.classic.Logger)LoggerFactory.getLogger(clazz);
    }

    public static ch.qos.logback.classic.Logger semmleRoot() {
        return semmleRoot;
    }

    public static ch.qos.logback.classic.Logger root() {
        return root;
    }

    public static <T extends Appender<ILoggingEvent>> T withThreshold(T appender, Level l) {
        ThresholdFilter filter = new ThresholdFilter();
        filter.setLevel(l.levelStr);
        appender.addFilter(LogbackUtils.setup(filter));
        return appender;
    }

    public static <T extends Appender<ILoggingEvent>> T withMarkerFilter(T appender, String[] markerFilters) {
        appender.addFilter(LogbackUtils.setup(new MarkerFilter(Arrays.asList(markerFilters))));
        return appender;
    }

    public static FileAppender<ILoggingEvent> createFileAppender(File file) {
        FileAppender<ILoggingEvent> appender = new FileAppender<ILoggingEvent>();
        appender.setFile(file.getAbsolutePath());
        appender.setEncoder(LogbackUtils.standardEncoder());
        LogbackUtils.setup(appender);
        return appender;
    }

    public static Layout<ILoggingEvent> standardLayout() {
        return new SemmleLayout(true);
    }

    public static final ConsoleAppender<ILoggingEvent> consoleAppenderFromPattern(String pattern) {
        ConsoleAppender<ILoggingEvent> consoleAppender = new ConsoleAppender<ILoggingEvent>();
        consoleAppender.setEncoder(LogbackUtils.fromLayout(LogbackUtils.fromPattern(pattern)));
        LogbackUtils.setup(consoleAppender);
        return consoleAppender;
    }

    public static PatternLayout fromPattern(String pattern) {
        PatternLayout layout = new PatternLayout();
        layout.setPattern(pattern);
        LogbackUtils.setup(layout);
        return layout;
    }

    public static Encoder<ILoggingEvent> standardEncoder() {
        return LogbackUtils.fromLayout(LogbackUtils.standardLayout());
    }

    public static Encoder<ILoggingEvent> fromLayout(Layout<ILoggingEvent> layout) {
        LayoutWrappingEncoder<ILoggingEvent> e = new LayoutWrappingEncoder<ILoggingEvent>();
        e.setLayout(layout);
        e.setCharset(Charset.forName("UTF-8"));
        return LogbackUtils.setup(e);
    }

    public static void setContext(ContextAware c) {
        c.setContext((LoggerContext)LoggerFactory.getILoggerFactory());
    }

    public static <T extends ContextAware & LifeCycle> T setup(T it) {
        LogbackUtils.setContext(it);
        ((LifeCycle)it).start();
        return it;
    }

    public static ch.qos.logback.classic.Logger instanceLogger(Object o) {
        return LogbackUtils.instanceLogger(o.getClass().getName(), o);
    }

    public static ch.qos.logback.classic.Logger instanceLogger(String prefix, Object o) {
        return (ch.qos.logback.classic.Logger)LoggerFactory.getLogger(prefix + "." + System.identityHashCode(o));
    }

    public static OutputStream streamFor(Logger log, String category, boolean interpretCR) {
        return LogbackUtils.streamFor(log, category, interpretCR, Level.INFO);
    }

    public static OutputStream streamFor(Logger log, String category, boolean interpretCR, Level level) {
        return new LogOutputStream(log, MarkerFactory.getMarker(category), interpretCR, level);
    }

    public static void assertNoErrors(RecordingAppender ap) {
        if (!SystemConstants.extraAssertions()) {
            return;
        }
        for (ILoggingEvent e : ap.getEvents()) {
            if (!e.getLevel().isGreaterOrEqual(Level.ERROR)) continue;
            throw new UserError("ERROR: Errors were logged, and extra assertions are enabled.");
        }
    }

    public static void logAtLevel(Logger logger, Level level, Marker marker, String msg) {
        switch (level.toInt()) {
            case 0x7FFFFFFF: {
                break;
            }
            case 10000: {
                logger.debug(marker, msg);
                break;
            }
            case 40000: {
                logger.error(marker, msg);
                break;
            }
            case 20000: {
                logger.info(marker, msg);
                break;
            }
            case 5000: {
                logger.trace(marker, msg);
                break;
            }
            case 30000: {
                logger.warn(marker, msg);
            }
        }
    }

    public static boolean active() {
        return appenderCount > 0;
    }

    public static boolean goesToStderr() {
        return stderrLogging == Streams.err();
    }

    public static void removeAllAppenders() {
        LogbackUtils.root().detachAndStopAllAppenders();
        LogbackUtils.semmleRoot().detachAndStopAllAppenders();
        appenderCount = 0;
    }

    public static void addStderrAppender() {
        String markerAllowList;
        PrintStream err = Streams.err();
        UnsynchronizedAppenderBase appender = new StreamAppender(err);
        if (!Env.systemEnv().getBoolean(Env.Var.SEMMLE_SYNCHRONOUS_LOGGING)) {
            appender = new AsyncAppender(appender);
        }
        if (!(markerAllowList = Env.systemEnv().getOrDefault(Env.Var.CODEQL_LOG_MARKER_ALLOWLIST, "")).isEmpty()) {
            appender = LogbackUtils.withMarkerFilter(appender, markerAllowList.split(","));
        }
        LogbackUtils.addAppender(appender);
        stderrLogging = err;
    }

    public static void addAppender(Appender<ILoggingEvent> appender) {
        semmleRoot.addAppender(appender);
        ++appenderCount;
    }

    public static void removeAppender(Appender<ILoggingEvent> appender) {
        appender.stop();
        if (semmleRoot.detachAppender(appender)) {
            --appenderCount;
        }
    }

    static {
        String logOverride = System.getProperty("com.semmle.loglevels", Env.systemEnv().get(Env.Var.SEMMLE_LOG_LEVELS));
        if (logOverride != null) {
            for (String loggerOverride : logOverride.split(",")) {
                int equalsIndex = (loggerOverride = loggerOverride.trim()).indexOf(61);
                if (equalsIndex <= 0 || equalsIndex >= loggerOverride.length()) continue;
                LogbackUtils.getLogger(loggerOverride.substring(0, equalsIndex)).setLevel(Level.toLevel(loggerOverride.substring(equalsIndex + 1), Level.DEBUG));
            }
        }
        root = LogbackUtils.getLogger("ROOT");
        semmleRoot = LogbackUtils.getLogger("com.semmle");
        RAW = MarkerFactory.getMarker("RAW");
        appenderCount = 0;
        stderrLogging = null;
    }

    public static class MarkerFilter
    extends Filter<ILoggingEvent> {
        List<String> markerFilters;

        public MarkerFilter(List<String> markerFilters) {
            this.markerFilters = markerFilters;
        }

        @Override
        public FilterReply decide(ILoggingEvent event) {
            if (!this.isStarted()) {
                return FilterReply.NEUTRAL;
            }
            Marker marker = event.getMarker();
            if (marker != null && this.markerFilters.contains(marker.getName())) {
                return FilterReply.ACCEPT;
            }
            return FilterReply.DENY;
        }
    }
}

