/*
 * Decompiled with CFR 0.152.
 */
package com.semmle.util.logging;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.pattern.CallerDataConverter;
import ch.qos.logback.classic.pattern.ThrowableProxyConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.CoreConstants;
import ch.qos.logback.core.LayoutBase;
import com.semmle.util.data.StringUtil;
import com.semmle.util.logging.LogbackUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SemmleLayout
extends LayoutBase<ILoggingEvent> {
    private final ThrowableProxyConverter tpc = new ThrowableProxyConverter();
    private final CallerDataConverter cdc = new CallerDataConverter();
    private final boolean printStackTraces;
    private static final Pattern rpZeroOrMoreDigits = Pattern.compile("[0-9]*");
    private static final Pattern logLevelPattern = Pattern.compile("\\[(TRACE|DEBUG|INFO|WARN|ERROR)\\]");

    public SemmleLayout(boolean printStackTraces) {
        this.start();
        this.tpc.start();
        this.cdc.start();
        this.printStackTraces = printStackTraces;
    }

    public SemmleLayout() {
        this(true);
    }

    @Override
    public String doLayout(ILoggingEvent e) {
        if (e.getMarker() != null && e.getMarker().contains(LogbackUtils.RAW)) {
            return e.getFormattedMessage() + CoreConstants.LINE_SEPARATOR;
        }
        Date d = new Date(e.getTimeStamp());
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        SemmleLayout.appendInt4(sb, d.getYear() + 1900);
        sb.append('-');
        SemmleLayout.appendInt2(sb, d.getMonth() + 1);
        sb.append('-');
        SemmleLayout.appendInt2(sb, d.getDate());
        sb.append(' ');
        SemmleLayout.appendInt2(sb, d.getHours());
        sb.append(':');
        SemmleLayout.appendInt2(sb, d.getMinutes());
        sb.append(':');
        SemmleLayout.appendInt2(sb, d.getSeconds());
        sb.append("] ");
        if (e.getMarker() != null) {
            sb.append('[').append(e.getMarker()).append("] ");
        }
        if (e.getLevel() != Level.INFO) {
            sb.append('[').append(e.getLevel()).append("] ");
        }
        boolean shouldIndent = !e.getFormattedMessage().startsWith("\n");
        int indent = shouldIndent ? sb.length() : 0;
        SemmleLayout.appendLines(sb, indent, e.getFormattedMessage());
        if (this.printStackTraces && e.getThrowableProxy() != null) {
            SemmleLayout.appendLines(sb, indent, this.tpc.convert(e));
        }
        return sb.toString();
    }

    static void appendInt2(StringBuilder sb, int i) {
        sb.append((char)(48 + i / 10));
        sb.append((char)(48 + i % 10));
    }

    static void appendInt4(StringBuilder sb, int i) {
        SemmleLayout.appendInt2(sb, i / 100);
        SemmleLayout.appendInt2(sb, i % 100);
    }

    private static void appendLines(StringBuilder sb, int indent, String multiline) {
        for (String line : StringUtil.lines(multiline)) {
            SemmleLayout.appendLine(sb, indent, line);
        }
    }

    private static void appendLine(StringBuilder sb, int indent, String line) {
        if (sb.length() != indent) {
            for (int i = 0; i < indent; ++i) {
                sb.append(' ');
            }
        }
        sb.append(line).append(CoreConstants.LINE_SEPARATOR);
    }

    private static String getClassName(ILoggingEvent e) {
        ArrayList<String> nameParts = new ArrayList<String>(Arrays.asList(e.getLoggerName().split("\\.")));
        Collections.reverse(nameParts);
        String name = "";
        for (String part : nameParts) {
            if (rpZeroOrMoreDigits.matcher(part).matches()) continue;
            name = part;
            break;
        }
        return name;
    }

    public static Level parseLogLevel(String formattedLine) {
        Matcher m = logLevelPattern.matcher(formattedLine);
        if (m.matches()) {
            return Level.toLevel(m.group(1));
        }
        return Level.INFO;
    }
}

