/*
 * Decompiled with CFR 0.152.
 */
package com.semmle.util.process;

import com.semmle.util.io.StreamMuncher;
import com.semmle.util.logging.Streams;
import com.semmle.util.process.AbstractProcessBuilder;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class Builder
extends AbstractProcessBuilder {
    private final OutputStream err;
    private final OutputStream out;
    protected StreamMuncher errMuncher;
    protected StreamMuncher outMuncher;

    public Builder(OutputStream out, OutputStream err, File cwd, String ... args) {
        this(out, err, cwd, (Map<String, String>)null, args);
    }

    public Builder(OutputStream out, OutputStream err, File cwd, Map<String, String> env, String ... args) {
        this(Arrays.asList(args), out, err, env, cwd);
    }

    public Builder(List<String> args, OutputStream out, OutputStream err) {
        this(args, out, err, null, null);
    }

    public Builder(List<String> args, OutputStream out, OutputStream err, File cwd) {
        this(args, out, err, null, cwd);
    }

    public Builder(List<String> args, OutputStream out, OutputStream err, Map<String, String> env) {
        this(args, out, err, env, null);
    }

    public Builder(List<String> args, OutputStream out, OutputStream err, Map<String, String> env, File cwd) {
        super(args, cwd, env);
        this.out = out;
        this.err = err;
    }

    public static int run(List<String> commandLine) {
        return new Builder(commandLine, Streams.out(), Streams.err()).execute();
    }

    @Override
    protected void setupRedirections(ProcessBuilder builder) {
        if (this.out == Streams.origOut) {
            builder.redirectOutput(ProcessBuilder.Redirect.INHERIT);
        }
        if (this.err == Streams.origErr) {
            builder.redirectError(ProcessBuilder.Redirect.INHERIT);
        } else {
            builder.environment().remove("CODEQL_ISATTY");
            if (this.err == this.out) {
                builder.redirectErrorStream(true);
            }
        }
    }

    @Override
    protected void cleanupOutputHandling() {
        long deadline = 20000L;
        if (this.outMuncher != null) {
            this.waitForMuncher("output", this.outMuncher, deadline);
        }
        if (this.errMuncher != null) {
            this.waitForMuncher("error", this.errMuncher, deadline);
        }
    }

    @Override
    protected void setupOutputHandling(InputStream stdout, InputStream stderr) {
        if (this.err != Streams.origErr && this.err != this.out) {
            this.errMuncher = new StreamMuncher(stderr, this.err);
            this.errMuncher.start();
        }
        if (this.out != Streams.origOut) {
            this.outMuncher = new StreamMuncher(stdout, this.out);
            this.outMuncher.start();
        }
    }
}

