/*
 * Decompiled with CFR 0.152.
 */
package com.semmle.util.process;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;

public abstract class LeakPrevention {
    static final String REPLACEMENT_STRING = "*****";
    public static final LeakPrevention ALL = new LeakPrevention(){

        @Override
        public List<String> cleanUpArguments(List<String> args) {
            return args.isEmpty() ? args : Collections.singletonList(args.get(0));
        }
    };
    public static final LeakPrevention NONE = new LeakPrevention(){

        @Override
        public List<String> cleanUpArguments(List<String> args) {
            return args;
        }
    };

    public abstract List<String> cleanUpArguments(List<String> var1);

    public static LeakPrevention suppressedArguments(int ... args) {
        if (args.length == 0) {
            return NONE;
        }
        final BitSet suppressed = new BitSet();
        for (int index : args) {
            suppressed.set(index);
        }
        return new LeakPrevention(){

            @Override
            public List<String> cleanUpArguments(List<String> args) {
                ArrayList<String> result = new ArrayList<String>(args.size());
                int index = 0;
                for (String arg : args) {
                    if (suppressed.get(index)) {
                        result.add(LeakPrevention.REPLACEMENT_STRING);
                    } else {
                        result.add(arg);
                    }
                    ++index;
                }
                return result;
            }
        };
    }

    public static LeakPrevention suppressSubstring(final String substringToSuppress) {
        return new LeakPrevention(){

            @Override
            public List<String> cleanUpArguments(List<String> args) {
                ArrayList<String> result = new ArrayList<String>(args.size());
                for (String arg : args) {
                    result.add(arg.replace(substringToSuppress, LeakPrevention.REPLACEMENT_STRING));
                }
                return result;
            }
        };
    }
}

