/*
 * Decompiled with CFR 0.152.
 */
package com.semmle.util.xml;

public class XmlEscape {
    private static final char NUL = '\u0000';
    private static final char SOH = '\u0001';
    private static final char STX = '\u0002';
    private static final char ETX = '\u0003';
    private static final char EOT = '\u0004';
    private static final char ENQ = '\u0005';
    private static final char ACK = '\u0006';
    private static final char BEL = '\u0007';
    private static final char BS = '\b';
    private static final char HT = '\t';
    private static final char LF = '\n';
    private static final char VT = '\u000b';
    private static final char FF = '\f';
    private static final char CR = '\r';
    private static final char SO = '\u000e';
    private static final char SI = '\u000f';
    private static final char DLE = '\u0010';
    private static final char DC1 = '\u0011';
    private static final char DC2 = '\u0012';
    private static final char DC3 = '\u0013';
    private static final char DC4 = '\u0014';
    private static final char NAK = '\u0015';
    private static final char SYN = '\u0016';
    private static final char ETB = '\u0017';
    private static final char CAN = '\u0018';
    private static final char EM = '\u0019';
    private static final char SUB = '\u001a';
    private static final char ESC = '\u001b';
    private static final char FS = '\u001c';
    private static final char GS = '\u001d';
    private static final char RS = '\u001e';
    private static final char US = '\u001f';
    private static final char LAST_C0_CHAR = '\u001f';

    public static boolean isIllegalCharacter(char c) {
        return c <= '\u001f' && c != '\t' && c != '\n' && c != '\r';
    }

    public static String getIllegalCharacterRepresentation(char c) {
        switch (c) {
            case '\u0000': {
                return "(NUL)";
            }
            case '\u0001': {
                return "(SOH)";
            }
            case '\u0002': {
                return "(STX)";
            }
            case '\u0003': {
                return "(ETX)";
            }
            case '\u0004': {
                return "(EOT)";
            }
            case '\u0005': {
                return "(ENQ)";
            }
            case '\u0006': {
                return "(ACK)";
            }
            case '\u0007': {
                return "(BEL)";
            }
            case '\b': {
                return "(BS)";
            }
            case '\u000b': {
                return "(VT)";
            }
            case '\f': {
                return "(FF)";
            }
            case '\u000e': {
                return "(SO)";
            }
            case '\u000f': {
                return "(SI)";
            }
            case '\u0010': {
                return "(DLE)";
            }
            case '\u0011': {
                return "(DC1)";
            }
            case '\u0012': {
                return "(DC2)";
            }
            case '\u0013': {
                return "(DC3)";
            }
            case '\u0014': {
                return "(DC4)";
            }
            case '\u0015': {
                return "(NAK)";
            }
            case '\u0016': {
                return "(SYN)";
            }
            case '\u0017': {
                return "(ETB)";
            }
            case '\u0018': {
                return "(CAN)";
            }
            case '\u0019': {
                return "(EM)";
            }
            case '\u001a': {
                return "(SUB)";
            }
            case '\u001b': {
                return "(ESC)";
            }
            case '\u001c': {
                return "(FS)";
            }
            case '\u001d': {
                return "(GS)";
            }
            case '\u001e': {
                return "(RS)";
            }
            case '\u001f': {
                return "(US)";
            }
        }
        return String.valueOf(c);
    }

    public static String removeIllegalControlCharacters(String s) {
        StringBuffer sb = null;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (XmlEscape.isIllegalCharacter(c)) {
                if (sb == null) {
                    sb = new StringBuffer(s.length());
                    sb.append(s, 0, i);
                }
                sb.append(XmlEscape.getIllegalCharacterRepresentation(c));
                continue;
            }
            if (sb == null) continue;
            sb.append(c);
        }
        if (sb == null) {
            return s;
        }
        return sb.toString();
    }

    private static void test(String s) {
        System.out.println(XmlEscape.removeIllegalControlCharacters(s));
    }

    public static void main(String[] args) {
        XmlEscape.test("");
        XmlEscape.test("a");
        XmlEscape.test("ab");
        XmlEscape.test("abc");
        XmlEscape.test("Hello");
        XmlEscape.test("");
        XmlEscape.test("\u0000\u0001\u0002\u0003\u0004\u0005\u0006\u0007\b\u000b\f\u000e\u000f\u0010\u0011\u0012\u0013\u0014\u0015\u0016\u0017\u0018\u0019\u001a\u001b\u001c\u001d\u001e\u001f");
        XmlEscape.test("Valid\u0000\u0001\u0002\u0003\u0004\u0005\u0006\u0007\b\u000b\f\u000e\u000f\u0010\u0011\u0012\u0013\u0014\u0015\u0016\u0017\u0018\u0019\u001a\u001b\u001c\u001d\u001e\u001f");
        XmlEscape.test("Valid\u0000\u0001\u0002\u0003\u0004\u0005\u0006\u0007\b\u000b\f\u000e\u000f\u0010\u0011\u0012\u0013\u0014\u0015\u0016\u0017\u0018\u0019\u001a\u001b\u001c\u001d\u001e\u001fValid");
        XmlEscape.test("Valid\u0000Valid\u0001\u0002\u0003\u0004\u0005\u0006\u0007\b\u000b\f\u000e\u000f\u0010\u0011\u0012\u0013\u0014\u0015\u0016\u0017\u0018\u0019\u001a\u001b\u001c\u001d\u001e\u001fValid");
    }
}

