/*
 * Decompiled with CFR 0.152.
 */
package uk.co.flamingpenguin.jewel.cli;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.logging.Logger;
import uk.co.flamingpenguin.jewel.cli.ArgumentSpecification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ArgumentSpecificationImpl
implements ArgumentSpecification {
    private static final Logger g_logger = Logger.getLogger(ArgumentSpecificationImpl.class.getName());
    private final Class<?> m_type;
    private final Method m_method;
    private final boolean m_multiValued;
    private final String m_baseName;
    private final Method m_optionalityMethod;

    public ArgumentSpecificationImpl(Method method, Class<?> klass) {
        this.m_method = method;
        Class<?> returnType = method.getGenericReturnType();
        this.m_type = this.isList(method.getReturnType()) ? this.getListType(returnType) : returnType;
        this.m_multiValued = this.isList(method.getReturnType());
        this.m_baseName = this.extractBaseMethodName(method);
        this.m_optionalityMethod = this.findCorrespondingOptionalityMethod(this.m_baseName, klass);
    }

    @Override
    public final String getName() {
        return this.m_baseName;
    }

    @Override
    public final Class<?> getType() {
        return this.m_type;
    }

    @Override
    public final boolean isMultiValued() {
        return this.m_multiValued;
    }

    @Override
    public final Method getMethod() {
        return this.m_method;
    }

    @Override
    public boolean isOptional() {
        return this.m_optionalityMethod != null || !this.hasValue();
    }

    @Override
    public Method getOptionalityMethod() {
        return this.m_optionalityMethod;
    }

    public boolean hasValue() {
        return !this.isBoolean(this.getType());
    }

    private final boolean isList(Class<?> klass) {
        return klass.isAssignableFrom(List.class);
    }

    private final Class<?> getListType(Type genericReturnType) {
        if (genericReturnType instanceof ParameterizedType) {
            return (Class)((ParameterizedType)genericReturnType).getActualTypeArguments()[0];
        }
        g_logger.finer("Found raw List type; assuming List<String>.");
        return String.class;
    }

    private final Method findCorrespondingOptionalityMethod(String name, Class<?> klass) {
        try {
            Method method = klass.getMethod(this.addPrefix("is", name), new Class[0]);
            if (this.isBoolean(method.getReturnType())) {
                return method;
            }
            return null;
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    private final boolean isBoolean(Class<?> type) {
        return type.isAssignableFrom(Boolean.class) || type.isAssignableFrom(Boolean.TYPE);
    }

    private final String stripPrefix(String methodName, String prefix) {
        if (methodName.length() > prefix.length() && methodName.startsWith(prefix)) {
            return methodName.substring(prefix.length(), prefix.length() + 1).toLowerCase() + (methodName.length() > prefix.length() + 1 ? methodName.substring(prefix.length() + 1) : "");
        }
        return methodName;
    }

    private String addPrefix(String prefix, String name) {
        return prefix + name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    private String extractBaseMethodName(Method method) {
        String methodName = method.getName();
        String isPrefix = "is";
        if (this.isBoolean(method.getReturnType()) && methodName.startsWith("is")) {
            return this.stripPrefix(methodName, "is");
        }
        return this.stripPrefix(methodName, "get");
    }
}

