/*
 * Decompiled with CFR 0.152.
 */
package uk.co.flamingpenguin.jewel.cli;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import uk.co.flamingpenguin.jewel.JewelException;
import uk.co.flamingpenguin.jewel.cli.ArgumentSpecification;
import uk.co.flamingpenguin.jewel.cli.HelpValidationErrorImpl;
import uk.co.flamingpenguin.jewel.cli.OptionsSpecification;
import uk.co.flamingpenguin.jewel.cli.UnexpectedOptionSpecification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArgumentValidationException
extends JewelException {
    private static final long serialVersionUID = -4781861924515211053L;
    private static final ResourceBundle m_messages = ResourceBundle.getBundle("uk.co.flamingpenguin.jewel.cli.Messages", Locale.getDefault());
    private final ArrayList<ValidationError> m_validationErrors;
    private final String m_message;

    public ArgumentValidationException(ValidationError validationError) {
        this(Arrays.asList(validationError));
    }

    public ArgumentValidationException(List<ValidationError> validationErrors) {
        this.m_validationErrors = new ArrayList<ValidationError>(validationErrors);
        StringBuilder message = new StringBuilder();
        String separator = "";
        for (ValidationError error : validationErrors) {
            message.append(separator).append(error.toString());
            separator = System.getProperty("line.separator");
        }
        this.m_message = message.toString();
    }

    public ArrayList<ValidationError> getValidationErrors() {
        return this.m_validationErrors;
    }

    @Override
    public String getMessage() {
        return this.m_message;
    }

    static ValidationError createUnexpectedOptionError(String name) {
        return new ValidationErrorImpl(ValidationError.ErrorType.UnexpectedOption, new UnexpectedOptionSpecification(name));
    }

    static ValidationError createAdditionalValuesError(ArgumentSpecification optionSpecification) {
        return new ValidationErrorImpl(ValidationError.ErrorType.AdditionalValue, optionSpecification);
    }

    static ValidationError createMissingValueError(ArgumentSpecification optionSpecification) {
        return new ValidationErrorImpl(ValidationError.ErrorType.MissingValue, optionSpecification);
    }

    static ValidationError createUnexpectedValueError(ArgumentSpecification optionSpecification) {
        return new ValidationErrorImpl(ValidationError.ErrorType.UnexpectedValue, optionSpecification);
    }

    static ValidationError createMissingOptionError(ArgumentSpecification optionSpecification) {
        return new ValidationErrorImpl(ValidationError.ErrorType.MissingOption, optionSpecification);
    }

    static ValidationError createInvalidValueForType(ArgumentSpecification optionSpecification, String message) {
        return new ValidationErrorImpl(ValidationError.ErrorType.InvalidValueForType, optionSpecification, message);
    }

    static ValidationError createUnableToConstructType(ArgumentSpecification optionSpecification, String message) {
        return new ValidationErrorImpl(ValidationError.ErrorType.UnableToConstructType, optionSpecification, message);
    }

    static ValidationError createPatternMismatch(ArgumentSpecification optionSpecification, String message) {
        return new ValidationErrorImpl(ValidationError.ErrorType.PatternMismatch, optionSpecification, message);
    }

    static ValidationError createhelpRequested(OptionsSpecification<?> specification) {
        return new HelpValidationErrorImpl(specification);
    }

    private static class ValidationErrorImpl
    implements ValidationError {
        private final ValidationError.ErrorType m_errorType;
        private final ArgumentSpecification m_specification;
        private final String m_message;

        public ValidationErrorImpl(ValidationError.ErrorType errorType, ArgumentSpecification specification) {
            this(errorType, specification, "");
        }

        public ValidationErrorImpl(ValidationError.ErrorType errorType, ArgumentSpecification specification, String message) {
            this.m_errorType = errorType;
            this.m_specification = specification;
            this.m_message = message;
        }

        public ValidationError.ErrorType getErrorType() {
            return this.m_errorType;
        }

        public ArgumentSpecification getSpecification() {
            return this.m_specification;
        }

        public String toString() {
            return String.format("%s: %s", this.getErrorType().getDescription(this), this.getSpecification());
        }

        public String getMessage() {
            return this.m_message;
        }
    }

    public static interface ValidationError {
        public String getMessage();

        public ErrorType getErrorType();

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum ErrorType {
            UnexpectedOption{

                public String getDescription(ValidationError error) {
                    return m_messages.getString("validationError.UnexpectedOption");
                }
            }
            ,
            MissingValue{

                public String getDescription(ValidationError error) {
                    return m_messages.getString("validationError.MissingValue");
                }
            }
            ,
            MisplacedOption{

                public String getDescription(ValidationError error) {
                    return String.format(m_messages.getString("validationError.MisplacedOption"), error.getMessage());
                }
            }
            ,
            UnexpectedValue{

                public String getDescription(ValidationError error) {
                    return m_messages.getString("validationError.UnexpectedValue");
                }
            }
            ,
            AdditionalValue{

                public String getDescription(ValidationError error) {
                    return m_messages.getString("validationError.AdditionalValue");
                }
            }
            ,
            MissingOption{

                public String getDescription(ValidationError error) {
                    return m_messages.getString("validationError.MissingOption");
                }
            }
            ,
            InvalidValueForType{

                public String getDescription(ValidationError error) {
                    return String.format(m_messages.getString("validationError.InvalidValueForType"), error.getMessage());
                }
            }
            ,
            UnableToConstructType{

                public String getDescription(ValidationError error) {
                    return String.format(m_messages.getString("validationError.UnableToConstructType"), error.getMessage());
                }
            }
            ,
            PatternMismatch{

                public String getDescription(ValidationError error) {
                    return String.format(m_messages.getString("validationError.PatternMismatch"), error.getMessage());
                }
            }
            ,
            HelpRequested{

                public String getDescription(ValidationError error) {
                    return error.getMessage();
                }
            };


            public abstract String getDescription(ValidationError var1);
        }
    }
}

