/*
 * Decompiled with CFR 0.152.
 */
package uk.co.flamingpenguin.jewel.cli;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import uk.co.flamingpenguin.jewel.cli.ArgumentSpecification;
import uk.co.flamingpenguin.jewel.cli.ArgumentValidationException;
import uk.co.flamingpenguin.jewel.cli.ArgumentValidator;
import uk.co.flamingpenguin.jewel.cli.ArgumentsImpl;
import uk.co.flamingpenguin.jewel.cli.OptionSpecification;
import uk.co.flamingpenguin.jewel.cli.OptionsSpecification;
import uk.co.flamingpenguin.jewel.cli.ParsedArguments;
import uk.co.flamingpenguin.jewel.cli.ValidatedArguments;
import uk.co.flamingpenguin.jewel.cli.ValidationErrorBuilder;
import uk.co.flamingpenguin.jewel.cli.ValidationErrorBuilderImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ArgumentValidatorImpl<O>
implements ArgumentValidator<O> {
    private final ValidationErrorBuilder m_validationErrorBuilder;
    private final List<String> m_validatedUnparsedArguments;
    private final Map<String, List<String>> m_validatedArguments;
    private final OptionsSpecification<O> m_specification;

    public ArgumentValidatorImpl(OptionsSpecification<O> specification) {
        this.m_specification = specification;
        this.m_validatedArguments = new LinkedHashMap<String, List<String>>();
        this.m_validatedUnparsedArguments = new ArrayList<String>();
        this.m_validationErrorBuilder = new ValidationErrorBuilderImpl();
    }

    @Override
    public ValidatedArguments validateArguments(ParsedArguments arguments) throws ArgumentValidationException {
        this.m_validatedUnparsedArguments.addAll(arguments.getUnparsed());
        Iterator argumentsIterator = arguments.iterator();
        while (argumentsIterator.hasNext()) {
            boolean isLast;
            Map.Entry entry = (Map.Entry)argumentsIterator.next();
            boolean bl = isLast = !argumentsIterator.hasNext();
            if (!this.m_specification.isSpecified((String)entry.getKey())) {
                this.m_validationErrorBuilder.unexpectedOption((String)entry.getKey());
                continue;
            }
            OptionSpecification optionSpecification = this.m_specification.getSpecification((String)entry.getKey());
            if (optionSpecification.isHelpOption()) {
                this.m_validationErrorBuilder.helpRequested(this.m_specification);
            } else if (((List)entry.getValue()).size() == 0 && optionSpecification.hasValue() && !optionSpecification.isMultiValued()) {
                this.m_validationErrorBuilder.missingValue(optionSpecification);
            } else if (!isLast && ((List)entry.getValue()).size() > 0 && !optionSpecification.hasValue()) {
                this.m_validationErrorBuilder.unexpectedValue(optionSpecification);
            } else if (!isLast && ((List)entry.getValue()).size() > 1 && !optionSpecification.isMultiValued()) {
                this.m_validationErrorBuilder.unexpectedAdditionalValues(optionSpecification);
            }
            if (isLast && this.hasExcessValues(entry, optionSpecification)) {
                ArrayList unparsed;
                ArrayList values = new ArrayList();
                if (optionSpecification.hasValue()) {
                    values.add(((List)entry.getValue()).get(0));
                    unparsed = new ArrayList(((List)entry.getValue()).subList(1, ((List)entry.getValue()).size()));
                } else {
                    unparsed = (ArrayList)entry.getValue();
                }
                this.m_validatedArguments.put((String)entry.getKey(), values);
                this.m_validatedUnparsedArguments.addAll(0, unparsed);
                continue;
            }
            this.checkAndAddValues(optionSpecification, (String)entry.getKey(), new ArrayList<String>((Collection)entry.getValue()));
        }
        for (OptionSpecification optionSpecification : this.m_specification.getMandatoryOptions()) {
            if (arguments.containsAny(optionSpecification.getAllNames())) continue;
            this.m_validationErrorBuilder.missingOption(optionSpecification);
        }
        this.validateUnparsedOptions();
        this.m_validationErrorBuilder.validate();
        return new ArgumentsImpl(this.m_validatedArguments, this.m_validatedUnparsedArguments);
    }

    private void validateUnparsedOptions() {
        ArgumentSpecification argumentSpecification;
        if (this.m_specification.hasUnparsedSpecification() && !(argumentSpecification = this.m_specification.getUnparsedSpecification()).isOptional() && (this.m_validatedUnparsedArguments.isEmpty() || argumentSpecification.isMultiValued() && this.m_validatedArguments.size() == 1)) {
            this.m_validationErrorBuilder.missingValue(argumentSpecification);
        }
    }

    private boolean hasExcessValues(Map.Entry<String, List<String>> entry, OptionSpecification optionSpecification) {
        return !optionSpecification.isMultiValued() && (entry.getValue().size() > 1 || entry.getValue().size() > 0 && !optionSpecification.hasValue());
    }

    private void checkAndAddValues(OptionSpecification optionSpecification, String option, ArrayList<String> values) {
        for (String value : values) {
            if (optionSpecification.patternMatches(value)) continue;
            this.m_validationErrorBuilder.patternMismatch(optionSpecification, value);
        }
        this.m_validatedArguments.put(option, new ArrayList<String>(values));
    }
}

