/*
 * Decompiled with CFR 0.152.
 */
package com.semmle.util.trap.dependencies;

import com.semmle.util.exception.ResourceError;
import com.semmle.util.trap.dependencies.TextFile;
import java.nio.file.Path;
import java.util.AbstractSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;

public class TrapDependencies
extends TextFile {
    static final String TRAP = "TRAP";
    private String trap;

    public TrapDependencies(String string) {
        super("1.2");
        this.trap = string;
    }

    public TrapDependencies(Path path) {
        super(null);
        this.load("TRAP dependencies", path);
        if (this.trap == null) {
            this.parseError(path);
        }
    }

    @Override
    protected Set<String> getSet(final Path path, String string) {
        if (string.equals(TRAP)) {
            return new AbstractSet<String>(){

                @Override
                public Iterator<String> iterator() {
                    return null;
                }

                @Override
                public int size() {
                    return 0;
                }

                @Override
                public boolean add(String string) {
                    if (TrapDependencies.this.trap != null) {
                        TrapDependencies.this.parseError(path);
                    }
                    TrapDependencies.this.trap = string;
                    return true;
                }
            };
        }
        if (string.equals("TRAPS")) {
            return this.traps;
        }
        return null;
    }

    @Override
    protected void parseError(Path path) {
        throw new ResourceError("Corrupt TRAP dependencies: " + path);
    }

    public String trapFile() {
        return this.trap;
    }

    public Set<String> dependencies() {
        return Collections.unmodifiableSet(this.traps);
    }

    public void addDependency(String string) {
        this.traps.add(string);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendHeaderString(stringBuilder, "TRAP dependencies", "1.2");
        this.appendSingleton(stringBuilder, TRAP, this.trap);
        this.appendSet(stringBuilder, "TRAPS", this.traps);
        return stringBuilder.toString();
    }
}

