/*
 * Decompiled with CFR 0.152.
 */
package com.github.codeql;

import com.github.codeql.ClassNamesKt;
import com.github.codeql.utils.JvmNamesKt;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.jvm.JavaToKotlinClassMap;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.load.java.sources.JavaSourceElement;
import org.jetbrains.kotlin.load.java.structure.JavaElement;
import org.jetbrains.kotlin.load.java.structure.impl.classFiles.BinaryJavaClass;
import org.jetbrains.kotlin.load.kotlin.JvmPackagePartSource;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinaryClass;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinarySourceElement;
import org.jetbrains.kotlin.load.kotlin.VirtualFileKotlinClass;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNameUnsafe;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0001\u001a\u0010\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\t\u001a\u00020\u0001\u001a\u000e\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e\u001a\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0001\u001a\u0010\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u001a\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00052\u0006\u0010\t\u001a\u00020\u0001H\u0002\u00a8\u0006\u0016"}, d2={"getContainingClassOrSelf", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "decl", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "getFileClassName", "", "f", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "getIrClassBinaryPath", "irClass", "getIrClassVirtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "getIrElementBinaryName", "that", "Lorg/jetbrains/kotlin/ir/IrElement;", "getJavaEquivalentClassId", "Lorg/jetbrains/kotlin/name/ClassId;", "c", "getName", "d", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationWithName;", "getRawIrClassBinaryPath", "codeql-kotlin-extractor"})
@SourceDebugExtension(value={"SMAP\nClassNames.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClassNames.kt\ncom/github/codeql/ClassNamesKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,123:1\n1#2:124\n1290#3,2:125\n*S KotlinDebug\n*F\n+ 1 ClassNames.kt\ncom/github/codeql/ClassNamesKt\n*L\n58#1:125,2\n*E\n"})
public final class ClassNamesKt {
    private static final String getName(IrDeclarationWithName d) {
        Object object;
        block3: {
            block2: {
                IrAnnotationContainer irAnnotationContainer;
                object = d instanceof IrAnnotationContainer ? (IrAnnotationContainer)d : null;
                if (object == null) break block2;
                IrAnnotationContainer it = irAnnotationContainer = object;
                boolean bl = false;
                String string = JvmNamesKt.getJvmName(it);
                object = string;
                if (string != null) break block3;
            }
            String string = d.getName().asString();
            object = string;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"d.name.asString()");
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String getFileClassName(@NotNull IrFile f) {
        Intrinsics.checkNotNullParameter((Object)f, (String)"f");
        String string = JvmNamesKt.getJvmName((IrAnnotationContainer)f);
        if (string == null) {
            CharSequence charSequence;
            StringBuilder stringBuilder = new StringBuilder();
            CharSequence charSequence2 = f.getFileEntry().getName();
            Object object = new Regex(".*[/\\\\]");
            String string2 = "";
            charSequence2 = object.replaceFirst(charSequence2, string2);
            object = new Regex("\\.kt$");
            string2 = "";
            if ((object = (charSequence2 = object.replaceFirst(charSequence2, string2))).length() > 0) {
                void it;
                String string3;
                char c = ((String)charSequence2).charAt(0);
                StringBuilder stringBuilder2 = new StringBuilder();
                StringBuilder stringBuilder3 = stringBuilder;
                boolean bl = false;
                String string4 = string3 = String.valueOf((char)it);
                if (string4 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string5 = string4.toUpperCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.Strin\u2026.toUpperCase(Locale.ROOT)");
                String string6 = string5;
                stringBuilder = stringBuilder3;
                StringBuilder stringBuilder4 = stringBuilder2.append(string6.toString());
                object = charSequence2;
                c = '\u0001';
                Object object2 = object;
                if (object2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string7 = ((String)object2).substring(c);
                Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"(this as java.lang.String).substring(startIndex)");
                charSequence = stringBuilder4.append(string7).toString();
            } else {
                charSequence = charSequence2;
            }
            string = stringBuilder.append((String)charSequence).append("Kt").toString();
        }
        return string;
    }

    @NotNull
    public static final String getIrElementBinaryName(@NotNull IrElement that) {
        IrDeclarationParent parent2;
        Intrinsics.checkNotNullParameter((Object)that, (String)"that");
        if (that instanceof IrFile) {
            String shortName = ClassNamesKt.getFileClassName((IrFile)that);
            String string = ((IrFile)that).getFqName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"that.fqName.asString()");
            String pkg = string;
            return ((CharSequence)pkg).length() == 0 ? shortName : pkg + '.' + shortName;
        }
        if (!(that instanceof IrDeclaration)) {
            return "(unknown-name)";
        }
        String shortName = that instanceof IrDeclarationWithName ? ClassNamesKt.getName((IrDeclarationWithName)that) : "(unknown-name)";
        StringBuilder internalName = new StringBuilder(shortName);
        if (!(that instanceof IrClass) && (parent2 = ((IrDeclaration)that).getParent()) instanceof IrFile) {
            internalName.insert(0, ClassNamesKt.getFileClassName((IrFile)parent2) + '$');
        }
        Sequence $this$forEach$iv = SequencesKt.generateSequence((Object)((IrDeclaration)that).getParent(), (Function1)getIrElementBinaryName.1.INSTANCE);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String string;
            IrDeclarationParent it = (IrDeclarationParent)element$iv;
            boolean bl = false;
            IrDeclarationParent irDeclarationParent = it;
            if (irDeclarationParent instanceof IrClass) {
                internalName.insert(0, ClassNamesKt.getName((IrDeclarationWithName)it) + '$');
                continue;
            }
            if (!(irDeclarationParent instanceof IrPackageFragment)) continue;
            String fqName = string = ((IrPackageFragment)it).getFqName().asString();
            boolean bl2 = false;
            Intrinsics.checkNotNullExpressionValue((Object)fqName, (String)"fqName");
            String string2 = ((CharSequence)fqName).length() > 0 ? string : null;
            if (string2 == null) continue;
            fqName = string = string2;
            boolean bl3 = false;
            internalName.insert(0, fqName + '.');
        }
        String string = internalName.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"internalName.toString()");
        return string;
    }

    @Nullable
    public static final VirtualFile getIrClassVirtualFile(@NotNull IrClass irClass) {
        KotlinJvmBinaryClass binaryClass;
        Intrinsics.checkNotNullParameter((Object)irClass, (String)"irClass");
        SourceElement cSource = irClass.getSource();
        if (Intrinsics.areEqual((Object)irClass.getOrigin(), (Object)IrDeclarationOrigin.JVM_MULTIFILE_CLASS.INSTANCE)) {
            return null;
        }
        SourceElement sourceElement = cSource;
        if (sourceElement instanceof JavaSourceElement) {
            JavaElement element = ((JavaSourceElement)cSource).getJavaElement();
            if (element instanceof BinaryJavaClass) {
                return ((BinaryJavaClass)element).getVirtualFile();
            }
        } else if (sourceElement instanceof KotlinJvmBinarySourceElement) {
            KotlinJvmBinaryClass binaryClass2 = ((KotlinJvmBinarySourceElement)cSource).getBinaryClass();
            if (binaryClass2 instanceof VirtualFileKotlinClass) {
                return ((VirtualFileKotlinClass)binaryClass2).getFile();
            }
        } else if (sourceElement instanceof JvmPackagePartSource && (binaryClass = ((JvmPackagePartSource)cSource).getKnownJvmBinaryClass()) != null && binaryClass instanceof VirtualFileKotlinClass) {
            return ((VirtualFileKotlinClass)binaryClass).getFile();
        }
        return null;
    }

    private static final String getRawIrClassBinaryPath(IrClass irClass) {
        String string;
        VirtualFile virtualFile = ClassNamesKt.getIrClassVirtualFile(irClass);
        if (virtualFile != null) {
            VirtualFile virtualFile2;
            VirtualFile it = virtualFile2 = virtualFile;
            boolean bl = false;
            String string2 = it.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it.path");
            String path = string2;
            if (Intrinsics.areEqual((Object)it.getFileSystem().getProtocol(), (Object)"jrt")) {
                String[] stringArray = new String[]{"!/"};
                string = '/' + (String)StringsKt.split$default((CharSequence)path, (String[])stringArray, (boolean)false, (int)2, (int)2, null).get(1);
            } else {
                string = path;
            }
        } else {
            string = null;
        }
        return string;
    }

    @NotNull
    public static final String getIrClassBinaryPath(@NotNull IrClass irClass) {
        Intrinsics.checkNotNullParameter((Object)irClass, (String)"irClass");
        String string = ClassNamesKt.getRawIrClassBinaryPath(irClass);
        if (string == null) {
            string = "/!unknown-binary-location/" + StringsKt.replace$default((String)ClassNamesKt.getIrElementBinaryName((IrElement)irClass), (String)".", (String)"/", (boolean)false, (int)4, null) + ".class";
        }
        return string;
    }

    @Nullable
    public static final IrClass getContainingClassOrSelf(@NotNull IrDeclaration decl) {
        Intrinsics.checkNotNullParameter((Object)decl, (String)"decl");
        return decl instanceof IrClass ? (IrClass)decl : IrUtilsKt.getParentClassOrNull((IrDeclaration)decl);
    }

    @Nullable
    public static final ClassId getJavaEquivalentClassId(@NotNull IrClass c) {
        ClassId classId2;
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        FqName fqName = IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)((IrDeclarationWithName)c));
        if (fqName != null && (fqName = fqName.toUnsafe()) != null) {
            FqName fqName2;
            FqName it = fqName2 = fqName;
            boolean bl = false;
            classId2 = JavaToKotlinClassMap.INSTANCE.mapKotlinToJava((FqNameUnsafe)it);
        } else {
            classId2 = null;
        }
        return classId2;
    }
}

