/*
 * Decompiled with CFR 0.152.
 */
package com.github.codeql.comments;

import com.github.codeql.DbFile;
import com.github.codeql.DbLocation_default;
import com.github.codeql.DbTop;
import com.github.codeql.FileLogger;
import com.github.codeql.FileTrapWriter;
import com.github.codeql.KotlinExtractorDbSchemeKt;
import com.github.codeql.KotlinFileExtractor;
import com.github.codeql.Label;
import com.github.codeql.TrapWriter;
import com.github.codeql.comments.CommentType;
import com.github.codeql.utils.HelpersKt;
import com.github.codeql.utils.IrVisitorLookup;
import com.github.codeql.utils.versions.Psi2IrFacade;
import com.github.codeql.utils.versions.Psi2IrKt;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.KotlinCompilerVersion;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFileKt;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrTypeAlias;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitor;
import org.jetbrains.kotlin.kdoc.psi.api.KDoc;
import org.jetbrains.kotlin.kdoc.psi.impl.KDocSection;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u0006\u0010\u000e\u001a\u00020\u000fJ\u001c\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/github/codeql/comments/CommentExtractor;", "", "fileExtractor", "Lcom/github/codeql/KotlinFileExtractor;", "file", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "fileLabel", "Lcom/github/codeql/Label;", "Lcom/github/codeql/DbFile;", "(Lcom/github/codeql/KotlinFileExtractor;Lorg/jetbrains/kotlin/ir/declarations/IrFile;Lcom/github/codeql/Label;)V", "logger", "Lcom/github/codeql/FileLogger;", "tw", "Lcom/github/codeql/FileTrapWriter;", "extract", "", "mkCommentVisitor", "Lorg/jetbrains/kotlin/psi/KtVisitor;", "psi2Ir", "Lcom/github/codeql/utils/versions/Psi2IrFacade;", "codeql-kotlin-extractor"})
public final class CommentExtractor {
    @NotNull
    private final KotlinFileExtractor fileExtractor;
    @NotNull
    private final IrFile file;
    @NotNull
    private final Label<? extends DbFile> fileLabel;
    @NotNull
    private final FileTrapWriter tw;
    @NotNull
    private final FileLogger logger;

    public CommentExtractor(@NotNull KotlinFileExtractor fileExtractor, @NotNull IrFile file, @NotNull Label<? extends DbFile> fileLabel) {
        Intrinsics.checkNotNullParameter((Object)fileExtractor, (String)"fileExtractor");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(fileLabel, (String)"fileLabel");
        this.fileExtractor = fileExtractor;
        this.file = file;
        this.fileLabel = fileLabel;
        this.tw = this.fileExtractor.getTw();
        this.logger = this.fileExtractor.getLogger();
    }

    public final void extract() {
        Psi2IrFacade psi2Ir = Psi2IrKt.getPsi2Ir();
        if (psi2Ir == null) {
            this.logger.warn("Comments will not be extracted as Kotlin version is too old (" + KotlinCompilerVersion.getVersion() + ')');
            return;
        }
        KtFile ktFile = psi2Ir.getKtFile(this.file);
        if (ktFile == null) {
            this.logger.warn("Comments are not being processed in " + IrFileKt.getPath((IrFile)this.file) + '.');
            return;
        }
        KtVisitor<Unit, Unit> commentVisitor = this.mkCommentVisitor(psi2Ir);
        ktFile.accept((PsiElementVisitor)commentVisitor);
    }

    private final KtVisitor<Unit, Unit> mkCommentVisitor(Psi2IrFacade psi2Ir) {
        return (KtVisitor)new KtVisitor<Unit, Unit>(this, psi2Ir){
            final /* synthetic */ CommentExtractor this$0;
            final /* synthetic */ Psi2IrFacade $psi2Ir;
            {
                this.this$0 = $receiver;
                this.$psi2Ir = $psi2Ir;
            }

            public void visitElement(@NotNull PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                element.acceptChildren((PsiElementVisitor)this);
                if (element instanceof PsiComment) {
                    this.visitCommentElement((PsiComment)element);
                }
            }

            private final void visitCommentElement(PsiComment comment) {
                CommentType commentType;
                IElementType iElementType = comment.getTokenType();
                if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.EOL_COMMENT)) {
                    commentType = CommentType.SingleLine;
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.BLOCK_COMMENT)) {
                    commentType = CommentType.Block;
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.DOC_COMMENT)) {
                    commentType = CommentType.Doc;
                } else {
                    CommentExtractor.access$getLogger$p(this.this$0).warn("Unhandled comment token type: " + comment.getTokenType());
                    return;
                }
                CommentType type = commentType;
                Label<T> commentLabel = CommentExtractor.access$getTw$p(this.this$0).getFreshIdLabel();
                TrapWriter trapWriter = CommentExtractor.access$getTw$p(this.this$0);
                int n = type.getValue();
                String string = comment.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"comment.text");
                KotlinExtractorDbSchemeKt.writeKtComments(trapWriter, commentLabel, n, string);
                Label<DbLocation_default> locId = CommentExtractor.access$getTw$p(this.this$0).getLocation(PsiUtilsKt.getStartOffset((PsiElement)((PsiElement)comment)), PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)comment)));
                KotlinExtractorDbSchemeKt.writeHasLocation(CommentExtractor.access$getTw$p(this.this$0), commentLabel, locId);
                if (!Intrinsics.areEqual((Object)comment.getTokenType(), (Object)KtTokens.DOC_COMMENT)) {
                    return;
                }
                if (!(comment instanceof KDoc)) {
                    CommentExtractor.access$getLogger$p(this.this$0).warn("Unexpected comment type with DocComment token type.");
                    return;
                }
                for (KDocSection sec : ((KDoc)comment).getAllSections()) {
                    String subjectName;
                    Label<T> commentSectionLabel = CommentExtractor.access$getTw$p(this.this$0).getFreshIdLabel();
                    KotlinExtractorDbSchemeKt.writeKtCommentSections(CommentExtractor.access$getTw$p(this.this$0), commentSectionLabel, commentLabel, sec.getContent());
                    String name = sec.getName();
                    if (name != null) {
                        KotlinExtractorDbSchemeKt.writeKtCommentSectionNames(CommentExtractor.access$getTw$p(this.this$0), commentSectionLabel, name);
                    }
                    if ((subjectName = sec.getSubjectName()) == null) continue;
                    KotlinExtractorDbSchemeKt.writeKtCommentSectionSubjectNames(CommentExtractor.access$getTw$p(this.this$0), commentSectionLabel, subjectName);
                }
                PsiElement psiElement = this.getKDocOwner((KDoc)comment);
                if (psiElement == null) {
                    return;
                }
                PsiElement ownerPsi = psiElement;
                List owners = new ArrayList<E>();
                CommentExtractor.access$getFile$p(this.this$0).accept((IrElementVisitor)new IrVisitorLookup(this.$psi2Ir, ownerPsi, CommentExtractor.access$getFile$p(this.this$0)), (Object)owners);
                for (IrElement ownerIr : owners) {
                    Label<? extends DbTop> ownerLabel = this.getLabel(ownerIr);
                    if (ownerLabel == null) continue;
                    KotlinExtractorDbSchemeKt.writeKtCommentOwners(CommentExtractor.access$getTw$p(this.this$0), commentLabel, ownerLabel);
                }
            }

            private final PsiElement getKDocOwner(KDoc comment) {
                KtDeclaration owner = comment.getOwner();
                if (owner == null) {
                    CommentExtractor.access$getLogger$p(this.this$0).warn("Couldn't get owner of KDoc. The comment is extracted without an owner.");
                }
                return (PsiElement)owner;
            }

            private final Label<? extends DbTop> getLabel(IrElement element) {
                Label<T> existingLabel;
                Label<Object> label2;
                if (Intrinsics.areEqual((Object)element, (Object)CommentExtractor.access$getFile$p(this.this$0))) {
                    return CommentExtractor.access$getFileLabel$p(this.this$0);
                }
                if (element instanceof IrValueParameter && ((IrValueParameter)element).getIndex() == -1) {
                    return null;
                }
                String label3 = null;
                if (element instanceof IrVariable) {
                    label3 = "variable " + ((IrVariable)element).getName().asString();
                    label2 = CommentExtractor.access$getTw$p(this.this$0).getExistingVariableLabelFor((IrVariable)element);
                } else if (element instanceof IrFunction && HelpersKt.isLocalFunction((IrFunction)element)) {
                    label3 = "local function " + ((IrFunction)element).getName().asString();
                    label2 = CommentExtractor.access$getFileExtractor$p(this.this$0).getExistingLocallyVisibleFunctionLabel((IrFunction)element);
                } else {
                    String string = this.getLabelForNamedElement(element);
                    if (string == null) {
                        return null;
                    }
                    label3 = string;
                    label2 = existingLabel = CommentExtractor.access$getTw$p(this.this$0).getExistingLabelFor(label3);
                }
                if (existingLabel == null) {
                    CommentExtractor.access$getLogger$p(this.this$0).warn("Couldn't get existing label for " + label3);
                    return null;
                }
                return existingLabel;
            }

            private final String getLabelForNamedElement(IrElement element) {
                IrElement irElement = element;
                if (irElement instanceof IrClass) {
                    return CommentExtractor.access$getFileExtractor$p(this.this$0).getClassLabel((IrClass)element, CollectionsKt.emptyList()).getClassLabel();
                }
                if (irElement instanceof IrTypeParameter) {
                    return CommentExtractor.access$getFileExtractor$p(this.this$0).getTypeParameterLabel((IrTypeParameter)element);
                }
                if (irElement instanceof IrFunction) {
                    return HelpersKt.isLocalFunction((IrFunction)element) ? null : CommentExtractor.access$getFileExtractor$p(this.this$0).getFunctionLabel((IrFunction)element, null);
                }
                if (irElement instanceof IrValueParameter) {
                    return CommentExtractor.access$getFileExtractor$p(this.this$0).getValueParameterLabel((IrValueParameter)element, null);
                }
                if (irElement instanceof IrProperty) {
                    return CommentExtractor.access$getFileExtractor$p(this.this$0).getPropertyLabel((IrProperty)element);
                }
                if (irElement instanceof IrField) {
                    return CommentExtractor.access$getFileExtractor$p(this.this$0).getFieldLabel((IrField)element);
                }
                if (irElement instanceof IrEnumEntry) {
                    return CommentExtractor.access$getFileExtractor$p(this.this$0).getEnumEntryLabel((IrEnumEntry)element);
                }
                if (irElement instanceof IrTypeAlias) {
                    return CommentExtractor.access$getFileExtractor$p(this.this$0).getTypeAliasLabel((IrTypeAlias)element);
                }
                if (irElement instanceof IrAnonymousInitializer) {
                    IrClass parentClass = IrUtilsKt.getParentClassOrNull((IrDeclaration)((IrDeclaration)element));
                    if (parentClass == null) {
                        FileLogger.warnElement$default(CommentExtractor.access$getLogger$p(this.this$0), "Parent of anonymous initializer is not a class", element, null, 4, null);
                        return null;
                    }
                    return this.getLabelForNamedElement((IrElement)parentClass);
                }
                if (irElement instanceof IrBody) {
                    return null;
                }
                if (irElement instanceof IrExpression) {
                    return null;
                }
                FileLogger.warnElement$default(CommentExtractor.access$getLogger$p(this.this$0), "Unhandled element type found during comment extraction: " + Reflection.getOrCreateKotlinClass(element.getClass()), element, null, 4, null);
                return null;
            }
        };
    }

    public static final /* synthetic */ FileLogger access$getLogger$p(CommentExtractor $this) {
        return $this.logger;
    }

    public static final /* synthetic */ FileTrapWriter access$getTw$p(CommentExtractor $this) {
        return $this.tw;
    }

    public static final /* synthetic */ IrFile access$getFile$p(CommentExtractor $this) {
        return $this.file;
    }

    public static final /* synthetic */ Label access$getFileLabel$p(CommentExtractor $this) {
        return $this.fileLabel;
    }

    public static final /* synthetic */ KotlinFileExtractor access$getFileExtractor$p(CommentExtractor $this) {
        return $this.fileExtractor;
    }
}

