/*
 * Decompiled with CFR 0.152.
 */
package com.semmle.util.io;

import com.semmle.util.exception.Exceptions;
import com.semmle.util.files.FileUtil;
import com.semmle.util.io.BufferedLineReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;

public class StreamMuncher
extends Thread {
    private final InputStream is;
    private PrintStream output;
    private BufferedLineReader reader;

    public StreamMuncher(InputStream inputStream, OutputStream outputStream) {
        this.is = inputStream;
        if (outputStream != null) {
            this.output = new PrintStream(outputStream);
        }
    }

    @Override
    public void run() {
        InputStreamReader inputStreamReader = null;
        try {
            String string;
            inputStreamReader = new InputStreamReader(this.is);
            this.reader = new BufferedLineReader(inputStreamReader);
            while ((string = this.reader.readLineAndTerminator()) != null) {
                if (this.output == null) continue;
                this.output.print(string);
                this.output.flush();
            }
        }
        catch (IOException iOException) {
            Exceptions.ignore(iOException, "When the process exits, a harmless IOException will occur here");
        }
        finally {
            FileUtil.close(this.reader);
            FileUtil.close(inputStreamReader);
        }
    }
}

