/*
 * Decompiled with CFR 0.152.
 */
package com.semmle.util.concurrent;

import com.github.codeql.Logger;
import com.semmle.util.concurrent.ThreadUtil;
import com.semmle.util.data.StringDigestor;
import com.semmle.util.exception.CatastrophicError;
import com.semmle.util.exception.ResourceError;
import com.semmle.util.files.FileUtil;
import com.semmle.util.io.WholeIO;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.LinkedHashMap;
import java.util.Map;

public class LockDirectory {
    private final Logger logger;
    private final File lockDir;
    private static final Map<File, LockDirectory> instances = new LinkedHashMap<File, LockDirectory>();
    private final Map<String, LockFile> locks = new LinkedHashMap<String, LockFile>();

    public static synchronized LockDirectory instance(File file) {
        return LockDirectory.instance(file, null);
    }

    public static synchronized LockDirectory instance(File file, Logger logger) {
        try {
            FileUtil.mkdirs(file);
        }
        catch (ResourceError resourceError) {
            throw new ResourceError("Couldn't ensure lock directory " + file + " exists.", resourceError);
        }
        try {
            file = file.getCanonicalFile();
        }
        catch (IOException iOException) {
            throw new ResourceError("Couldn't canonicalise requested lock directory " + file, iOException);
        }
        LockDirectory lockDirectory = instances.get(file);
        if (lockDirectory == null) {
            lockDirectory = new LockDirectory(file, logger);
            instances.put(file, lockDirectory);
        }
        return lockDirectory;
    }

    private LockDirectory(File file, Logger logger) {
        this.lockDir = file;
        this.logger = logger;
    }

    public synchronized void lock(LockingMode lockingMode, File file, String string) {
        if (lockingMode == LockingMode.None) {
            return;
        }
        LockFile lockFile = new LockFile(file);
        if (this.locks.containsKey(lockFile.getLockedPath())) {
            throw new CatastrophicError("Trying to lock already locked path " + lockFile.getLockedPath() + ".");
        }
        lockFile.lock(lockingMode, string);
        this.locks.put(lockFile.getLockedPath(), lockFile);
    }

    public synchronized void blockingLock(LockingMode lockingMode, File file, String string) {
        if (lockingMode == LockingMode.None) {
            return;
        }
        LockFile lockFile = new LockFile(file);
        if (this.locks.containsKey(lockFile.getLockedPath())) {
            throw new CatastrophicError("Trying to lock already locked path " + lockFile.getLockedPath() + ".");
        }
        lockFile.blockingLock(lockingMode, string);
        this.locks.put(lockFile.getLockedPath(), lockFile);
    }

    public synchronized void unlock(LockingMode lockingMode, File file) {
        if (!this.maybeUnlock(lockingMode, file)) {
            throw new CatastrophicError("Trying to unlock " + new LockFile(file).getLockedPath() + ", but it is not locked.");
        }
    }

    public synchronized boolean maybeUnlock(LockingMode lockingMode, File file) {
        if (lockingMode == LockingMode.None) {
            return true;
        }
        LockFile lockFile = new LockFile(file);
        LockFile lockFile2 = this.locks.get(lockFile.getLockedPath());
        if (lockFile2 == null) {
            return false;
        }
        this.locks.remove(lockFile.getLockedPath());
        lockFile2.unlock(lockingMode);
        return true;
    }

    public File getDir() {
        return this.lockDir;
    }

    public static enum LockingMode {
        Shared(true),
        Exclusive(false),
        None(true);

        private boolean shared;

        private LockingMode(boolean bl) {
            this.shared = bl;
        }

        public boolean isShared() {
            return this.shared;
        }
    }

    private class LockFile {
        private final String lockedPath;
        private final File lockFile;
        private final File statusFile;
        private LockingMode mode = null;
        private RandomAccessFile lockStream = null;
        private FileChannel lockChannel = null;
        private FileLock lock = null;

        public LockFile(File file) {
            try {
                this.lockedPath = file.getCanonicalPath();
            }
            catch (IOException iOException) {
                throw new ResourceError("Failed to canonicalise path for locking: " + file, iOException);
            }
            String string = StringDigestor.digest(this.lockedPath);
            this.lockFile = new File(LockDirectory.this.lockDir, string);
            this.statusFile = new File(LockDirectory.this.lockDir, string + ".log");
        }

        public String getLockedPath() {
            return this.lockedPath;
        }

        public void lock(LockingMode lockingMode, String string) {
            if (lockingMode == LockingMode.None) {
                return;
            }
            if (this.lock != null) {
                throw new CatastrophicError("Trying to re-lock existing lock for " + this.lockedPath);
            }
            this.mode = lockingMode;
            try {
                this.lockStream = new RandomAccessFile(this.lockFile, "rw");
                this.lockChannel = this.lockStream.getChannel();
                this.tryLock(lockingMode);
                new WholeIO().strictwrite(this.statusFile, (Object)((Object)lockingMode) + " lock acquired for " + this.lockedPath + ": " + string);
            }
            catch (IOException iOException) {
                throw new ResourceError("Failed to obtain lock for " + this.lockedPath + " at " + this.lockFile, iOException);
            }
        }

        public void blockingLock(LockingMode lockingMode, String string) {
            if (lockingMode == LockingMode.None) {
                return;
            }
            if (this.lock != null) {
                throw new CatastrophicError("Trying to re-lock existing lock for " + this.lockedPath);
            }
            this.mode = lockingMode;
            try {
                this.lockStream = new RandomAccessFile(this.lockFile, "rw");
                this.lockChannel = this.lockStream.getChannel();
                this.lock = this.lockChannel.tryLock(0L, Long.MAX_VALUE, lockingMode.isShared());
                while (this.lock == null) {
                    ThreadUtil.sleep(500L, true);
                    this.lock = this.lockChannel.tryLock(0L, Long.MAX_VALUE, lockingMode.isShared());
                }
                new WholeIO().strictwrite(this.statusFile, (Object)((Object)lockingMode) + " lock acquired for " + this.lockedPath + ": " + string);
            }
            catch (IOException iOException) {
                throw new ResourceError("Failed to obtain lock for " + this.lockedPath + " at " + this.lockFile, iOException);
            }
        }

        private void tryLock(LockingMode lockingMode) throws IOException {
            this.lock = this.lockChannel.tryLock(0L, Long.MAX_VALUE, lockingMode.isShared());
            if (this.lock == null) {
                String string = new WholeIO().read(this.statusFile);
                throw new ResourceError("Failed to acquire " + (Object)((Object)lockingMode) + " lock for " + this.lockedPath + "." + (string == null ? "" : "\nExisting lock message: " + string));
            }
        }

        public void unlock(LockingMode lockingMode) {
            if (lockingMode == LockingMode.None) {
                return;
            }
            if (lockingMode != this.mode) {
                throw new CatastrophicError("Attempting to unlock " + this.lockedPath + " with incompatible mode: " + (Object)((Object)this.mode) + " lock was obtained, but " + (Object)((Object)lockingMode) + " lock is being released.");
            }
            this.release(lockingMode);
        }

        private void release(LockingMode lockingMode) {
            block10: {
                try {
                    if (this.lock == null) break block10;
                    try {
                        try {
                            if (this.statusFile.exists() && !this.statusFile.delete() && !lockingMode.isShared()) {
                                throw new ResourceError("Could not clear status file " + this.statusFile);
                            }
                        }
                        finally {
                            this.lock.release();
                            FileUtil.close(this.lockStream);
                            FileUtil.close(this.lockChannel);
                            if (!this.lockFile.delete()) {
                                LockDirectory.this.logger.error("Could not clear lock file " + this.lockFile + " (it might have been locked by another process).");
                            }
                        }
                    }
                    catch (IOException iOException) {
                        throw new ResourceError("Couldn't release lock for " + this.lockedPath, iOException);
                    }
                }
                finally {
                    lockingMode = null;
                    this.lockStream = null;
                    this.lockChannel = null;
                    this.lock = null;
                }
            }
        }
    }
}

