/*
 * Decompiled with CFR 0.152.
 */
package com.semmle.util.data;

import com.semmle.util.data.StringUtil;
import com.semmle.util.exception.CatastrophicError;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class StringDigestor {
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private static final String NULL_STRING = "<null>";
    private static final int CHUNK_SIZE = 32;
    private MessageDigest digest;
    private byte[] digestBytes;
    private final byte[] buf = new byte[96];

    public StringDigestor() {
        this("SHA-1");
    }

    public StringDigestor(String string) {
        try {
            this.digest = MessageDigest.getInstance(string);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CatastrophicError("StringDigestor failed to find the required digest algorithm: " + string, noSuchAlgorithmException);
        }
    }

    public void reset() {
        if (this.digestBytes == null) {
            throw new CatastrophicError("API violation: Digestor is not finished.");
        }
        this.digest.reset();
        this.digestBytes = null;
    }

    public StringDigestor write(Object object) {
        String string = object == null ? NULL_STRING : object.toString();
        this.writeBinaryInt(string.length());
        this.writeNoLength(string);
        return this;
    }

    public StringDigestor writeNoLength(Object object) {
        String string = object.toString();
        int n = string.length();
        int n2 = 0;
        while (n2 + 32 < n) {
            n2 = this.writeUTF8(string, n2, n2 + 32);
        }
        this.writeUTF8(string, n2, n);
        return this;
    }

    private int writeUTF8(String string, int n, int n2) {
        if (this.digestBytes != null) {
            throw new CatastrophicError("API violation: Digestor is finished.");
        }
        byte[] byArray = this.buf;
        int n3 = 0;
        for (int i = n; i < n2; ++i) {
            int n4 = string.charAt(i);
            if (n4 <= 127) {
                byArray[n3++] = (byte)n4;
                continue;
            }
            if (n4 <= 2047) {
                byArray[n3] = (byte)(0xC0 | n4 >> 6);
                byArray[n3 + 1] = (byte)(0x80 | n4 & 0x3F);
                n3 += 2;
                continue;
            }
            if (n4 < 55296 || n4 > 57343) {
                byArray[n3] = (byte)(0xE0 | n4 >> 12);
                byArray[n3 + 1] = (byte)(0x80 | n4 >> 6 & 0x3F);
                byArray[n3 + 2] = (byte)(0x80 | n4 & 0x3F);
                n3 += 3;
                continue;
            }
            if (i + 1 < n2) {
                char c = string.charAt(i + 1);
                if (n4 > 56319 || c < '\udc00' || c > '\udfff') continue;
                n4 = 65536 + (n4 - 55296 << 10) + (c - 56320);
                byArray[n3] = (byte)(0xF0 | n4 >> 18);
                byArray[n3 + 1] = (byte)(0x80 | n4 >> 12 & 0x3F);
                byArray[n3 + 2] = (byte)(0x80 | n4 >> 6 & 0x3F);
                byArray[n3 + 3] = (byte)(0x80 | n4 & 0x3F);
                n3 += 4;
                ++i;
                continue;
            }
            --n2;
            break;
        }
        this.digest.update(byArray, 0, n3);
        return n2;
    }

    public StringDigestor writeBytes(byte[] byArray) {
        if (this.digestBytes != null) {
            throw new CatastrophicError("API violation: Digestor is finished.");
        }
        this.digest.update(byArray);
        return this;
    }

    public String getDigest() {
        if (this.digestBytes == null) {
            this.digestBytes = this.digest.digest();
        }
        return StringUtil.toHex(this.digestBytes);
    }

    public static String digest(Object object) {
        StringDigestor stringDigestor = new StringDigestor();
        stringDigestor.writeNoLength(object);
        return stringDigestor.getDigest();
    }

    public static String gitBlobSha(String string) {
        byte[] byArray = string.getBytes(UTF8);
        return StringDigestor.digest("blob " + byArray.length + "\u0000" + string);
    }

    public StringDigestor writeBinaryInt(int n) {
        if (this.digestBytes != null) {
            throw new CatastrophicError("API violation: Digestor is finished.");
        }
        byte[] byArray = this.buf;
        byArray[0] = (byte)(n & 0xFF);
        byArray[1] = (byte)(n >>> 8 & 0xFF);
        byArray[2] = (byte)(n >>> 16 & 0xFF);
        byArray[3] = (byte)(n >>> 24 & 0xFF);
        this.digest.update(byArray, 0, 4);
        return this;
    }
}

