/*
 * Decompiled with CFR 0.152.
 */
package com.semmle.util.io;

import com.semmle.util.data.IntRef;
import com.semmle.util.exception.ResourceError;
import com.semmle.util.files.FileUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.regex.Pattern;

public class WholeIO {
    private IOException e;
    private static final Pattern rpLineEndingCRLF = Pattern.compile("\r\n");
    private final String defaultEncoding;

    public WholeIO() {
        this("UTF-8");
    }

    public WholeIO(String string) {
        this.defaultEncoding = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readAndTrim(File file) {
        String string;
        this.e = null;
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            String string2 = this.readString(fileInputStream);
            string = string2 == null ? null : string2.trim();
        }
        catch (IOException iOException) {
            String string3;
            try {
                this.e = iOException;
                string3 = null;
            }
            catch (Throwable throwable) {
                FileUtil.close(fileInputStream);
                throw throwable;
            }
            FileUtil.close(fileInputStream);
            return string3;
        }
        FileUtil.close(fileInputStream);
        return string;
    }

    public boolean write(String string, String string2) {
        return this.write(new File(string), string2);
    }

    public boolean write(File file, String string) {
        return this.write(file, string, false);
    }

    public boolean write(Path path, String string) {
        return this.write(path, string, false);
    }

    public void strictwrite(File file, String string) {
        this.strictwrite(file, string, false);
    }

    public void strictwrite(Path path, String string) {
        this.strictwrite(path, string, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean write(File file, String string, boolean bl) {
        boolean bl2;
        if (file.getParentFile() != null) {
            file.getParentFile().mkdirs();
        }
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file, bl);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, Charset.forName(this.defaultEncoding));
            ((Writer)outputStreamWriter).append(string);
            ((Writer)outputStreamWriter).close();
            bl2 = true;
        }
        catch (IOException iOException) {
            boolean bl3;
            try {
                this.e = iOException;
                bl3 = false;
            }
            catch (Throwable throwable) {
                FileUtil.close(fileOutputStream);
                throw throwable;
            }
            FileUtil.close(fileOutputStream);
            return bl3;
        }
        FileUtil.close(fileOutputStream);
        return bl2;
    }

    public boolean write(Path path, String string, boolean bl) {
        try {
            if (path.getParent() != null) {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
            }
            try (BufferedWriter bufferedWriter = Files.newBufferedWriter(path, Charset.forName(this.defaultEncoding), StandardOpenOption.CREATE, StandardOpenOption.WRITE, bl ? StandardOpenOption.APPEND : StandardOpenOption.TRUNCATE_EXISTING);){
                bufferedWriter.append(string);
            }
        }
        catch (IOException iOException) {
            this.e = iOException;
            return false;
        }
        return true;
    }

    public void strictwrite(File file, String string, boolean bl) {
        if (!this.write(file, string, bl)) {
            throw new ResourceError("Failed to write file " + file, this.getLastException());
        }
    }

    public void strictwrite(Path path, String string, boolean bl) {
        if (!this.write(path, string, bl)) {
            throw new ResourceError("Failed to write path " + path, this.getLastException());
        }
    }

    public IOException getLastException() {
        return this.e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String read(File file) {
        String string;
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            string = this.readString(fileInputStream);
        }
        catch (IOException iOException) {
            String string2;
            try {
                this.e = iOException;
                string2 = null;
            }
            catch (Throwable throwable) {
                FileUtil.close(fileInputStream);
                throw throwable;
            }
            FileUtil.close(fileInputStream);
            return string2;
        }
        FileUtil.close(fileInputStream);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String read(Path path) {
        String string;
        InputStream inputStream = null;
        try {
            inputStream = Files.newInputStream(path, new OpenOption[0]);
            string = this.readString(inputStream);
        }
        catch (IOException iOException) {
            String string2;
            try {
                this.e = iOException;
                string2 = null;
            }
            catch (Throwable throwable) {
                FileUtil.close(inputStream);
                throw throwable;
            }
            FileUtil.close(inputStream);
            return string2;
        }
        FileUtil.close(inputStream);
        return string;
    }

    public String readText(File file) {
        String string = this.read(file);
        return string != null ? string.replaceAll("\r\n", "\n") : null;
    }

    public String readText(Path path) {
        String string = this.read(path);
        return string != null ? string.replaceAll("\r\n", "\n") : null;
    }

    public String strictread(File file) {
        String string = this.read(file);
        if (string == null) {
            throw new ResourceError("Failed to read file " + file, this.getLastException());
        }
        return string;
    }

    public String strictread(Path path) {
        String string = this.read(path);
        if (string == null) {
            throw new ResourceError("Failed to read path " + path, this.getLastException());
        }
        return string;
    }

    public String strictreadText(File file) {
        return rpLineEndingCRLF.matcher(this.strictread(file)).replaceAll("\n");
    }

    public String strictreadText(Path path) {
        return rpLineEndingCRLF.matcher(this.strictread(path)).replaceAll("\n");
    }

    public String readString(InputStream inputStream) {
        IntRef intRef = new IntRef(0);
        byte[] byArray = this.readBinary(inputStream, intRef);
        if (byArray == null) {
            return null;
        }
        try {
            IntRef intRef2 = new IntRef(0);
            String string = this.determineCharset(byArray, intRef.get(), intRef2);
            return new String(byArray, intRef2.get(), intRef.get() - intRef2.get(), string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.e = unsupportedEncodingException;
            return null;
        }
    }

    public String strictReadString(InputStream inputStream) {
        String string = this.readString(inputStream);
        if (string == null) {
            throw new ResourceError("Could not read from stream", this.getLastException());
        }
        return string;
    }

    public byte[] readBinary(InputStream inputStream) {
        IntRef intRef = new IntRef(0);
        byte[] byArray = this.readBinary(inputStream, intRef);
        return byArray == null ? null : Arrays.copyOf(byArray, intRef.get());
    }

    public byte[] strictReadBinary(InputStream inputStream) {
        byte[] byArray = this.readBinary(inputStream);
        if (byArray == null) {
            throw new ResourceError("Couldn't read from stream", this.e);
        }
        return byArray;
    }

    public byte[] strictReadBinary(File file) {
        byte[] byArray;
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            byte[] byArray2 = this.readBinary(fileInputStream);
            if (byArray2 == null) {
                throw new ResourceError("Couldn't read from file " + file + ".", this.e);
            }
            byArray = byArray2;
        }
        catch (FileNotFoundException fileNotFoundException) {
            try {
                throw new ResourceError("Couldn't read from file " + file + ".", fileNotFoundException);
            }
            catch (Throwable throwable) {
                FileUtil.close(fileInputStream);
                throw throwable;
            }
        }
        FileUtil.close(fileInputStream);
        return byArray;
    }

    public byte[] strictReadBinary(Path path) {
        byte[] byArray;
        InputStream inputStream = null;
        try {
            inputStream = Files.newInputStream(path, new OpenOption[0]);
            byte[] byArray2 = this.readBinary(inputStream);
            if (byArray2 == null) {
                throw new ResourceError("Couldn't read from path " + path + ".", this.e);
            }
            byArray = byArray2;
        }
        catch (IOException iOException) {
            try {
                throw new ResourceError("Couldn't read from path " + path + ".", iOException);
            }
            catch (Throwable throwable) {
                FileUtil.close(inputStream);
                throw throwable;
            }
        }
        FileUtil.close(inputStream);
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] readBinary(Path path) throws IOException {
        byte[] byArray;
        InputStream inputStream = null;
        try {
            inputStream = Files.newInputStream(path, new OpenOption[0]);
            byte[] byArray2 = this.readBinary(inputStream);
            if (byArray2 == null) {
                throw new ResourceError("Couldn't read from path " + path + ".", this.e);
            }
            byArray = byArray2;
        }
        catch (Throwable throwable) {
            FileUtil.close(inputStream);
            throw throwable;
        }
        FileUtil.close(inputStream);
        return byArray;
    }

    private byte[] readBinary(InputStream inputStream, IntRef intRef) {
        try {
            int n;
            byte[] byArray = new byte[16384];
            int n2 = 0;
            do {
                if ((n = inputStream.read(byArray, n2, byArray.length - n2)) <= 0 || (n2 += n) != byArray.length) continue;
                byArray = this.safeArrayDouble(byArray);
            } while (n > 0);
            intRef.set(n2);
            return byArray;
        }
        catch (IOException iOException) {
            this.e = iOException;
            return null;
        }
    }

    private byte[] safeArrayDouble(byte[] byArray) {
        if (byArray.length >= 0x7FFFFFF7) {
            throw new ResourceError("Cannot stream into array as it exceed the maximum array size");
        }
        long l = (long)byArray.length * 2L;
        if (l < 16L) {
            l = 16L;
        }
        if (l > 0x7FFFFFF7L) {
            l = 0x7FFFFFF7L;
        }
        return Arrays.copyOf(byArray, (int)l);
    }

    private String determineCharset(byte[] byArray, int n, IntRef intRef) {
        intRef.set(0);
        String string = this.defaultEncoding;
        if (n < 2) {
            return string;
        }
        if (n >= 3 && WholeIO.byteToInt(byArray[0]) == 239 && WholeIO.byteToInt(byArray[1]) == 187 && WholeIO.byteToInt(byArray[2]) == 191) {
            string = "UTF-8";
            intRef.set(3);
        } else if (WholeIO.byteToInt(byArray[0]) == 254 && WholeIO.byteToInt(byArray[1]) == 255) {
            string = "UTF-16BE";
            intRef.set(2);
        } else if (WholeIO.byteToInt(byArray[0]) == 255 && WholeIO.byteToInt(byArray[1]) == 254) {
            string = "UTF-16LE";
            intRef.set(2);
        }
        return string;
    }

    private static int byteToInt(byte by) {
        return by & 0xFF;
    }
}

