/*
 * Decompiled with CFR 0.152.
 */
package com.semmle.util.process;

import com.github.codeql.Logger;
import com.semmle.util.data.StringUtil;
import com.semmle.util.exception.CatastrophicError;
import com.semmle.util.exception.Exceptions;
import com.semmle.util.exception.InterruptedError;
import com.semmle.util.exception.ResourceError;
import com.semmle.util.files.FileUtil;
import com.semmle.util.io.RawStreamMuncher;
import com.semmle.util.process.Env;
import com.semmle.util.process.LeakPrevention;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;

public abstract class AbstractProcessBuilder {
    public static Logger logger = null;
    protected static final long MUNCH_TIMEOUT = 20L;
    private final ProcessBuilder builder;
    private boolean logFailure = true;
    private InputStream in;
    private LeakPrevention leakPrevention;
    private volatile boolean interrupted = false;
    private volatile Thread threadToInterrupt = null;
    private volatile boolean hitTimeout = false;
    private final Map<String, String> canonicalEnvVarNames = new LinkedHashMap<String, String>();
    private RawStreamMuncher inMuncher;

    public AbstractProcessBuilder(List<String> list, File file, Map<String, String> map) {
        CatastrophicError.throwIfNull(list);
        for (int i = 0; i < list.size(); ++i) {
            CatastrophicError.throwIfNull(list.get(i));
        }
        this.leakPrevention = LeakPrevention.NONE;
        this.builder = new ProcessBuilder(new ArrayList<String>(list));
        if (file != null) {
            this.builder.directory(file);
        }
        Map<String, String> map2 = Env.systemEnv().getenv();
        Iterator<String> iterator = this.builder.environment().keySet().iterator();
        while (iterator.hasNext()) {
            String string = iterator.next();
            if (map2.containsKey(string)) continue;
            iterator.remove();
        }
        if (map != null) {
            this.addEnvironment(map);
        }
    }

    public void setLeakPrevention(LeakPrevention leakPrevention) {
        CatastrophicError.throwIfNull(leakPrevention);
        this.leakPrevention = leakPrevention;
    }

    public void setRedirectErrorStream(boolean bl) {
        this.builder.redirectErrorStream(bl);
    }

    public final boolean hasEnvVar(String string) {
        return this.builder.environment().containsKey(this.getCanonicalVarName(string));
    }

    public final void addEnvVar(String string, String string2) {
        this.builder.environment().put(this.getCanonicalVarName(string), string2);
    }

    public void prependArgs(List<String> list) {
        this.builder.command().addAll(0, list);
    }

    public String getCanonicalVarName(String object) {
        if (!Env.getOS().isEnvironmentCaseSensitive()) {
            Object object2;
            if (this.canonicalEnvVarNames.isEmpty()) {
                object2 = this.builder.environment().keySet().iterator();
                while (object2.hasNext()) {
                    String string = (String)object2.next();
                    this.canonicalEnvVarNames.put(StringUtil.lc(string), string);
                }
            }
            if ((object2 = this.canonicalEnvVarNames.get(StringUtil.lc((String)object))) == null) {
                this.canonicalEnvVarNames.put(StringUtil.lc((String)object), (String)object);
            } else {
                object = object2;
            }
        }
        return object;
    }

    public Map<String, String> getCanonicalCurrentEnv() {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        for (Map.Entry<String, String> entry : this.builder.environment().entrySet()) {
            linkedHashMap.put(this.getCanonicalVarName(entry.getKey()), entry.getValue());
        }
        return linkedHashMap;
    }

    public final void setIn(InputStream inputStream) {
        this.in = inputStream;
    }

    public final void setEnvironment(Map<String, String> map) {
        this.builder.environment().clear();
        this.canonicalEnvVarNames.clear();
        this.addEnvironment(map);
    }

    public final void addEnvironment(Map<String, String> map) {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            this.addEnvVar(entry.getKey(), entry.getValue());
        }
    }

    public final int execute() {
        return this.execute(0L);
    }

    public final void expectFailure() {
        this.logFailure = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public final int execute(long l) {
        Process process = null;
        boolean bl = true;
        Timer timer = null;
        Object object = this;
        // MONITORENTER : object
        if (this.interrupted) {
            throw new InterruptedException();
        }
        this.threadToInterrupt = Thread.currentThread();
        // MONITOREXIT : object
        bl = false;
        object = this.builder.directory() == null ? "current directory ('" + System.getProperty("user.dir") + "')" : "'" + this.builder.directory().toString() + "'";
        logger.debug("Running command: '" + this.toString() + "' in " + (String)object);
        process = this.builder.start();
        this.setupInputHandling(process.getOutputStream());
        this.setupOutputHandling(process.getInputStream(), process.getErrorStream());
        if (l != 0L) {
            timer = new Timer(true);
            final Thread thread = Thread.currentThread();
            timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    AbstractProcessBuilder.this.hitTimeout = true;
                    thread.interrupt();
                }
            }, l);
        }
        int n = process.waitFor();
        bl = true;
        if (n != 0 && this.logFailure) {
            logger.error("Spawned process exited abnormally (code " + n + "; tried to run: " + this.getBuilderCommand() + ")");
        }
        int n2 = n;
        if (timer != null) {
            timer.cancel();
        }
        AbstractProcessBuilder abstractProcessBuilder = this;
        // MONITORENTER : abstractProcessBuilder
        this.threadToInterrupt = null;
        Thread.interrupted();
        // MONITOREXIT : abstractProcessBuilder
        if (process != null && !bl) {
            this.killProcess(process);
        }
        try {
            this.cleanupInputHandling();
            this.cleanupOutputHandling();
            return n2;
        }
        finally {
            if (process != null) {
                FileUtil.close(process.getErrorStream());
                FileUtil.close(process.getInputStream());
                FileUtil.close(process.getOutputStream());
            }
        }
        catch (IOException iOException) {
            try {
                throw new ResourceError("IOException while executing process with args: " + this.getBuilderCommand(), iOException);
                catch (InterruptedException interruptedException) {
                    throw new InterruptedError("InterruptedException while executing process with args: " + this.getBuilderCommand(), interruptedException);
                }
            }
            catch (Throwable throwable) {
                if (timer != null) {
                    timer.cancel();
                }
                AbstractProcessBuilder abstractProcessBuilder2 = this;
                // MONITORENTER : abstractProcessBuilder2
                this.threadToInterrupt = null;
                Thread.interrupted();
                // MONITOREXIT : abstractProcessBuilder2
                if (process != null && !bl) {
                    this.killProcess(process);
                }
                try {
                    this.cleanupInputHandling();
                    this.cleanupOutputHandling();
                    throw throwable;
                }
                finally {
                    if (process != null) {
                        FileUtil.close(process.getErrorStream());
                        FileUtil.close(process.getInputStream());
                        FileUtil.close(process.getOutputStream());
                    }
                }
            }
        }
    }

    protected void killProcess(Process process) {
        process.destroy();
    }

    protected void setupInputHandling(OutputStream outputStream) {
        if (this.in == null) {
            FileUtil.close(outputStream);
            return;
        }
        this.inMuncher = new RawStreamMuncher(this.in, outputStream);
        this.inMuncher.start();
    }

    protected abstract void setupOutputHandling(InputStream var1, InputStream var2);

    protected abstract void cleanupOutputHandling();

    private void cleanupInputHandling() {
        if (this.inMuncher != null && this.inMuncher.isAlive()) {
            this.inMuncher.interrupt();
        }
    }

    protected void waitForMuncher(String string, Thread thread, long l) {
        try {
            thread.join(l);
        }
        catch (InterruptedException interruptedException) {
            Exceptions.ignore(interruptedException, "Further interruption attempts are ineffective -- we're already waiting for termination.");
        }
        if (thread.isAlive()) {
            thread.interrupt();
            logger.error(String.format("Standard %s stream hasn't closed %s seconds after termination of subprocess '%s'.", string, 20L, this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void kill() {
        AbstractProcessBuilder abstractProcessBuilder = this;
        synchronized (abstractProcessBuilder) {
            this.interrupted = true;
            if (this.threadToInterrupt != null) {
                this.threadToInterrupt.interrupt();
            }
        }
    }

    public boolean processTimedOut() {
        return this.hitTimeout;
    }

    public String toString() {
        return AbstractProcessBuilder.commandLineToString(this.getBuilderCommand());
    }

    private List<String> getBuilderCommand() {
        return this.leakPrevention.cleanUpArguments(this.builder.command());
    }

    private static String commandLineToString(List<String> list) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (String string : list) {
            boolean bl2;
            boolean bl3 = bl2 = string.isEmpty() || string.contains(" ");
            if (!bl) {
                stringBuilder.append(" ");
            }
            bl = false;
            if (bl2) {
                stringBuilder.append("\"");
            }
            stringBuilder.append(string.replace("\"", "\\\""));
            if (!bl2) continue;
            stringBuilder.append("\"");
        }
        return stringBuilder.toString();
    }
}

