/*
 * Decompiled with CFR 0.152.
 */
package com.semmle.util.process;

import com.semmle.util.exception.Exceptions;
import com.semmle.util.expansion.ExpansionEnvironment;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Stack;
import java.util.TreeMap;

public class Env {
    private static final int DEFAULT_RAM_MB_32 = 1024;
    private static final int DEFAULT_RAM_MB = 4096;
    private static final Env instance = new Env();
    private final Stack<Map<String, String>> envVarContexts = new Stack();

    public static synchronized Env systemEnv() {
        return instance;
    }

    public static Env emptyEnv() {
        Env env = new Env();
        env.envVarContexts.clear();
        env.envVarContexts.push(Collections.unmodifiableMap(Env.makeContext()));
        return env;
    }

    private static Map<String, String> makeContext() {
        if (Env.getOS().equals((Object)OS.WINDOWS)) {
            return new TreeMap<String, String>((string, string2) -> string.toUpperCase(Locale.ENGLISH).compareTo(string2.toUpperCase(Locale.ENGLISH)));
        }
        return new LinkedHashMap<String, String>();
    }

    public Env() {
        Map<String, String> map = Env.makeContext();
        try {
            map.putAll(System.getenv());
        }
        catch (SecurityException securityException) {
            Exceptions.ignore(securityException, "Treat an inaccessible environment variable as not existing");
        }
        this.envVarContexts.push(Collections.unmodifiableMap(map));
    }

    public synchronized void unsetAll(Collection<String> collection) {
        if (!collection.isEmpty()) {
            Map<String, String> map = this.envVarContexts.pop();
            map = new LinkedHashMap<String, String>(map);
            for (String string : collection) {
                map.remove(string);
            }
            this.envVarContexts.push(Collections.unmodifiableMap(map));
        }
    }

    public synchronized Map<String, String> getenv() {
        return this.envVarContexts.peek();
    }

    public synchronized String get(Var var) {
        return this.get(var.name());
    }

    public synchronized String get(String string) {
        return this.getenv().get(string);
    }

    public synchronized String getNonEmpty(Var var) {
        return this.getNonEmpty(var.name());
    }

    public synchronized String getPossiblyEmpty(String string) {
        String string2 = this.getenv().get(string);
        return string2 != null ? string2 : "";
    }

    public synchronized String getNonEmpty(String string) {
        String string2 = this.get(string);
        return string2 == null || string2.isEmpty() ? null : string2;
    }

    public synchronized String getFirstNonEmpty(String ... stringArray) {
        for (String string : stringArray) {
            String string2 = this.getNonEmpty(string);
            if (string2 == null) continue;
            return string2;
        }
        return null;
    }

    public synchronized String getFirstNonEmpty(Var ... varArray) {
        String[] stringArray = new String[varArray.length];
        for (int i = 0; i < varArray.length; ++i) {
            stringArray[i] = varArray[i].name();
        }
        return this.getFirstNonEmpty(stringArray);
    }

    public boolean getBoolean(Var var) {
        return this.getBoolean(var.name());
    }

    public boolean getBoolean(String string) {
        return this.getBoolean(string, false);
    }

    public boolean getBoolean(Var var, boolean bl) {
        return this.getBoolean(var.name(), bl);
    }

    public boolean getBoolean(String string, boolean bl) {
        String string2 = this.get(string);
        return string2 == null ? bl : Boolean.parseBoolean(string2);
    }

    public int getInt(Var var, int n) {
        return this.getInt(var.name(), n);
    }

    public int getInt(String string, int n) {
        String string2 = this.get(string);
        if (string2 == null) {
            return n;
        }
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            Exceptions.ignore(numberFormatException, "We'll just use the default value.");
            return n;
        }
    }

    public synchronized void pushEnvironmentContext(Map<String, String> map) {
        Map<String, String> map2 = Env.makeContext();
        map2.putAll(this.envVarContexts.peek());
        map2.putAll(map);
        this.envVarContexts.push(Collections.unmodifiableMap(map2));
    }

    public synchronized void popEnvironmentContext() {
        this.envVarContexts.pop();
    }

    public synchronized void addEnvironmentToNewProcess(ProcessBuilder processBuilder) {
        if (this.envVarContexts.size() > 1) {
            processBuilder.environment().putAll(this.envVarContexts.peek());
        }
    }

    public synchronized void addEnvironmentToNewEnv(ExpansionEnvironment expansionEnvironment) {
        if (this.envVarContexts.size() > 1) {
            expansionEnvironment.defineVars(this.envVarContexts.peek());
        }
    }

    public static String getOSName() {
        return System.getProperty("os.name");
    }

    public static OS getOS() {
        String string = Env.getOSName();
        if (string == null) {
            return OS.UNKNOWN;
        }
        if (string.contains("Windows")) {
            return OS.WINDOWS;
        }
        if (string.contains("Mac OS X")) {
            return OS.MACOS;
        }
        if (string.contains("Linux")) {
            return OS.LINUX;
        }
        return OS.UNKNOWN_UNIX;
    }

    public Architecture tryDetermineJvmArchitecture() {
        String string = System.getProperty("sun.arch.data.model");
        if ("32".equals(string)) {
            return Architecture.X86;
        }
        if ("64".equals(string)) {
            return Architecture.X64;
        }
        long l = Runtime.getRuntime().maxMemory();
        if (l < Long.MAX_VALUE && l >= 0x100000000L) {
            return Architecture.X64;
        }
        String string2 = System.getProperty("os.arch");
        if ("x86".equals(string2) || "i386".equals(string2)) {
            return Architecture.X86;
        }
        if ("x86_64".equals(string2) || "amd64".equals(string2)) {
            return Architecture.X64;
        }
        return Architecture.UNDETERMINED;
    }

    public int defaultRamMb() {
        return this.getInt(Var.SEMMLE_DEFAULT_HEAP_SIZE, this.tryDetermineJvmArchitecture().is32Bit() ? 1024 : 4096);
    }

    public static enum OS {
        WINDOWS(false, false),
        LINUX(true, true),
        MACOS(false, true),
        UNKNOWN_UNIX(true, true),
        UNKNOWN(true, true);

        private final boolean fileSystemCaseSensitive;
        private final boolean envVarsCaseSensitive;

        private OS(boolean bl, boolean bl2) {
            this.fileSystemCaseSensitive = bl;
            this.envVarsCaseSensitive = bl2;
        }

        public static OS fromDisplayName(String string) {
            if (string != null) {
                if ("WINDOWS".equals(string = string.toUpperCase())) {
                    return WINDOWS;
                }
                if ("LINUX".equals(string)) {
                    return LINUX;
                }
                if ("MACOS".equals(string.replace(" ", ""))) {
                    return MACOS;
                }
            }
            throw new IllegalArgumentException("No OS type found with name " + string);
        }

        public boolean isFileSystemCaseSensitive() {
            return this.fileSystemCaseSensitive;
        }

        public boolean isEnvironmentCaseSensitive() {
            return this.envVarsCaseSensitive;
        }

        public String getShortName() {
            switch (this) {
                case WINDOWS: {
                    return "win";
                }
                case LINUX: {
                    return "linux";
                }
                case MACOS: {
                    return "osx";
                }
            }
            return "unknown";
        }
    }

    public static enum Var {
        ODASA_HOME,
        SEMMLE_HOME,
        SEMMLE_DATA,
        SEMMLE_CACHE,
        SEMMLE_DIST,
        SEMMLE_GIT_ROOT,
        SEMMLE_QUERY_ROOT,
        SEMMLE_LOCK_DIR,
        SEMMLE_LICENSE_DIR,
        ODASA_QUERIES,
        ODASA_TOOLS,
        ODASA_PROTOTYPE_MODE,
        SEMMLE_COMPILATION_CACHE,
        SEMMLE_OVERRIDE_OPTIMISER_VERSION,
        SEMMLE_NO_COMPILATION_CACHING,
        SEMMLE_COMPILATION_CACHE_SIZE,
        SEMMLE_JAVA_HOME,
        ODASA_JAVA_HOME,
        ODASA_TRACER_CONFIGURATION,
        SEMMLE_JAVA_TOOL_OPTIONS,
        ODASA_IN_PROCESS,
        SEMMLE_TRAP_IMPORTER,
        SEMMLE_PRESERVE_SYMLINKS,
        SEMMLE_PATH_TRANSFORMER,
        SEMMLE_CREDENTIALS_PASSWORD,
        LGTM_CREDENTIALS_PASSWORD,
        SEMMLE_JAVA_ARGS,
        SEMMLE_LOG_LEVELS,
        SEMMLE_DEFAULT_HEAP_SIZE,
        SEMMLE_MAX_RAM_MB,
        SEMMLE_SYNCHRONOUS_LOGGING,
        SEMMLE_MEMORY_MAPPING,
        SEMMLE_METRICS_DIR,
        SEMMLE_UNIT_TEST_MODE,
        SEMMLE_DEBUG_QL_IN_QLO,
        ODASA_ASSERTIONS,
        ODASA_EXTRA_VARIABLES,
        ODASA_TUNE_GC,
        SEMMLE_ODASA_DEBUG,
        SEMMLE_PYTHON,
        SEMMLE_PLATFORM,
        SEMMLE_PLATFORM_TOOLS,
        CODEQL_TOOL_PATH,
        CODEQL_BDD_RESET_FRACTION,
        SEMMLE_MAX_TRAP_ERRORS,
        SEMMLE_MAX_TRAP_INMEMORY_TUPLES,
        SEMMLE_MAX_TRAP_MERGE,
        SEMMLE_COPY_EXECUTABLES,
        SEMMLE_COPY_EXECUTABLES_SUPER_ROOT,
        SEMMLE_COPY_EXECUTABLES_ROOT,
        SEMMLE_WINDOWS_RUNNER_BINARY,
        SEMMLE_INTERCEPT_VERBOSITY,
        ODASA_JAVAC_VERBOSE,
        ODASA_JAVA_CLASS_ORIGIN_TRACKING,
        ODASA_JAVAC_CORRECT_EXCEPTIONS,
        ODASA_JAVAC_EXTRA_CLASSPATH,
        ODASA_NO_ECLIPSE_BUILD,
        ODASA_PROJECT,
        ODASA_SNAPSHOT,
        ODASA_SNAPSHOT_NAME,
        ODASA_SRC,
        ODASA_DB,
        ODASA_BUILD_ERROR_DIR,
        TRAP_FOLDER,
        SOURCE_ARCHIVE,
        ODASA_OUTPUT,
        ODASA_SUBPROJECT_THREADS,
        ODASA_JAVA_LAYOUT,
        ODASA_CPP_LAYOUT,
        ODASA_CSHARP_LAYOUT,
        ODASA_PYTHON_LAYOUT,
        ODASA_JAVASCRIPT_LAYOUT,
        JAVA_HOME,
        PATH,
        LINUX_VARIANT,
        HTTP_PROXY,
        http_proxy,
        HTTPS_PROXY,
        https_proxy,
        NO_PROXY,
        no_proxy,
        CODEQL_ACTION_RUN_MODE,
        CODEQL_ACTION_VERSION,
        CODEQL_TRACER_LANGUAGES,
        CODEQL_TRACER_LOG,
        CODEQL_TRACER_ROOT_;

    }

    public static enum Architecture {
        X86(true, false),
        X64(false, true),
        UNDETERMINED(false, false);

        private final boolean is32Bit;
        private final boolean is64Bit;

        private Architecture(boolean bl, boolean bl2) {
            this.is32Bit = bl;
            this.is64Bit = bl2;
        }

        public boolean is32Bit() {
            return this.is32Bit;
        }

        public boolean is64Bit() {
            return this.is64Bit;
        }
    }
}

