/*
 * Decompiled with CFR 0.152.
 */
package com.semmle.util.process;

import com.semmle.util.io.StreamMuncher;
import com.semmle.util.logging.Streams;
import com.semmle.util.process.AbstractProcessBuilder;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class Builder
extends AbstractProcessBuilder {
    private final OutputStream err;
    private final OutputStream out;
    protected StreamMuncher errMuncher;
    protected StreamMuncher outMuncher;

    public Builder(OutputStream outputStream, OutputStream outputStream2, File file, String ... stringArray) {
        this(outputStream, outputStream2, file, (Map<String, String>)null, stringArray);
    }

    public Builder(OutputStream outputStream, OutputStream outputStream2, File file, Map<String, String> map, String ... stringArray) {
        this(Arrays.asList(stringArray), outputStream, outputStream2, map, file);
    }

    public Builder(List<String> list, OutputStream outputStream, OutputStream outputStream2) {
        this(list, outputStream, outputStream2, null, null);
    }

    public Builder(List<String> list, OutputStream outputStream, OutputStream outputStream2, File file) {
        this(list, outputStream, outputStream2, null, file);
    }

    public Builder(List<String> list, OutputStream outputStream, OutputStream outputStream2, Map<String, String> map) {
        this(list, outputStream, outputStream2, map, null);
    }

    public Builder(List<String> list, OutputStream outputStream, OutputStream outputStream2, Map<String, String> map, File file) {
        super(list, file, map);
        this.out = outputStream;
        this.err = outputStream2;
    }

    public static int run(List<String> list) {
        return new Builder(list, Streams.out(), Streams.err()).execute();
    }

    @Override
    protected void cleanupOutputHandling() {
        long l = 20000L;
        if (this.outMuncher != null) {
            this.waitForMuncher("output", this.outMuncher, l);
        }
        if (this.errMuncher != null) {
            this.waitForMuncher("error", this.errMuncher, l);
        }
    }

    @Override
    protected void setupOutputHandling(InputStream inputStream, InputStream inputStream2) {
        this.errMuncher = new StreamMuncher(inputStream2, this.err);
        this.errMuncher.start();
        this.outMuncher = new StreamMuncher(inputStream, this.out);
        this.outMuncher.start();
    }
}

