/*
 * Decompiled with CFR 0.152.
 */
package com.github.codeql;

import com.github.codeql.DbFile;
import com.github.codeql.DbLocatable;
import com.github.codeql.FileLogger;
import com.github.codeql.FileTrapWriter;
import com.github.codeql.KotlinExtractorDbSchemeKt;
import com.github.codeql.Label;
import com.github.codeql.utils.versions.Psi2IrFacade;
import com.github.codeql.utils.versions.Psi2IrKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.editor.Document;
import org.jetbrains.kotlin.com.intellij.openapi.util.TextRange;
import org.jetbrains.kotlin.com.intellij.psi.PsiComment;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiWhiteSpace;
import org.jetbrains.kotlin.config.KotlinCompilerVersion;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtVisitor;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\"B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\"\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0012\u0010\u0017\u001a\u000e\u0012\n\b\u0001\u0012\u00060\u0019j\u0002`\u001a0\u0018J\u0014\u0010\u001b\u001a\u00020\u00142\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0018J,\u0010\u001d\u001a\u00020\u00142\u0012\u0010\u0017\u001a\u000e\u0012\n\b\u0001\u0012\u00060\u0019j\u0002`\u001a0\u00182\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0002R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006#"}, d2={"Lcom/github/codeql/LinesOfCode;", "", "logger", "Lcom/github/codeql/FileLogger;", "tw", "Lcom/github/codeql/FileTrapWriter;", "file", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "(Lcom/github/codeql/FileLogger;Lcom/github/codeql/FileTrapWriter;Lorg/jetbrains/kotlin/ir/declarations/IrFile;)V", "getFile", "()Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "getLogger", "()Lcom/github/codeql/FileLogger;", "psi2Ir", "Lcom/github/codeql/utils/versions/Psi2IrFacade;", "getPsi2Ir", "()Lcom/github/codeql/utils/versions/Psi2IrFacade;", "getTw", "()Lcom/github/codeql/FileTrapWriter;", "linesOfCodeInDeclaration", "", "d", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "id", "Lcom/github/codeql/Label;", "Lcom/github/codeql/DbLocatable;", "Lcom/github/codeql/DbSourceline;", "linesOfCodeInFile", "Lcom/github/codeql/DbFile;", "linesOfCodeInPsi", "root", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "e", "Lorg/jetbrains/kotlin/ir/IrElement;", "LineContent", "codeql-kotlin-extractor"})
@SourceDebugExtension(value={"SMAP\nLinesOfCode.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LinesOfCode.kt\ncom/github/codeql/LinesOfCode\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,139:1\n12831#2,3:140\n12831#2,3:143\n*S KotlinDebug\n*F\n+ 1 LinesOfCode.kt\ncom/github/codeql/LinesOfCode\n*L\n129#1:140,3\n130#1:143,3\n*E\n"})
public final class LinesOfCode {
    @NotNull
    private final FileLogger logger;
    @NotNull
    private final FileTrapWriter tw;
    @NotNull
    private final IrFile file;
    @Nullable
    private final Psi2IrFacade psi2Ir;

    /*
     * WARNING - void declaration
     */
    public LinesOfCode(@NotNull FileLogger logger, @NotNull FileTrapWriter tw, @NotNull IrFile file) {
        void it;
        Psi2IrFacade psi2IrFacade;
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)tw, (String)"tw");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.logger = logger;
        this.tw = tw;
        this.file = file;
        Psi2IrFacade psi2IrFacade2 = psi2IrFacade = Psi2IrKt.getPsi2Ir();
        LinesOfCode linesOfCode = this;
        boolean bl = false;
        if (it == null) {
            this.logger.warn("Lines of code will not be populated as Kotlin version is too old (" + KotlinCompilerVersion.getVersion() + ')');
        }
        linesOfCode.psi2Ir = psi2IrFacade;
    }

    @NotNull
    public final FileLogger getLogger() {
        return this.logger;
    }

    @NotNull
    public final FileTrapWriter getTw() {
        return this.tw;
    }

    @NotNull
    public final IrFile getFile() {
        return this.file;
    }

    @Nullable
    public final Psi2IrFacade getPsi2Ir() {
        return this.psi2Ir;
    }

    public final void linesOfCodeInFile(@NotNull Label<DbFile> id2) {
        Intrinsics.checkNotNullParameter(id2, (String)"id");
        if (this.psi2Ir == null) {
            return;
        }
        KtFile ktFile = this.psi2Ir.getKtFile(this.file);
        if (ktFile == null) {
            return;
        }
        this.linesOfCodeInPsi(id2, (PsiElement)ktFile, (IrElement)this.file);
    }

    public final void linesOfCodeInDeclaration(@NotNull IrDeclaration d, @NotNull Label<? extends DbLocatable> id2) {
        Intrinsics.checkNotNullParameter((Object)d, (String)"d");
        Intrinsics.checkNotNullParameter(id2, (String)"id");
        if (this.psi2Ir == null) {
            return;
        }
        PsiElement p = this.psi2Ir.findPsiElement((IrElement)d, this.file);
        if (p == null) {
            return;
        }
        this.linesOfCodeInPsi(id2, p, (IrElement)d);
    }

    private final void linesOfCodeInPsi(Label<? extends DbLocatable> id2, PsiElement root, IrElement e) {
        int n;
        Document document = root.getContainingFile().getViewProvider().getDocument();
        if (document == null) {
            FileLogger.errorElement$default(this.logger, "Cannot find document for PSI", e, null, 4, null);
            KotlinExtractorDbSchemeKt.writeNumlines(this.tw, id2, 0, 0, 0);
            return;
        }
        TextRange rootRange = root.getTextRange();
        int rootFirstLine = document.getLineNumber(rootRange.getStartOffset());
        int rootLastLine = document.getLineNumber(rootRange.getEndOffset());
        if (rootLastLine < rootFirstLine) {
            FileLogger.errorElement$default(this.logger, "PSI ends before it starts", e, null, 4, null);
            KotlinExtractorDbSchemeKt.writeNumlines(this.tw, id2, 0, 0, 0);
            return;
        }
        int numLines = 1 + rootLastLine - rootFirstLine;
        int n2 = 0;
        LineContent[] lineContentArray = new LineContent[numLines];
        while (n2 < numLines) {
            int n3 = n2++;
            lineContentArray[n3] = new LineContent();
        }
        LineContent[] lineContents = lineContentArray;
        KtVisitor<Unit, Unit> visitor2 = new KtVisitor<Unit, Unit>(this, e, document, rootFirstLine, rootLastLine, lineContents){
            final /* synthetic */ LinesOfCode this$0;
            final /* synthetic */ IrElement $e;
            final /* synthetic */ Document $document;
            final /* synthetic */ int $rootFirstLine;
            final /* synthetic */ int $rootLastLine;
            final /* synthetic */ LineContent[] $lineContents;
            {
                this.this$0 = $receiver;
                this.$e = $e;
                this.$document = $document;
                this.$rootFirstLine = $rootFirstLine;
                this.$rootLastLine = $rootLastLine;
                this.$lineContents = $lineContents;
            }

            public void visitElement(@NotNull PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                boolean isComment = element instanceof PsiComment;
                if (!isComment) {
                    element.acceptChildren((PsiElementVisitor)this);
                }
                if (element instanceof PsiWhiteSpace) {
                    return;
                }
                if (isComment || element.getChildren().length == 0) {
                    TextRange range = element.getTextRange();
                    int startOffset = range.getStartOffset();
                    int endOffset = range.getEndOffset();
                    if (startOffset < 0 || endOffset < 0) {
                        FileLogger.errorElement$default(this.this$0.getLogger(), "PSI has negative offset", this.$e, null, 4, null);
                        return;
                    }
                    if (startOffset > endOffset) {
                        return;
                    }
                    if (startOffset == endOffset) {
                        return;
                    }
                    int firstLine = this.$document.getLineNumber(startOffset);
                    int lastLine = this.$document.getLineNumber(endOffset);
                    if (firstLine < this.$rootFirstLine) {
                        FileLogger.errorElement$default(this.this$0.getLogger(), "PSI element starts before root", this.$e, null, 4, null);
                        return;
                    }
                    if (lastLine > this.$rootLastLine) {
                        FileLogger.errorElement$default(this.this$0.getLogger(), "PSI element ends after root", this.$e, null, 4, null);
                        return;
                    }
                    int line = firstLine;
                    if (line <= lastLine) {
                        while (true) {
                            LineContent lineContent = this.$lineContents[line - this.$rootFirstLine];
                            if (isComment) {
                                lineContent.setContainsComment(true);
                            } else {
                                lineContent.setContainsCode(true);
                            }
                            if (line == lastLine) break;
                            ++line;
                        }
                    }
                }
            }
        };
        root.accept((PsiElementVisitor)visitor2);
        int total = lineContents.length;
        LineContent[] $this$count$iv = lineContents;
        boolean $i$f$count = false;
        int count$iv = 0;
        LineContent[] lineContentArray2 = $this$count$iv;
        int n4 = lineContentArray2.length;
        for (n = 0; n < n4; ++n) {
            LineContent element$iv;
            LineContent it = element$iv = lineContentArray2[n];
            boolean bl = false;
            if (!it.getContainsCode()) continue;
            ++count$iv;
        }
        int code = count$iv;
        LineContent[] $this$count$iv2 = lineContents;
        boolean $i$f$count2 = false;
        int count$iv2 = 0;
        LineContent[] lineContentArray3 = $this$count$iv2;
        n = lineContentArray3.length;
        for (int i = 0; i < n; ++i) {
            LineContent element$iv;
            LineContent it = element$iv = lineContentArray3[i];
            boolean bl = false;
            if (!it.getContainsComment()) continue;
            ++count$iv2;
        }
        int comment = count$iv2;
        KotlinExtractorDbSchemeKt.writeNumlines(this.tw, id2, total, code, comment);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0006\"\u0004\b\u000b\u0010\b\u00a8\u0006\f"}, d2={"Lcom/github/codeql/LinesOfCode$LineContent;", "", "()V", "containsCode", "", "getContainsCode", "()Z", "setContainsCode", "(Z)V", "containsComment", "getContainsComment", "setContainsComment", "codeql-kotlin-extractor"})
    private static final class LineContent {
        private boolean containsComment;
        private boolean containsCode;

        public final boolean getContainsComment() {
            return this.containsComment;
        }

        public final void setContainsComment(boolean bl) {
            this.containsComment = bl;
        }

        public final boolean getContainsCode() {
            return this.containsCode;
        }

        public final void setContainsCode(boolean bl) {
            this.containsCode = bl;
        }
    }
}

