/*
 * Decompiled with CFR 0.152.
 */
package com.semmle.util.io.csv;

import com.semmle.util.io.csv.CSVParser;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;

public class CSVReader
implements Closeable {
    private final BufferedReader br;
    private boolean hasNext = true;
    private final CSVParser parser;
    private final int skipLines;
    private boolean linesSkipped;
    private int curline = 0;
    private int startLine = 0;
    private static final int DEFAULT_SKIP_LINES = 0;

    public CSVReader(Reader reader) {
        this(reader, ',', '\"', '\"', 0, false);
    }

    private CSVReader(Reader reader, char c, char c2, char c3, int n, boolean bl) {
        this.br = new BufferedReader(reader);
        this.parser = new CSVParser(c, c2, c3, bl);
        this.skipLines = n;
    }

    public List<String[]> readAll() throws IOException {
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        while (this.hasNext) {
            String[] stringArray = this.readNext();
            if (stringArray == null) continue;
            arrayList.add(stringArray);
        }
        return arrayList;
    }

    public String[] readNext() throws IOException {
        boolean bl = true;
        String[] stringArray = null;
        do {
            String string = this.getNextLine();
            if (bl) {
                this.startLine = this.curline;
                bl = false;
            }
            if (!this.hasNext) {
                return stringArray;
            }
            String[] stringArray2 = this.parser.parseLineMulti(string);
            if (stringArray2.length <= 0) continue;
            if (stringArray == null) {
                stringArray = stringArray2;
                continue;
            }
            String[] stringArray3 = new String[stringArray.length + stringArray2.length];
            System.arraycopy(stringArray, 0, stringArray3, 0, stringArray.length);
            System.arraycopy(stringArray2, 0, stringArray3, stringArray.length, stringArray2.length);
            stringArray = stringArray3;
        } while (this.parser.isPending());
        return stringArray;
    }

    private String getNextLine() throws IOException {
        String string;
        if (!this.linesSkipped) {
            for (int i = 0; i < this.skipLines; ++i) {
                this.br.readLine();
                ++this.curline;
            }
            this.linesSkipped = true;
        }
        if ((string = this.br.readLine()) == null) {
            this.hasNext = false;
        } else {
            ++this.curline;
        }
        return this.hasNext ? string : null;
    }

    @Override
    public void close() throws IOException {
        this.br.close();
    }

    public int getStartLine() {
        return this.startLine;
    }
}

