/*
 * Decompiled with CFR 0.152.
 */
package com.semmle.util.trap.dependencies;

import com.semmle.util.exception.ResourceError;
import com.semmle.util.trap.dependencies.TextFile;
import java.nio.file.Path;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

public class TrapSet
extends TextFile {
    static final String HEADER = "TRAP dependencies";
    static final String LATEST_VERSION = "1.2";
    static final String SOURCES = "SOURCES";
    static final String INCLUDES = "INCLUDES";
    static final String OBJECTS = "OBJECTS";
    static final String INPUT_OBJECTS = "INPUT_OBJECTS";
    private final Set<String> sources = new LinkedHashSet<String>();
    private final Set<String> includes = new LinkedHashSet<String>();
    private final Set<String> objects = new LinkedHashSet<String>();
    private final Set<String> inputObjects = new LinkedHashSet<String>();
    private Path file;

    public TrapSet() {
        super(LATEST_VERSION);
    }

    @Override
    protected Set<String> getSet(Path path, String string) {
        if (string.equals(SOURCES)) {
            return this.sources;
        }
        if (string.equals(INCLUDES)) {
            return this.includes;
        }
        if (string.equals(OBJECTS)) {
            return this.objects;
        }
        if (string.equals(INPUT_OBJECTS)) {
            return this.inputObjects;
        }
        if (string.equals("TRAPS")) {
            return this.traps;
        }
        return null;
    }

    public TrapSet(Path path) {
        super(null);
        this.load(HEADER, path);
        this.file = path;
    }

    public Path getFile() {
        return this.file;
    }

    @Override
    protected void parseError(Path path) {
        throw new ResourceError("Corrupt TRAP set: " + path);
    }

    public Set<String> sourceFiles() {
        return Collections.unmodifiableSet(this.sources);
    }

    public Set<String> includeFiles() {
        return Collections.unmodifiableSet(this.includes);
    }

    public Set<String> trapFiles() {
        return Collections.unmodifiableSet(this.traps);
    }

    public Set<String> objectNames() {
        return Collections.unmodifiableSet(this.objects);
    }

    public Set<String> inputObjectNames() {
        return Collections.unmodifiableSet(this.inputObjects);
    }

    public void addSource(String string) {
        this.sources.add(string);
    }

    public void addInclude(String string) {
        this.includes.add(string);
    }

    public boolean addTrap(String string) {
        return this.traps.add(string);
    }

    public boolean containsTrap(String string) {
        return string.contains(string);
    }

    public boolean sourcesDisjointFrom(Set<String> set) {
        for (String string : this.sources) {
            if (!set.contains(string)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void save(Path path) {
        super.save(path);
        this.file = path;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendHeaderString(stringBuilder, HEADER, LATEST_VERSION);
        this.appendSet(stringBuilder, SOURCES, this.sources);
        this.appendSet(stringBuilder, INCLUDES, this.includes);
        this.appendSet(stringBuilder, OBJECTS, this.objects);
        this.appendSet(stringBuilder, INPUT_OBJECTS, this.inputObjects);
        this.appendSet(stringBuilder, "TRAPS", this.traps);
        return stringBuilder.toString();
    }
}

