/*
 * Decompiled with CFR 0.152.
 */
package com.semmle.util.trap.pathtransformers;

import com.semmle.util.files.FileUtil;
import com.semmle.util.process.Env;
import com.semmle.util.trap.pathtransformers.NoopTransformer;
import com.semmle.util.trap.pathtransformers.ProjectLayoutTransformer;
import java.io.File;

public abstract class PathTransformer {
    private static final PathTransformer DEFAULT_TRANSFORMER;

    public abstract String transform(String var1);

    public String fileAsDatabaseString(File file) {
        String string = file.getPath();
        if (string.matches("^[/\\\\](!unknown-binary-location|modules)[/\\\\].*")) {
            return string.replace('\\', '/');
        }
        string = Boolean.valueOf(Env.systemEnv().get(Env.Var.SEMMLE_PRESERVE_SYMLINKS)) != false ? FileUtil.simplifyPath(file) : FileUtil.tryMakeCanonical(file).getPath();
        return this.transform(FileUtil.normalisePath(string));
    }

    public File canonicalFile(String string) {
        return new File(this.fileAsDatabaseString(new File(string)));
    }

    public static PathTransformer std() {
        return DEFAULT_TRANSFORMER;
    }

    static {
        String string = Env.systemEnv().get(Env.Var.SEMMLE_PATH_TRANSFORMER);
        DEFAULT_TRANSFORMER = string == null ? new NoopTransformer() : new ProjectLayoutTransformer(new File(string));
    }
}

