/*
 * Decompiled with CFR 0.152.
 */
package com.semmle.cli;

import com.semmle.cli.DebugOptions;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCliTool {
    final Logger logger = LoggerFactory.getLogger(AbstractCliTool.class);
    private final DebugOptions opts;

    protected AbstractCliTool(DebugOptions opts) {
        this.opts = opts;
    }

    protected void validationCheckExists(String desc, File f) {
        if (!f.exists()) {
            throw new IllegalArgumentException("Invalid " + desc + ": " + f);
        }
        this.log("Got valid " + desc + ": " + f);
    }

    protected void validationCheckExistsDir(String desc, File dir) {
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException("Invalid " + desc + ": " + dir);
        }
        this.log("Got valid " + desc + ": " + dir);
    }

    protected void validationCheckOrCreateDir(String desc, File dir) {
        if (!dir.isDirectory() && !dir.mkdirs()) {
            throw new IllegalArgumentException("Invalid " + desc + ": " + dir);
        }
        this.log("Got " + desc + ": " + dir);
    }

    protected void log(String msg) {
        if (this.opts.isVerbose()) {
            this.logger.info(msg);
        }
    }

    protected void warn(String msg) {
        this.logger.warn(msg);
    }

    protected void error(String msg) {
        this.logger.error(msg);
    }
}

