/*
 * Decompiled with CFR 0.152.
 */
package com.semmle.cli;

import ch.qos.logback.classic.Level;
import com.semmle.cli.AbstractCliTool;
import com.semmle.cli.SimpleExtractorOptions;
import com.semmle.util.exception.CatastrophicError;
import com.semmle.util.exception.ResourceError;
import com.semmle.util.files.FileUtil;
import com.semmle.util.files.PathMatcher;
import com.semmle.util.logging.LogbackUtils;
import com.semmle.util.logging.RecordingAppender;
import com.semmle.util.logging.StreamAppender;
import com.semmle.util.logging.Streams;
import com.semmle.util.projectstructure.ProjectLayout;
import com.semmle.util.trap.TrapWriter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import uk.co.flamingpenguin.jewel.cli.ArgumentValidationException;
import uk.co.flamingpenguin.jewel.cli.CliFactory;

public abstract class SimpleExtractor
extends AbstractCliTool {
    private final Logger logger = LoggerFactory.getLogger(SimpleExtractor.class);
    protected final SimpleExtractorOptions opts;
    private Set<String> extensions;
    private PathMatcher include;
    private PathMatcher exclude;
    private ProjectLayout layout;
    private final Marker marker;

    protected static <T> T getExtractorOptions(String[] args, Class<T> optionsClass) {
        T opts = null;
        try {
            opts = CliFactory.parseArguments(optionsClass, args);
            if (opts == null) {
                throw new CatastrophicError("Failure while parsing command line parameters.");
            }
            return opts;
        }
        catch (ArgumentValidationException e) {
            Streams.err().println(e.getMessage());
            System.exit(1);
            return opts;
        }
    }

    public void run() {
        Level logLevel;
        RecordingAppender errorLog = new RecordingAppender(Level.ERROR);
        LogbackUtils.semmleRoot().addAppender(errorLog);
        StreamAppender streamLog = new StreamAppender(Streams.out());
        LogbackUtils.semmleRoot().addAppender(streamLog);
        Level level = logLevel = this.opts.isDebug() ? Level.DEBUG : Level.WARN;
        if (this.opts.isVerbose()) {
            logLevel = this.opts.isDebug() ? Level.TRACE : Level.INFO;
        }
        LogbackUtils.semmleRoot().setLevel(logLevel);
        try {
            this.extract();
        }
        catch (Exception e) {
            Streams.err().println(e.getMessage() == null ? e : e.getMessage());
            if (this.opts.isVerbose()) {
                e.printStackTrace();
            }
            System.exit(2);
        }
        LogbackUtils.assertNoErrors(errorLog);
        LogbackUtils.semmleRoot().detachAppender(errorLog);
        LogbackUtils.semmleRoot().detachAppender(streamLog);
    }

    public SimpleExtractor(SimpleExtractorOptions opts, Set<String> defaultExtensions, Marker marker) {
        super(opts);
        this.opts = opts;
        this.marker = marker;
        this.extensions = defaultExtensions;
    }

    @Override
    protected void log(String msg) {
        if (this.opts.isVerbose()) {
            this.logger.info(this.marker, msg);
        }
    }

    @Override
    protected void warn(String msg) {
        this.logger.warn(this.marker, msg);
    }

    @Override
    protected void error(String msg) {
        this.logger.error(this.marker, msg);
    }

    protected abstract void extractFile(File var1, TrapWriter var2);

    protected boolean shouldExtract(File file) {
        return true;
    }

    public void extract() {
        this.validateOptions();
        LinkedHashSet<File> files = new LinkedHashSet<File>();
        if (this.opts.isExtensions()) {
            this.extensions = new LinkedHashSet<String>(this.opts.getExtensions());
        }
        if (this.opts.isIncludes()) {
            this.include = new PathMatcher(this.opts.getIncludes());
        }
        if (this.opts.isExcludes()) {
            this.exclude = new PathMatcher(this.opts.getExcludes());
        }
        if (this.opts.isProjectLayoutFile()) {
            this.layout = new ProjectLayout(this.opts.getProjectLayoutFile());
            this.log("Using project-layout file");
        }
        if (this.opts.isRoot()) {
            for (File child : this.opts.getRoot().listFiles()) {
                this.collectFiles(child, files);
            }
            if (files.isEmpty()) {
                this.warn("Failed to find any files in directory " + this.opts.getRoot());
            }
        }
        if (this.opts.isFileList()) {
            try (Stream<String> paths = Files.lines(this.opts.getFileList().toPath());){
                paths.map(File::new).forEach(files::add);
            }
            catch (IOException e) {
                throw new ResourceError("Failed to read file list " + this.opts.getFileList(), e);
            }
        }
        if (!this.opts.isOutputDir()) {
            this.warn(".trap.gz files will be produced in directories alongside extracted files");
        }
        for (File f : files) {
            if (!this.shouldExtract(f)) continue;
            this.log("Importing file " + f);
            File trapFile = null;
            TrapWriter writer = null;
            try {
                File canonicalF = FileUtil.tryMakeCanonical(f);
                File parent = canonicalF.getParentFile();
                if (parent == null) {
                    throw new CatastrophicError("Failed to resolve parent folder of file " + f + " from directory " + new File(".").getAbsolutePath());
                }
                if (this.opts.isOutputDir()) {
                    File baseDir = FileUtil.appendAbsolutePath(this.opts.getOutputDir(), parent.getPath());
                    baseDir.mkdirs();
                    trapFile = new File(baseDir, canonicalF.getName() + ".trap.gz");
                } else {
                    trapFile = new File(canonicalF.getAbsolutePath() + ".trap.gz");
                }
                writer = new TrapWriter(trapFile);
                this.extractFile(canonicalF, writer);
                if (this.opts.isSourceArchiveDir()) {
                    File outputDir = FileUtil.appendAbsolutePath(this.opts.getSourceArchiveDir(), parent.getPath());
                    outputDir.mkdirs();
                    FileUtil.copy(canonicalF, new File(outputDir, canonicalF.getName()));
                }
                FileUtil.close(writer);
            }
            catch (Exception e) {
                this.error("Failed to process file " + f + ": " + e.getClass().toString() + ": " + (e.getMessage() == null ? "" : e.getMessage()));
                FileUtil.close(writer);
                if (trapFile == null) continue;
                trapFile.delete();
            }
        }
    }

    private void collectFiles(File dirOrFile, Set<File> files) {
        if (this.exclude(dirOrFile)) {
            this.log("Skipping excluded file " + dirOrFile);
            return;
        }
        if (dirOrFile.isFile()) {
            String name = dirOrFile.getName();
            int index = name.lastIndexOf(46);
            if (!this.include(dirOrFile)) {
                return;
            }
            if (index != -1 && this.extensions.contains(name.substring(index + 1, name.length()))) {
                this.log("Found file " + dirOrFile);
                files.add(dirOrFile);
            }
        } else if (dirOrFile.isDirectory()) {
            this.log("Descending into directory " + dirOrFile);
            for (File f : dirOrFile.listFiles()) {
                this.collectFiles(f, files);
            }
        } else {
            this.warn("Unknown or invalid path entry " + dirOrFile);
        }
    }

    private boolean exclude(File dirOrFile) {
        String relativePath = FileUtil.relativePath(dirOrFile, this.opts.getRoot()).replace('\\', '/');
        if (this.layout != null && this.layout.includeFile("/" + relativePath)) {
            return false;
        }
        return this.exclude != null && this.exclude.matches(relativePath);
    }

    private boolean include(File file) {
        String relativePath = FileUtil.relativePath(file, this.opts.getRoot()).replace('\\', '/');
        if (this.layout == null && this.include == null) {
            return true;
        }
        if (this.layout != null && this.layout.includeFile("/" + relativePath)) {
            return true;
        }
        return this.include != null && this.include.matches(relativePath);
    }

    protected void validateOptions() {
        if (this.opts.isRoot()) {
            this.validationCheckExistsDir("root directory", this.opts.getRoot());
        }
        if (this.opts.isOutputDir()) {
            this.validationCheckOrCreateDir("output directory", this.opts.getOutputDir());
        }
        if (this.opts.isProjectLayoutFile()) {
            this.validationCheckExists("Project-layout file", this.opts.getProjectLayoutFile());
        }
        if (this.opts.isFileList()) {
            this.validationCheckExists("file list", this.opts.getFileList());
        }
    }
}

