/*
 * Decompiled with CFR 0.152.
 */
package com.semmle.cli;

import com.semmle.cli.SimpleExtractor;
import com.semmle.cli.SimpleExtractorOptions;
import com.semmle.cli.XmlExtractorOptions;
import com.semmle.extractor.xml.StAXXmlPopulator;
import com.semmle.util.exception.ResourceError;
import com.semmle.util.trap.TrapWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.slf4j.MarkerFactory;

public class XmlExtractor
extends SimpleExtractor {
    private final Set<String> primaryTags = XmlExtractor.getPrimaryTags();
    private static final Pattern SPACE = Pattern.compile("\\s+");

    public static void main(String[] args) {
        XmlExtractor.create(args).run();
    }

    public static XmlExtractor create(String[] args) {
        XmlExtractorOptions xmlOptions = XmlExtractor.getExtractorOptions(args, XmlExtractorOptions.class);
        Set<String> extensions = Collections.singleton("xml");
        if (xmlOptions.isXMLExtensions()) {
            extensions = new LinkedHashSet<String>(xmlOptions.getXMLExtensions());
        }
        return new XmlExtractor(xmlOptions, extensions);
    }

    public XmlExtractor(SimpleExtractorOptions opts, Set<String> defaultExtensions) {
        super(opts, defaultExtensions, MarkerFactory.getMarker("XMLExtractor"));
    }

    private static Set<String> getPrimaryTags() {
        String value = System.getenv("CODEQL_EXTRACTOR_XML_PRIMARY_TAGS");
        if (value == null) {
            return Collections.emptySet();
        }
        return new LinkedHashSet<String>(Arrays.asList(SPACE.split(value)));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean shouldExtract(File f) {
        if (this.primaryTags.isEmpty()) {
            return true;
        }
        try (FileInputStream input = new FileInputStream(f);){
            XMLStreamReader parser = StAXXmlPopulator.newXMLStreamReader(input);
            do {
                if (!parser.hasNext()) return false;
            } while (parser.next() != 1);
            QName name = parser.getName();
            String localName = name.getLocalPart();
            String prefix = name.getPrefix();
            String prefixedName = "".equals(prefix) ? localName : prefix + ":" + localName;
            boolean bl = this.primaryTags.contains(localName) || this.primaryTags.contains(prefixedName);
            return bl;
        }
        catch (FileNotFoundException e) {
            throw new ResourceError("Error opening file " + f, e);
        }
        catch (IOException | XMLStreamException e) {
            throw new ResourceError("Error reading file " + f.getAbsolutePath(), e);
        }
    }

    @Override
    protected void extractFile(File f, TrapWriter writer) {
        new StAXXmlPopulator(f, writer).doit();
    }
}

