/*
 * Decompiled with CFR 0.152.
 */
package com.semmle.extractor.xml;

import com.ctc.wstx.exc.WstxEOFException;
import com.ctc.wstx.sr.BasicStreamReader;
import com.ctc.wstx.sr.InputElementStack;
import com.ctc.wstx.stax.WstxInputFactory;
import com.semmle.extractor.xml.XmlTrapWriter;
import com.semmle.util.exception.Exceptions;
import com.semmle.util.exception.ResourceError;
import com.semmle.util.trap.TrapWriter;
import com.semmle.util.xml.NonResolvingXMLResolver;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.stream.Location;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StAXXmlPopulator {
    private static final Logger logger = LoggerFactory.getLogger(StAXXmlPopulator.class);
    private final File file;
    private TrapWriter.Label fileId;
    private Stack<XMLElement> stack;
    private final XmlTrapWriter populator;
    private int deferredEndElems = 0;
    private int lastParsedEvent = 8;
    private static final Pattern unexpectedCloseTagMsg = Pattern.compile("Unexpected close tag </(.*)>; expected </");
    private static final Pattern WS = Pattern.compile("\\s*");

    public StAXXmlPopulator(File file, TrapWriter writer) {
        this.file = file;
        this.populator = new XmlTrapWriter(writer);
    }

    public void doit() {
        try (FileInputStream input = new FileInputStream(this.file);){
            BasicStreamReader parser = (BasicStreamReader)StAXXmlPopulator.newXMLStreamReader(input);
            int event = parser.getEventType();
            Location startLocation = parser.getLocation();
            boolean stop = false;
            int lastLine = 0;
            Stack<Integer> commentLines = new Stack<Integer>();
            while (!stop) {
                Location endLocation;
                int nextEvent;
                switch (event) {
                    case 11: {
                        String dtdRoot = parser.getDTDRootName();
                        dtdRoot = dtdRoot == null ? "" : dtdRoot;
                        String dtdPublicId = parser.getDTDPublicId();
                        dtdPublicId = dtdPublicId == null ? "" : dtdPublicId;
                        String dtdSystemId = parser.getDTDSystemId();
                        dtdSystemId = dtdSystemId == null ? "" : dtdSystemId;
                        TrapWriter.Label dtdId = this.populator.insertDTD(dtdRoot, dtdPublicId, dtdSystemId, this.fileId);
                        nextEvent = this.parse(parser);
                        endLocation = parser.getLocation();
                        this.populator.insertLocation(dtdId, this.fileId, startLocation, endLocation);
                        int lines = StAXXmlPopulator.linesBetween(startLocation, endLocation);
                        this.populator.insertNumlines(dtdId, lines, lines, 0);
                        break;
                    }
                    case 7: {
                        commentLines.push(0);
                        this.fileId = this.populator.insertXMLFile(this.file);
                        this.stack = new Stack();
                        XMLElement element = new XMLElement(this.fileId, null, startLocation, null);
                        this.stack.push(element);
                        nextEvent = this.parse(parser);
                        endLocation = parser.getLocation();
                        element.setEndLocation(endLocation);
                        break;
                    }
                    case 8: {
                        String encoding = null;
                        encoding = parser.getEncoding();
                        encoding = encoding == null ? "" : encoding;
                        XMLElement element = this.stack.isEmpty() ? null : this.stack.pop();
                        nextEvent = event;
                        endLocation = startLocation;
                        stop = true;
                        if (element != null) {
                            this.populateCharacters(element);
                        }
                        this.populator.insertXMLEncoding(this.fileId, encoding);
                        this.populator.insertNumlines(this.fileId, lastLine, lastLine, StAXXmlPopulator.popOrZero(commentLines));
                        break;
                    }
                    case 1: {
                        TrapWriter.Label namespaceId;
                        String nameSpaceURI;
                        commentLines.push(0);
                        XMLElement element = this.stack.peek();
                        element.characters.startNew();
                        ArrayList<TrapWriter.Label> attributes = new ArrayList<TrapWriter.Label>();
                        for (int i = 0; i < parser.getNamespaceCount(); ++i) {
                            String nameSpacePrefix = parser.getNamespacePrefix(i);
                            nameSpacePrefix = nameSpacePrefix == null ? "" : nameSpacePrefix;
                            nameSpaceURI = parser.getNamespaceURI(i);
                            nameSpaceURI = nameSpaceURI == null ? "" : nameSpaceURI;
                            namespaceId = this.populator.getNamespaceID(nameSpaceURI);
                            this.populator.addNamespace(namespaceId, nameSpacePrefix, nameSpaceURI, this.fileId);
                            attributes.add(namespaceId);
                        }
                        String name = parser.getLocalName();
                        TrapWriter.Label elementId = this.populator.insertElement(name, element.elementId, element.elementIndex, this.fileId);
                        nameSpaceURI = parser.getName().getNamespaceURI();
                        if (nameSpaceURI != null && nameSpaceURI.length() > 0) {
                            namespaceId = this.populator.getNamespaceID(nameSpaceURI);
                            this.populator.insertHasNamespace(elementId, namespaceId, this.fileId);
                        }
                        element.incrementElementIndex();
                        int attrCount = parser.getAttributeCount();
                        for (int i = 0; i < attrCount; ++i) {
                            String qName = parser.getAttributeLocalName(i);
                            String value = parser.getAttributeValue(i);
                            String nsURI = parser.getAttributeName(i).getNamespaceURI();
                            TrapWriter.Label attributeId = this.populator.insertAttribute(elementId, qName, value, i, this.fileId);
                            attributes.add(attributeId);
                            if (nsURI == null || nsURI.length() <= 0) continue;
                            TrapWriter.Label namespaceId2 = this.populator.getNamespaceID(nsURI);
                            this.populator.insertHasNamespace(attributeId, namespaceId2, this.fileId);
                        }
                        XMLElement elem = new XMLElement(elementId, attributes, startLocation, name);
                        this.stack.push(elem);
                        nextEvent = this.parse(parser);
                        endLocation = parser.getLocation();
                        elem.setEndLocation(endLocation);
                        break;
                    }
                    case 2: {
                        XMLElement element = this.stack.pop();
                        this.populateCharacters(element);
                        nextEvent = this.parse(parser);
                        endLocation = parser.getLocation();
                        startLocation = element.startLocation;
                        this.populator.insertLocation(element.elementId, this.fileId, startLocation, endLocation);
                        int childCommentLines = StAXXmlPopulator.popOrZero(commentLines);
                        int parentCommentLines = StAXXmlPopulator.popOrZero(commentLines);
                        int totalCommentLines = childCommentLines + parentCommentLines;
                        int codeLines = StAXXmlPopulator.linesBetween(element.startLocation, endLocation);
                        this.populator.insertNumlines(element.elementId, codeLines, codeLines, totalCommentLines);
                        commentLines.push(totalCommentLines);
                        if (element.attributes == null) break;
                        if (element.startLocation.getCharacterOffset() != element.endLocation.getCharacterOffset()) {
                            endLocation = element.endLocation;
                        }
                        for (TrapWriter.Label attributeId : element.attributes) {
                            this.populator.insertLocation(attributeId, this.fileId, startLocation, endLocation);
                        }
                        break;
                    }
                    case 4: 
                    case 6: 
                    case 12: {
                        boolean isCDATA;
                        XMLElement element = this.stack.peek();
                        boolean bl = isCDATA = event == 12;
                        if (isCDATA ^ element.characters.currentSet.isCDATA) {
                            element.characters.startNew();
                        }
                        String characters = parser.getText();
                        startLocation = parser.getLocation();
                        nextEvent = this.parse(parser);
                        endLocation = parser.getLocation();
                        element.characters.append(characters, startLocation, endLocation, isCDATA);
                        break;
                    }
                    case 5: {
                        XMLElement element = this.stack.peek();
                        element.characters.startNew();
                        String text = parser.getText();
                        TrapWriter.Label commentId = this.populator.insertComment(text, element.elementId, this.fileId);
                        startLocation = parser.getLocation();
                        nextEvent = this.parse(parser);
                        endLocation = parser.getLocation();
                        int thisCommentLines = StAXXmlPopulator.linesBetween(startLocation, endLocation);
                        commentLines.push(StAXXmlPopulator.popOrZero(commentLines) + thisCommentLines);
                        this.populator.insertLocation(commentId, this.fileId, startLocation, endLocation);
                        this.populator.insertNumlines(commentId, thisCommentLines, 0, thisCommentLines);
                        break;
                    }
                    default: {
                        nextEvent = this.parse(parser);
                        endLocation = parser.getLocation();
                    }
                }
                lastLine = Math.max(lastLine, endLocation.getLineNumber());
                startLocation = endLocation;
                event = nextEvent;
            }
            parser.close();
        }
        catch (FileNotFoundException e) {
            throw new ResourceError("Error opening file " + this.file, e);
        }
        catch (IOException | XMLStreamException e) {
            throw new ResourceError("Error reading file " + this.file.getAbsolutePath(), e);
        }
    }

    public static XMLStreamReader newXMLStreamReader(InputStream input) throws XMLStreamException {
        WstxInputFactory factory = new WstxInputFactory();
        factory.configureForSpeed();
        ((XMLInputFactory)factory).setProperty("javax.xml.stream.isCoalescing", Boolean.FALSE);
        ((XMLInputFactory)factory).setProperty("javax.xml.stream.isValidating", Boolean.FALSE);
        ((XMLInputFactory)factory).setProperty("javax.xml.stream.isNamespaceAware", Boolean.TRUE);
        ((XMLInputFactory)factory).setProperty("javax.xml.stream.isReplacingEntityReferences", Boolean.FALSE);
        ((XMLInputFactory)factory).setProperty("javax.xml.stream.resolver", new NonResolvingXMLResolver());
        ((XMLInputFactory)factory).setProperty("javax.xml.stream.supportDTD", Boolean.TRUE);
        return ((XMLInputFactory)factory).createXMLStreamReader(input);
    }

    private static int popOrZero(Stack<Integer> stack) {
        return stack.isEmpty() ? 0 : stack.pop();
    }

    private static int linesBetween(Location startLocation, Location endLocation) {
        return endLocation.getLineNumber() - startLocation.getLineNumber() + 1;
    }

    private boolean handleUnexpectedCloseTag(BasicStreamReader parser, XMLStreamException e) {
        Matcher m = unexpectedCloseTagMsg.matcher(e.getMessage());
        if (m.find()) {
            String tag = m.group(1);
            for (int i = this.stack.size() - 1; i >= 0; --i) {
                if (!tag.equals(((XMLElement)this.stack.get((int)i)).name)) continue;
                int pops = this.stack.size() - i;
                this.deferredEndElems = pops--;
                InputElementStack parserstack = parser.getInputElementStack();
                try {
                    if (this.lastParsedEvent == 2) {
                        // empty if block
                    }
                    while (pops > 0 && !parserstack.isEmpty()) {
                        String name = parserstack.getLocalName();
                        parserstack.pop();
                        if (!tag.equals(name)) {
                            --pops;
                            continue;
                        }
                        break;
                    }
                }
                catch (XMLStreamException e1) {
                    Exceptions.ignore(e1, "Ignore this, as we're already in error recovery.");
                }
                return true;
            }
        }
        return false;
    }

    private int parse(BasicStreamReader parser) {
        if (this.deferredEndElems > 0) {
            --this.deferredEndElems;
            return 2;
        }
        int nextEvent = 8;
        boolean lookahead = true;
        boolean recovering = false;
        Location lastLocation = parser.getLocation();
        while (lookahead) {
            try {
                lastLocation = parser.getLocation();
                if (recovering && this.lastParsedEvent == 2) {
                    parser.getInputElementStack().push(null, "dummy");
                }
                nextEvent = parser.next();
                lookahead = false;
            }
            catch (WstxEOFException e) {
                Exceptions.ignore(e, "WstxEOFException is treated as an END_DOCUMENT event.");
                nextEvent = 8;
                break;
            }
            catch (XMLStreamException e) {
                if (!recovering) {
                    String msg = e.getMessage();
                    if (logger.isDebugEnabled()) {
                        logger.warn("Parsing error in file {}: {}", this.file.getAbsolutePath(), msg, e);
                    } else {
                        logger.warn("Parsing error in file {}: {}", (Object)this.file.getAbsolutePath(), (Object)msg);
                    }
                }
                if (this.handleUnexpectedCloseTag(parser, e)) {
                    --this.deferredEndElems;
                    return 2;
                }
                recovering = true;
                Location newLocation = parser.getLocation();
                if (newLocation != null && lastLocation != null && newLocation.getCharacterOffset() != lastLocation.getCharacterOffset()) continue;
                break;
            }
        }
        this.lastParsedEvent = nextEvent;
        return nextEvent;
    }

    private void populateCharacters(XMLElement element) {
        int i = 0;
        for (XMLCharacterSet charSet : element.characters.sets) {
            String characters = charSet.buf.toString();
            if (WS.matcher(characters).matches()) continue;
            TrapWriter.Label charactersId = this.populator.insertCharacters(characters, element.elementId, i, charSet.isCDATA, this.fileId);
            this.populator.insertLocation(charactersId, this.fileId, charSet.startLocation, charSet.endLocation);
            ++i;
        }
    }

    private static class XMLElement {
        TrapWriter.Label elementId;
        ArrayList<TrapWriter.Label> attributes;
        Location startLocation;
        Location endLocation;
        String name;
        int elementIndex = 0;
        XMLCharacterSets characters = new XMLCharacterSets();

        XMLElement(TrapWriter.Label elementId2, ArrayList<TrapWriter.Label> attributes2, Location startLocation, String name) {
            this.elementId = elementId2;
            this.attributes = attributes2;
            this.startLocation = startLocation;
            this.name = name;
        }

        void setEndLocation(Location endLocation) {
            this.endLocation = endLocation;
        }

        void incrementElementIndex() {
            ++this.elementIndex;
        }
    }

    private static class XMLCharacterSets {
        ArrayList<XMLCharacterSet> sets = new ArrayList();
        XMLCharacterSet currentSet = null;
        boolean isNew = false;

        public XMLCharacterSets() {
            this.startNew();
        }

        public void startNew() {
            if (!this.isNew) {
                this.currentSet = new XMLCharacterSet();
                this.sets.add(this.currentSet);
                this.isNew = true;
            }
        }

        public void append(String string, Location startLocation, Location endLocation, boolean isCDATA) {
            this.currentSet.append(string, startLocation, endLocation, isCDATA);
            this.isNew = false;
        }
    }

    private static class XMLCharacterSet {
        Location startLocation;
        Location endLocation;
        StringBuffer buf = new StringBuffer();
        boolean isCDATA = false;

        private XMLCharacterSet() {
        }

        void append(String string, Location startLocation, Location endLocation, boolean isCDATA) {
            this.buf.append(string);
            if (this.startLocation == null) {
                this.startLocation = startLocation;
            }
            this.endLocation = endLocation;
            this.isCDATA = isCDATA;
        }
    }
}

