/*
 * Decompiled with CFR 0.152.
 */
package com.semmle.util.array;

import com.semmle.util.basic.ObjectUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

public class ArrayUtil {
    public static final int MAX_ARRAY_LENGTH = 0x7FFFFFF7;

    public static int findFirst(boolean[] array, boolean value) {
        for (int i = 0; i < array.length; ++i) {
            if (value != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static int findFirst(byte[] array, byte value) {
        for (int i = 0; i < array.length; ++i) {
            if (value != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static int findFirst(char[] array, char value) {
        for (int i = 0; i < array.length; ++i) {
            if (value != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static int findFirst(double[] array, double value) {
        for (int i = 0; i < array.length; ++i) {
            if (value != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static int findFirst(float[] array, float value) {
        for (int i = 0; i < array.length; ++i) {
            if (value != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static int findFirst(int[] array, int value) {
        for (int i = 0; i < array.length; ++i) {
            if (value != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static <T> int findFirst(T[] array, T value) {
        for (int i = 0; i < array.length; ++i) {
            if (!ObjectUtil.equals(value, array[i])) continue;
            return i;
        }
        return -1;
    }

    public static <T> int findFirstSame(T[] array, T value) {
        for (int i = 0; i < array.length; ++i) {
            if (value != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static boolean contains(int element, int ... array) {
        return ArrayUtil.findFirst(array, element) != -1;
    }

    @SafeVarargs
    public static <T> boolean contains(T element, T ... array) {
        return ArrayUtil.findFirst(array, element) != -1;
    }

    public static <T> T[] append(T[] array, T element) {
        array = Arrays.copyOf(array, array.length + 1);
        array[array.length - 1] = element;
        return array;
    }

    public static byte[] concatenate(byte[] ... arrays) {
        if (arrays == null) {
            return null;
        }
        int totalLength = 0;
        for (byte[] array : arrays) {
            totalLength += array == null ? 0 : array.length;
        }
        byte[] concatenation = new byte[totalLength];
        int offset = 0;
        for (byte[] array : arrays) {
            if (array == null) continue;
            System.arraycopy(array, 0, concatenation, offset, array.length);
            offset += array.length;
        }
        return concatenation;
    }

    public static <T> T[] toArray(T ... elements) {
        return elements;
    }

    public static int[] swap(int[] array, int index1, int index2) {
        int value = array[index1];
        array[index1] = array[index2];
        array[index2] = value;
        return array;
    }

    @SafeVarargs
    public static <T> Set<T> asSet(T ... array) {
        LinkedHashSet ts = new LinkedHashSet();
        Collections.addAll(ts, array);
        return ts;
    }

    public static interface IntComparator {
        public int compare(int var1, int var2);
    }
}

