/*
 * Decompiled with CFR 0.152.
 */
package com.semmle.util.basic;

public class ObjectUtil {
    public static boolean isSame(Object object1, Object object2) {
        return object1 == object2;
    }

    public static boolean equals(Object object1, Object object2) {
        return object1 == null ? object2 == null : object1.equals(object2);
    }

    public static boolean equalsAny(Object object, Object ... objects) {
        if (objects == null || objects.length == 0) {
            return false;
        }
        for (Object other : objects) {
            if (!ObjectUtil.equals(object, other)) continue;
            return true;
        }
        return false;
    }

    public static <T1, T2 extends T1> int compareTo(Comparable<T1> object1, T2 object2) {
        if (object1 == null) {
            return object2 == null ? 0 : 1;
        }
        return object1.compareTo(object2);
    }

    public static <T> T replaceNull(T value, T replacement) {
        return value == null ? replacement : value;
    }

    @SafeVarargs
    public static <T> T nullCoalesce(T ... values) {
        for (T value : values) {
            if (value == null) continue;
            return value;
        }
        return null;
    }
}

