/*
 * Decompiled with CFR 0.152.
 */
package com.semmle.util.exception;

import com.semmle.util.exception.NestedError;
import java.util.Arrays;

public class CatastrophicError
extends NestedError {
    private static final long serialVersionUID = 4132771414092814913L;

    public CatastrophicError(String message) {
        super(message);
    }

    public CatastrophicError(Throwable throwable) {
        super(throwable);
    }

    public CatastrophicError(String message, Throwable throwable) {
        super(message, throwable);
    }

    public static void throwIf(boolean condition, String message) {
        if (condition) {
            throw new CatastrophicError(message);
        }
    }

    public static void throwIfNull(Object object) {
        if (object == null) {
            throw new CatastrophicError("null object");
        }
    }

    public static void throwIfNull(Object object, String message) {
        if (object == null) {
            throw new CatastrophicError(message);
        }
    }

    public static void throwIfAnyNull(Object ... objects) {
        String[] nullArgs = null;
        for (int argNum = 0; argNum < objects.length; ++argNum) {
            if (objects[argNum] != null) continue;
            nullArgs = nullArgs == null ? new String[1] : Arrays.copyOf(nullArgs, nullArgs.length + 1);
            nullArgs[nullArgs.length - 1] = "" + argNum;
        }
        if (nullArgs != null) {
            StringBuffer strBuf = new StringBuffer();
            if (nullArgs.length == 0) {
                strBuf.append("null argument(s)");
            } else {
                strBuf.append("null argument" + (nullArgs.length > 1 ? "s: " : ": ") + nullArgs[0]);
                for (int i = 1; i < nullArgs.length; ++i) {
                    strBuf.append(", " + nullArgs[i]);
                }
            }
            String message = strBuf.toString();
            throw new CatastrophicError(message);
        }
    }

    public static <T> T nonNull(T t) {
        CatastrophicError.throwIfNull(t);
        return t;
    }
}

