/*
 * Decompiled with CFR 0.152.
 */
package com.semmle.util.exception;

import com.semmle.util.exception.CatastrophicError;
import java.io.PrintWriter;
import java.io.StringWriter;

public class Exceptions {
    public static String printStackTrace(Throwable t) {
        StringWriter stringWriter = new StringWriter();
        t.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }

    public static String print(Throwable t) {
        return Exceptions.printDetailed(t, true);
    }

    public static String printShort(Throwable t) {
        return Exceptions.printDetailed(t, false);
    }

    public static void ignore(Throwable e, String message) {
    }

    private static String printDetailed(Throwable t, boolean multiline) {
        StringBuilder sb = new StringBuilder();
        Throwable current = t;
        while (current != null) {
            Exceptions.printOneException(current, multiline, sb);
            Throwable cause = current.getCause();
            if ((current = cause == current ? null : cause) == null) continue;
            if (multiline) {
                sb.append("\n\n ... caused by:\n\n");
                continue;
            }
            sb.append(", caused by: ");
        }
        return sb.toString();
    }

    private static void printOneException(Throwable t, boolean multiline, StringBuilder sb) {
        sb.append(multiline ? t.toString() : t.toString().replace('\n', ' ').replace('\r', ' '));
        boolean first = true;
        for (StackTraceElement e : t.getStackTrace()) {
            if (first) {
                sb.append(multiline ? "\n" : " - [");
            } else {
                sb.append(multiline ? "\n" : ", ");
            }
            first = false;
            sb.append(e.toString());
        }
        if (!multiline) {
            sb.append("]");
        }
    }

    public static void assertion(boolean cond, String message) {
        if (!cond) {
            throw new CatastrophicError(message);
        }
    }

    public static RuntimeException asUnchecked(Throwable t) {
        if (t instanceof RuntimeException) {
            return (RuntimeException)t;
        }
        return new RuntimeException(t);
    }

    public static <T> T rethrowUnchecked(Throwable t) {
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        throw new RuntimeException(t);
    }
}

