/*
 * Decompiled with CFR 0.152.
 */
package com.semmle.util.expansion;

import com.semmle.util.data.StringUtil;
import com.semmle.util.exception.CatastrophicError;
import com.semmle.util.exception.UserError;
import com.semmle.util.files.FileUtil;
import com.semmle.util.process.Builder;
import com.semmle.util.process.LeakPrevention;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ExpansionEnvironment {
    private static final String SEMMLE_CREDENTIALS_PASSWORD = "semmle_credentials_password";
    public static final String SEMMLE_CREDENTIALS_FILE = "semmle_credentials_file";
    private final Map<String, String> vars = new LinkedHashMap<String, String>();
    private final Set<String> unexpandedVars = new LinkedHashSet<String>();
    private final boolean commandSubstitutions;

    public ExpansionEnvironment(boolean commandSubstitutions) {
        this.commandSubstitutions = commandSubstitutions;
    }

    @Deprecated
    public ExpansionEnvironment() {
        this(true);
    }

    public ExpansionEnvironment(boolean commandSubstitutions, Map<String, String> vars) {
        this(commandSubstitutions);
        this.vars.putAll(vars);
    }

    public ExpansionEnvironment(ExpansionEnvironment other) {
        this(other.commandSubstitutions);
        this.vars.putAll(other.vars);
        this.unexpandedVars.addAll(other.unexpandedVars);
    }

    public void defineVars(Map<String, String> vars) {
        this.vars.putAll(vars);
    }

    public void defineVar(String name, String value) {
        this.vars.put(name, value);
    }

    public void doNotExpand(String ... vars) {
        for (String var : vars) {
            this.unexpandedVars.add(var);
        }
    }

    public void setDefault(String var, String defaultValue) {
        if (!this.vars.containsKey(var)) {
            this.vars.put(var, defaultValue);
        }
    }

    public String strExpand(String s) {
        try {
            return new Expander().new Expander.ExpansionParser(s).parseAsString().expandAsString();
        }
        catch (UserError e) {
            throw new UserError("Failed to expand '" + s + "'.", e);
        }
    }

    public List<String> listExpand(String s) {
        try {
            return new Expander().new Expander.ExpansionParser(s).parseAsList().expandAsList();
        }
        catch (UserError e) {
            throw new UserError("Failed to expand '" + s + "' as an argument list.", e);
        }
    }

    public String strExpandVar(String varName) {
        return new Expander().new Expander.Variable(varName).expandAsString();
    }

    public List<String> listExpandVar(String varName) {
        return new Expander().new Expander.SplitVariable(varName).expandAsList();
    }

    public void validate(String str) {
        new Expander().new Expander.ExpansionParser(str).parseAsList().validate();
    }

    public synchronized String varLookup(String name) {
        String value = this.vars.get(name);
        if (value == null) {
            ArrayList<String> available = new ArrayList<String>(this.vars.keySet());
            Collections.sort(available);
            throw new UserError("Attempting to expand unknown variable: " + name + ", available variables are: " + available);
        }
        return value;
    }

    public boolean definesVar(String name) {
        return this.vars.containsKey(name);
    }

    public File expandPath(File base, String path) {
        String expanded = this.strExpand(path);
        if (FileUtil.isAbsolute(expanded)) {
            return new File(expanded);
        }
        return FileUtil.fileRelativeTo(base, expanded);
    }

    public static String escape(String base) {
        return base.replace("$", "${}");
    }

    public static String escapeArgument(String argument) {
        return ExpansionEnvironment.escape(argument).replaceAll(Matcher.quoteReplacement("\\"), Matcher.quoteReplacement("\\\\")).replaceAll(Matcher.quoteReplacement("\""), Matcher.quoteReplacement("\\\""));
    }

    private class Expander {
        private final Set<String> expansionsInProgress = new LinkedHashSet<String>();

        private Expander() {
        }

        private class ExpansionParser {
            private final ExpansionTokeniser tokens;

            public ExpansionParser(String str) {
                this.tokens = new ExpansionTokeniser(str);
            }

            public Sentence parseAsString() {
                ArrayList<List<Expansion>> words = new ArrayList<List<Expansion>>();
                words.add(this.parseTerminatedString(null));
                return new Sentence(words);
            }

            public Sentence parseAsList() {
                return new Sentence(this.parseTerminatedList(null, false));
            }

            public Sentence splitAsString() {
                return new Sentence(this.parseTerminatedList(null, true));
            }

            private List<Expansion> parseTerminatedString(String terminator) {
                ArrayList<Expansion> result = new ArrayList<Expansion>();
                while (this.tokens.hasMoreTokens()) {
                    String next = this.tokens.nextToken();
                    if (next.equals(terminator)) {
                        return result;
                    }
                    if (next.equals("\\\"")) {
                        result.add(new Literal("\""));
                        continue;
                    }
                    if (next.equals("\\\\")) {
                        result.add(new Literal("\\"));
                        continue;
                    }
                    if (this.tryParseExpansion(result, next)) continue;
                    result.add(new Literal(next));
                }
                if (terminator != null) {
                    throw new UserError("Premature end of input while looking for matching '" + terminator + "'.");
                }
                return result;
            }

            private List<List<Expansion>> parseTerminatedList(String terminator, boolean noExpansions) {
                ArrayList<List<Expansion>> result = new ArrayList<List<Expansion>>();
                ArrayList<Expansion> accum = new ArrayList<Expansion>();
                boolean mustSeeSpace = false;
                while (this.tokens.hasMoreTokens()) {
                    String next = this.tokens.nextToken();
                    if (next.equals(terminator)) {
                        if (accum.size() > 0) {
                            result.add(accum);
                        }
                        return result;
                    }
                    if (mustSeeSpace && !Character.isWhitespace(next.charAt(0))) {
                        throw new UserError("The quoted string ending at " + this.tokens.pos() + " must be surrounded by whitespace.");
                    }
                    if (next.length() > 0 && Character.isWhitespace(next.charAt(0))) {
                        mustSeeSpace = false;
                        if (accum.size() <= 0) continue;
                        result.add(accum);
                        accum = new ArrayList();
                        continue;
                    }
                    if (next.equals("\"")) {
                        if (!accum.isEmpty()) {
                            throw new UserError("At position " + this.tokens.pos() + ", the quote should either be preceded by a space (if it is intended to start an argument) or escaped as \\\".");
                        }
                        accum.add(new QuotedString(this.parseTerminatedString("\"")));
                        result.add(accum);
                        accum = new ArrayList();
                        mustSeeSpace = true;
                        continue;
                    }
                    if (next.equals("\\\"")) {
                        accum.add(new Literal("\""));
                        continue;
                    }
                    if (next.equals("\\\\")) {
                        accum.add(new Literal("\\"));
                        continue;
                    }
                    if (!noExpansions && this.tryParseExpansion(accum, next)) continue;
                    accum.add(new Literal(next));
                }
                if (terminator != null) {
                    throw new UserError("Premature end of expansion while looking for '" + terminator + "'.");
                }
                if (accum.size() > 0) {
                    result.add(accum);
                }
                return result;
            }

            private boolean tryParseExpansion(List<Expansion> result, String curToken) {
                if (curToken.equals("${}")) {
                    result.add(new Literal("$"));
                } else if (curToken.equals("$(=") && ExpansionEnvironment.this.commandSubstitutions) {
                    result.add(new SplitCommand(this.parseTerminatedList(")", false)));
                } else if (curToken.equals("$(") && ExpansionEnvironment.this.commandSubstitutions) {
                    result.add(new Command(this.parseTerminatedList(")", false)));
                } else if (curToken.equals("${=")) {
                    result.add(new SplitVariable(this.parseVarName()));
                } else if (curToken.equals("${")) {
                    result.add(new Variable(this.parseVarName()));
                } else {
                    if (curToken.equals("$")) {
                        throw new UserError("Malformed expansion: A standalone '$' character should be escaped as '${}'.");
                    }
                    return false;
                }
                return true;
            }

            protected String parseVarName() {
                if (!this.tokens.hasMoreTokens()) {
                    throw new UserError("Malformed variable substitution: stray '${' at " + this.tokens.pos());
                }
                String name = this.tokens.nextToken();
                if (this.tokens.isDelimiter(name)) {
                    throw new UserError("Malformed variable substitution: Unexpected '" + name + "' at " + this.tokens.pos());
                }
                if (!this.tokens.hasMoreTokens()) {
                    throw new UserError("Malformed variable substitution for '" + name + "': Missing '}' at " + this.tokens.pos());
                }
                String next = this.tokens.nextToken();
                if (!next.equals("}")) {
                    throw new UserError("Malformed variable substitution: Expecting '}' at " + this.tokens.pos() + ", found '" + next + "'.");
                }
                return name;
            }
        }

        class SplitCommand
        extends Command {
            public SplitCommand(List<List<Expansion>> argv) {
                super(argv);
            }

            @Override
            public String expandAsString() {
                return StringUtil.glue(" ", this.expandAsList());
            }

            @Override
            public List<String> expandAsList() {
                return new ExpansionParser(this.run()).splitAsString().expandAsList();
            }
        }

        class Command
        extends Expansion {
            private final Sentence argv;

            public Command(List<List<Expansion>> args) {
                this.argv = new Sentence(args);
            }

            @Override
            public void validate() {
                this.argv.validate();
            }

            protected String run() {
                List<String> args = this.argv.expandAsList();
                ByteArrayOutputStream result = new ByteArrayOutputStream();
                ByteArrayOutputStream err = new ByteArrayOutputStream();
                Builder builder = new Builder(args, result, err);
                builder.setLeakPrevention(LeakPrevention.ALL);
                try {
                    int exitCode = builder.execute();
                    if (exitCode != 0) {
                        throw new UserError("Exit code " + exitCode + " from command " + builder.toString());
                    }
                    if (err.size() > 0) {
                        throw new UserError("Command \"" + builder.toString() + "\" produced output on stderr: " + err.toString());
                    }
                }
                catch (RuntimeException e) {
                    throw new UserError("Could not execute command " + builder.toString(), e);
                }
                return result.toString();
            }

            @Override
            public String expandAsString() {
                return this.run();
            }

            @Override
            public List<String> expandAsList() {
                return Collections.singletonList(this.expandAsString());
            }
        }

        class SplitVariable
        extends Variable {
            public SplitVariable(String name) {
                super(name);
            }

            @Override
            protected String ref() {
                return "${=" + this.name + "}";
            }

            @Override
            public String expandAsStringImpl() {
                return StringUtil.glue(" ", this.expandAsListImpl());
            }

            @Override
            public List<String> expandAsListImpl() {
                return ExpansionEnvironment.this.listExpand(ExpansionEnvironment.this.varLookup(this.name));
            }
        }

        class Variable
        extends Expansion {
            protected final String name;

            public Variable(String name) {
                this.name = name;
            }

            @Override
            public void validate() {
                ExpansionEnvironment.this.varLookup(this.name);
            }

            protected void startExpanding(String name) {
                if (!Expander.this.expansionsInProgress.add(name)) {
                    throw new UserError("Circular expansion of variable " + name);
                }
            }

            protected void doneWith(String name) {
                if (!Expander.this.expansionsInProgress.remove(name)) {
                    throw new CatastrophicError("Not currently expanding " + name);
                }
            }

            protected String ref() {
                return "${" + this.name + "}";
            }

            @Override
            public final String expandAsString() {
                if (ExpansionEnvironment.this.unexpandedVars.contains(this.name)) {
                    return this.ref();
                }
                this.startExpanding(this.name);
                String result = this.expandAsStringImpl();
                this.doneWith(this.name);
                return result;
            }

            public String expandAsStringImpl() {
                return new ExpansionParser(ExpansionEnvironment.this.varLookup(this.name)).parseAsString().expandAsString();
            }

            @Override
            public final List<String> expandAsList() {
                if (ExpansionEnvironment.this.unexpandedVars.contains(this.name)) {
                    return Collections.singletonList(this.ref());
                }
                this.startExpanding(this.name);
                List<String> result = this.expandAsListImpl();
                this.doneWith(this.name);
                return result;
            }

            public List<String> expandAsListImpl() {
                return Collections.singletonList(this.expandAsStringImpl());
            }
        }

        class QuotedString
        extends Sentence {
            public QuotedString(List<Expansion> content) {
                super(Collections.singletonList(content));
            }

            @Override
            public List<String> expandAsList() {
                return Collections.singletonList(this.expandAsString());
            }
        }

        class Literal
        extends Expansion {
            private final String value;

            public Literal(String value) {
                this.value = value;
            }

            @Override
            public void validate() {
            }

            @Override
            public String expandAsString() {
                return this.value;
            }

            @Override
            public List<String> expandAsList() {
                return Collections.singletonList(this.value);
            }
        }

        class Sentence
        extends Expansion {
            private final List<List<Expansion>> words;

            public Sentence(List<List<Expansion>> words) {
                this.words = new ArrayList<List<Expansion>>();
                this.words.addAll(words);
            }

            @Override
            public void validate() {
                for (List<Expansion> expansions : this.words) {
                    for (Expansion expansion : expansions) {
                        expansion.validate();
                    }
                }
            }

            private String expandWord(List<Expansion> word) {
                StringBuilder result = new StringBuilder();
                for (Expansion e : word) {
                    result.append(e.expandAsString());
                }
                return result.toString();
            }

            @Override
            public String expandAsString() {
                StringBuilder result = new StringBuilder();
                for (List<Expansion> word : this.words) {
                    if (result.length() > 0) {
                        result.append(' ');
                    }
                    result.append(this.expandWord(word));
                }
                return result.toString();
            }

            @Override
            public List<String> expandAsList() {
                ArrayList<String> result = new ArrayList<String>();
                for (List<Expansion> word : this.words) {
                    ArrayList<List<String>> segments = new ArrayList<List<String>>();
                    for (Expansion e : word) {
                        segments.add(e.expandAsList());
                    }
                    result.addAll(this.glue(segments));
                }
                return result;
            }

            private List<String> glue(List<List<String>> segments) {
                String trailingWord = null;
                ArrayList<String> result = new ArrayList<String>();
                for (List<String> segment : segments) {
                    trailingWord = this.glue_join_accum(result, segment, trailingWord);
                }
                if (trailingWord != null) {
                    result.add(trailingWord);
                }
                return result;
            }

            private String glue_join_accum(List<String> result, List<String> segment, String trailingWord) {
                int n = segment.size();
                switch (n) {
                    case 0: {
                        return trailingWord;
                    }
                    case 1: {
                        return this.combine(trailingWord, segment.get(0));
                    }
                }
                result.add(this.combine(trailingWord, segment.get(0)));
                result.addAll(segment.subList(1, n - 1));
                return segment.get(n - 1);
            }

            private String combine(String a, String b) {
                if (a == null) {
                    return b;
                }
                return a + b;
            }
        }

        abstract class Expansion {
            Expansion() {
            }

            public abstract String expandAsString();

            public abstract List<String> expandAsList();

            public abstract void validate();
        }
    }

    private static class ExpansionTokeniser {
        private static final Pattern delims = Pattern.compile("\\\\\\\\|\\\\\"|\"|\\$\\{\\}|\\$\\{=|\\$\\{|\\$\\(=|\\$\\(|\\$|\\}|\\)|\\s+");
        private final List<String> tokens = new ArrayList<String>();
        private final int[] positions;
        private int nextToken = 0;

        public ExpansionTokeniser(String str) {
            Matcher matcher = delims.matcher(str);
            StringBuffer tmp = new StringBuffer();
            while (matcher.find()) {
                matcher.appendReplacement(tmp, "");
                if (tmp.length() > 0) {
                    this.tokens.add(tmp.toString());
                    tmp = new StringBuffer();
                }
                this.tokens.add(matcher.group());
            }
            matcher.appendTail(tmp);
            if (tmp.length() > 0) {
                this.tokens.add(tmp.toString());
            }
            this.positions = new int[this.tokens.size()];
            int pos = 0;
            for (int i = 0; i < this.tokens.size(); ++i) {
                this.positions[i] = pos;
                pos += this.tokens.get(i).length();
            }
        }

        public boolean hasMoreTokens() {
            return this.nextToken < this.tokens.size();
        }

        public String nextToken() {
            return this.tokens.get(this.nextToken++);
        }

        public boolean isDelimiter(String token) {
            return delims.matcher(token).matches();
        }

        public int pos() {
            return this.positions[this.nextToken - 1] + 1;
        }
    }
}

